/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.api.Coord4D;
import mekanism.api.Range4D;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.PacketBoxBlacklist;
import mekanism.common.network.PacketConfigSync;
import mekanism.common.network.PacketConfigurationUpdate;
import mekanism.common.network.PacketContainerEditMode;
import mekanism.common.network.PacketDataRequest;
import mekanism.common.network.PacketDigitalMinerGui;
import mekanism.common.network.PacketDropperUse;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketEntityMove;
import mekanism.common.network.PacketFlamethrowerData;
import mekanism.common.network.PacketFreeRunnerData;
import mekanism.common.network.PacketItemStack;
import mekanism.common.network.PacketJetpackData;
import mekanism.common.network.PacketJumpBoostData;
import mekanism.common.network.PacketKey;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.network.PacketOredictionificatorGui;
import mekanism.common.network.PacketPortableTeleporter;
import mekanism.common.network.PacketPortalFX;
import mekanism.common.network.PacketRedstoneControl;
import mekanism.common.network.PacketRemoveUpgrade;
import mekanism.common.network.PacketRobit;
import mekanism.common.network.PacketScubaTankData;
import mekanism.common.network.PacketSecurityMode;
import mekanism.common.network.PacketSecurityUpdate;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.network.PacketStepAssistData;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.network.PacketTransmitterUpdate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;

public class PacketHandler {
    public final SimpleNetworkWrapper netHandler = NetworkRegistry.INSTANCE.newSimpleChannel("MEK");

    public static void encode(Object[] dataValues, ByteBuf output) {
        for (Object data : dataValues) {
            if (data instanceof Byte) {
                Byte b = (Byte)data;
                output.writeByte((int)b.byteValue());
                continue;
            }
            if (data instanceof Integer) {
                Integer i = (Integer)data;
                output.writeInt(i.intValue());
                continue;
            }
            if (data instanceof Short) {
                Short s = (Short)data;
                output.writeShort((int)s.shortValue());
                continue;
            }
            if (data instanceof Long) {
                Long l = (Long)data;
                output.writeLong(l.longValue());
                continue;
            }
            if (data instanceof Boolean) {
                Boolean b = (Boolean)data;
                output.writeBoolean(b.booleanValue());
                continue;
            }
            if (data instanceof Double) {
                Double d = (Double)data;
                output.writeDouble(d.doubleValue());
                continue;
            }
            if (data instanceof Float) {
                Float f = (Float)data;
                output.writeFloat(f.floatValue());
                continue;
            }
            if (data instanceof String) {
                String s = (String)data;
                PacketHandler.writeString(output, s);
                continue;
            }
            if (data instanceof EnumFacing) {
                EnumFacing f = (EnumFacing)data;
                output.writeInt(f.ordinal());
                continue;
            }
            if (data instanceof ItemStack) {
                ItemStack s = (ItemStack)data;
                PacketHandler.writeStack(output, s);
                continue;
            }
            if (data instanceof NBTTagCompound) {
                NBTTagCompound nbt = (NBTTagCompound)data;
                PacketHandler.writeNBT(output, nbt);
                continue;
            }
            if (data instanceof int[]) {
                int[] d;
                for (int i : d = (int[])data) {
                    output.writeInt(i);
                }
                continue;
            }
            if (data instanceof byte[]) {
                byte[] d;
                for (byte b : d = (byte[])data) {
                    output.writeByte((int)b);
                }
                continue;
            }
            if (data instanceof ArrayList) {
                ArrayList a = (ArrayList)data;
                PacketHandler.encode(a.toArray(), output);
                continue;
            }
            if (data instanceof NonNullList) {
                NonNullList d = (NonNullList)data;
                PacketHandler.encode(d.toArray(), output);
                continue;
            }
            throw new RuntimeException("Un-encodable data passed to encode(): " + data + ", full data: " + Arrays.toString(dataValues));
        }
    }

    public static void writeString(ByteBuf output, String s) {
        ByteBufUtils.writeUTF8String((ByteBuf)output, (String)s);
    }

    public static String readString(ByteBuf input) {
        return ByteBufUtils.readUTF8String((ByteBuf)input);
    }

    public static void writeStack(ByteBuf output, ItemStack stack) {
        ByteBufUtils.writeItemStack((ByteBuf)output, (ItemStack)stack);
    }

    public static ItemStack readStack(ByteBuf input) {
        return ByteBufUtils.readItemStack((ByteBuf)input);
    }

    public static void writeNBT(ByteBuf output, NBTTagCompound nbtTags) {
        ByteBufUtils.writeTag((ByteBuf)output, (NBTTagCompound)nbtTags);
    }

    public static NBTTagCompound readNBT(ByteBuf input) {
        return ByteBufUtils.readTag((ByteBuf)input);
    }

    public static void log(String log) {
        if (MekanismConfig.current().general.logPackets.val()) {
            Mekanism.logger.info(log);
        }
    }

    public static EntityPlayer getPlayer(MessageContext context) {
        return Mekanism.proxy.getPlayer(context);
    }

    public static void handlePacket(Runnable runnable, EntityPlayer player) {
        Mekanism.proxy.handlePacket(runnable, player);
    }

    public void initialize() {
        this.netHandler.registerMessage(PacketRobit.class, PacketRobit.RobitMessage.class, 0, Side.SERVER);
        this.netHandler.registerMessage(PacketTransmitterUpdate.class, PacketTransmitterUpdate.TransmitterUpdateMessage.class, 1, Side.CLIENT);
        this.netHandler.registerMessage(PacketItemStack.class, PacketItemStack.ItemStackMessage.class, 4, Side.SERVER);
        this.netHandler.registerMessage(PacketTileEntity.class, PacketTileEntity.TileEntityMessage.class, 5, Side.CLIENT);
        this.netHandler.registerMessage(PacketTileEntity.class, PacketTileEntity.TileEntityMessage.class, 5, Side.SERVER);
        this.netHandler.registerMessage(PacketPortalFX.class, PacketPortalFX.PortalFXMessage.class, 6, Side.CLIENT);
        this.netHandler.registerMessage(PacketDataRequest.class, PacketDataRequest.DataRequestMessage.class, 7, Side.SERVER);
        this.netHandler.registerMessage(PacketOredictionificatorGui.class, PacketOredictionificatorGui.OredictionificatorGuiMessage.class, 8, Side.CLIENT);
        this.netHandler.registerMessage(PacketOredictionificatorGui.class, PacketOredictionificatorGui.OredictionificatorGuiMessage.class, 8, Side.SERVER);
        this.netHandler.registerMessage(PacketSecurityMode.class, PacketSecurityMode.SecurityModeMessage.class, 9, Side.SERVER);
        this.netHandler.registerMessage(PacketPortableTeleporter.class, PacketPortableTeleporter.PortableTeleporterMessage.class, 10, Side.CLIENT);
        this.netHandler.registerMessage(PacketPortableTeleporter.class, PacketPortableTeleporter.PortableTeleporterMessage.class, 10, Side.SERVER);
        this.netHandler.registerMessage(PacketRemoveUpgrade.class, PacketRemoveUpgrade.RemoveUpgradeMessage.class, 11, Side.SERVER);
        this.netHandler.registerMessage(PacketRedstoneControl.class, PacketRedstoneControl.RedstoneControlMessage.class, 12, Side.SERVER);
        this.netHandler.registerMessage(PacketLogisticalSorterGui.class, PacketLogisticalSorterGui.LogisticalSorterGuiMessage.class, 14, Side.CLIENT);
        this.netHandler.registerMessage(PacketLogisticalSorterGui.class, PacketLogisticalSorterGui.LogisticalSorterGuiMessage.class, 14, Side.SERVER);
        this.netHandler.registerMessage(PacketNewFilter.class, PacketNewFilter.NewFilterMessage.class, 15, Side.SERVER);
        this.netHandler.registerMessage(PacketEditFilter.class, PacketEditFilter.EditFilterMessage.class, 16, Side.SERVER);
        this.netHandler.registerMessage(PacketConfigurationUpdate.class, PacketConfigurationUpdate.ConfigurationUpdateMessage.class, 17, Side.SERVER);
        this.netHandler.registerMessage(PacketSimpleGui.class, PacketSimpleGui.SimpleGuiMessage.class, 18, Side.CLIENT);
        this.netHandler.registerMessage(PacketSimpleGui.class, PacketSimpleGui.SimpleGuiMessage.class, 18, Side.SERVER);
        this.netHandler.registerMessage(PacketDigitalMinerGui.class, PacketDigitalMinerGui.DigitalMinerGuiMessage.class, 19, Side.CLIENT);
        this.netHandler.registerMessage(PacketDigitalMinerGui.class, PacketDigitalMinerGui.DigitalMinerGuiMessage.class, 19, Side.SERVER);
        this.netHandler.registerMessage(PacketJetpackData.class, PacketJetpackData.JetpackDataMessage.class, 20, Side.CLIENT);
        this.netHandler.registerMessage(PacketJetpackData.class, PacketJetpackData.JetpackDataMessage.class, 20, Side.SERVER);
        this.netHandler.registerMessage(PacketKey.class, PacketKey.KeyMessage.class, 21, Side.SERVER);
        this.netHandler.registerMessage(PacketScubaTankData.class, PacketScubaTankData.ScubaTankDataMessage.class, 22, Side.CLIENT);
        this.netHandler.registerMessage(PacketScubaTankData.class, PacketScubaTankData.ScubaTankDataMessage.class, 22, Side.SERVER);
        this.netHandler.registerMessage(PacketConfigSync.class, PacketConfigSync.ConfigSyncMessage.class, 23, Side.CLIENT);
        this.netHandler.registerMessage(PacketBoxBlacklist.class, PacketBoxBlacklist.BoxBlacklistMessage.class, 24, Side.CLIENT);
        this.netHandler.registerMessage(PacketContainerEditMode.class, PacketContainerEditMode.ContainerEditModeMessage.class, 26, Side.SERVER);
        this.netHandler.registerMessage(PacketFlamethrowerData.class, PacketFlamethrowerData.FlamethrowerDataMessage.class, 27, Side.CLIENT);
        this.netHandler.registerMessage(PacketFlamethrowerData.class, PacketFlamethrowerData.FlamethrowerDataMessage.class, 27, Side.SERVER);
        this.netHandler.registerMessage(PacketDropperUse.class, PacketDropperUse.DropperUseMessage.class, 28, Side.SERVER);
        this.netHandler.registerMessage(PacketEntityMove.class, PacketEntityMove.EntityMoveMessage.class, 29, Side.CLIENT);
        this.netHandler.registerMessage(PacketSecurityUpdate.class, PacketSecurityUpdate.SecurityUpdateMessage.class, 30, Side.CLIENT);
        this.netHandler.registerMessage(PacketFreeRunnerData.class, PacketFreeRunnerData.FreeRunnerDataMessage.class, 31, Side.CLIENT);
        this.netHandler.registerMessage(PacketFreeRunnerData.class, PacketFreeRunnerData.FreeRunnerDataMessage.class, 31, Side.SERVER);
        this.netHandler.registerMessage(PacketJumpBoostData.class, PacketJumpBoostData.JumpBoostDataMessage.class, 32, Side.CLIENT);
        this.netHandler.registerMessage(PacketJumpBoostData.class, PacketJumpBoostData.JumpBoostDataMessage.class, 32, Side.SERVER);
        this.netHandler.registerMessage(PacketStepAssistData.class, PacketStepAssistData.StepAssistDataMessage.class, 33, Side.CLIENT);
        this.netHandler.registerMessage(PacketStepAssistData.class, PacketStepAssistData.StepAssistDataMessage.class, 33, Side.SERVER);
    }

    public synchronized void sendTo(IMessage message, EntityPlayerMP player) {
        this.netHandler.sendTo(message, player);
    }

    public synchronized void sendToAll(IMessage message) {
        this.netHandler.sendToAll(message);
    }

    public synchronized void sendToAllAround(IMessage message, NetworkRegistry.TargetPoint point) {
        this.netHandler.sendToAllAround(message, point);
    }

    public synchronized void sendToDimension(IMessage message, int dimensionId) {
        this.netHandler.sendToDimension(message, dimensionId);
    }

    public void sendToServer(IMessage message) {
        this.netHandler.sendToServer(message);
    }

    public synchronized void sendToCuboid(IMessage message, AxisAlignedBB cuboid, int dimId) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null && cuboid != null) {
            for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                if (player.field_71093_bK != dimId || !cuboid.func_72318_a(new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v))) continue;
                this.sendTo(message, player);
            }
        }
    }

    public <TILE extends TileEntity> void sendUpdatePacket(TILE tile) {
        this.sendToAllTracking((IMessage)new PacketTileEntity.TileEntityMessage(tile), tile);
    }

    public void sendToAllTracking(IMessage message, TileEntity tile) {
        BlockPos pos = tile.func_174877_v();
        this.sendToAllTracking(message, tile.func_145831_w().field_73011_w.getDimension(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public void sendToAllTracking(IMessage message, Coord4D point) {
        this.sendToAllTracking(message, point.dimensionId, point.x, point.y, point.z);
    }

    public void sendToAllTracking(IMessage message, int dimension, double x, double y, double z) {
        this.sendToAllTracking(message, new NetworkRegistry.TargetPoint(dimension, x, y, z, 1.0));
    }

    public synchronized void sendToAllTracking(IMessage message, NetworkRegistry.TargetPoint point) {
        this.netHandler.sendToAllTracking(message, point);
    }

    public void sendToReceivers(IMessage message, Range4D range) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server != null) {
            for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                if (!range.hasPlayerInRange(player)) continue;
                this.sendTo(message, player);
            }
        }
    }

    @Nonnull
    public static UUID readUUID(ByteBuf dataStream) {
        return new UUID(dataStream.readLong(), dataStream.readLong());
    }

    public static void writeUUID(ByteBuf dataStream, UUID uuid) {
        dataStream.writeLong(uuid.getMostSignificantBits());
        dataStream.writeLong(uuid.getLeastSignificantBits());
    }
}

