/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.OreGas;
import mekanism.common.Resource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;

public class MekanismFluids {
    public static final Gas Hydrogen = new Gas("hydrogen", 0xFFFFFF);
    public static final Gas Oxygen = new Gas("oxygen", 7135999);
    public static final Gas Water = new Gas("water", "mekanism:blocks/liquid/LiquidSteam");
    public static final Gas Chlorine = new Gas("chlorine", 13625344);
    public static final Gas SulfurDioxide = new Gas("sulfurdioxide", 11115920);
    public static final Gas SulfurTrioxide = new Gas("sulfurtrioxide", 0xCE6C6C);
    public static final Gas SulfuricAcid = new Gas("sulfuricacid", 8552491);
    public static final Gas HydrogenChloride = new Gas("hydrogenchloride", 11071977);
    public static final Fluid HeavyWater = new Fluid("heavywater", new ResourceLocation("mekanism", "blocks/liquid/LiquidHeavyWater"), new ResourceLocation("mekanism", "blocks/liquid/LiquidHeavyWater"));
    public static final Fluid Steam = new Fluid("steam", new ResourceLocation("mekanism", "blocks/liquid/LiquidSteam"), new ResourceLocation("mekanism", "blocks/liquid/LiquidSteam")).setGaseous(true);
    public static final Gas LiquidOsmium = new Gas("liquidosmium", 5422538);
    public static final Gas Ethene = new Gas("ethene", 15387897);
    public static final Gas Sodium = new Gas("sodium", 15335156);
    public static final Gas Brine = new Gas("brine", 16707484);
    public static final Gas Deuterium = new Gas("deuterium", 0xFF3232);
    public static final Gas Tritium = new Gas("tritium", 6618992);
    public static final Gas FusionFuel = new Gas("fusionfuel", 8257661);
    public static final Gas Lithium = new Gas("lithium", 15442944);
    public static final Gas HydrofluoricAcid = new Gas("hydrofluoricacid", -3749955);
    public static final Gas Antimatter = new Gas("antimatter", 10773683);
    public static final Gas FissileFuel = new Gas("fissilefuel", 3027759);
    public static final Gas SuperheatedSodium = new Gas("superheatedsodium", -3042199);
    public static final Gas UraniumHexafluoride = new Gas("uraniumhexafluoride", -8349344);
    public static final Gas Uraniumoxide = new Gas("uraniumoxide", -1968781);
    public static final Gas NuclearWaste = new Gas("nuclearwaste", 5194026);
    public static final Gas Plutonium = new Gas("plutonium", 2068892);
    public static final Gas Polonium = new Gas("polonium", 1810043);
    public static final Gas SpentNuclearWaste = new Gas("spentnuclearwaste", 2498581);
    public static final Gas Biofuel = new Gas("Biofuel", 10342945);
    public static final Gas NutritionalPaste = new Gas("nutritionalpaste", 15428771);
    public static final Gas WHITE = new Gas("white.name", 0xF9FFFE);
    public static final Gas ORANGE = new Gas("orange.name", 16351261);
    public static final Gas MAGENTA = new Gas("magenta.name", 13061821);
    public static final Gas LIGHT_BLUE = new Gas("lightBlue.name", 3847130);
    public static final Gas YELLOW = new Gas("yellow.name", 16701501);
    public static final Gas LIME = new Gas("lime.name", 8439583);
    public static final Gas PINK = new Gas("pink.name", 15961002);
    public static final Gas GRAY = new Gas("gray.name", 4673362);
    public static final Gas SILVER = new Gas("silver.name", 0x9D9D97);
    public static final Gas CYAN = new Gas("cyan.name", 1481884);
    public static final Gas PURPLE = new Gas("purple.name", 8991416);
    public static final Gas BLUE = new Gas("blue.name", 3949738);
    public static final Gas BROWN = new Gas("brown.name", 8606770);
    public static final Gas GREEN = new Gas("green.name", 6192150);
    public static final Gas RED = new Gas("red.name", 11546150);
    public static final Gas BLACK = new Gas("black.name", 0x1D1D21);
    public static final Gas NutrientSolution = new Gas("nutrientsolution", 1810043);
    public static final Gas OxygenEnrichedWater = new Gas("oxygenenrichedwater", 7135999);
    public static final Gas UnstableDimensional = new Gas("unstabledimensional", 16751642);

    public static void register() {
        GasRegistry.register(Hydrogen).registerFluid("liquidhydrogen");
        GasRegistry.register(Oxygen).registerFluid("liquidoxygen");
        GasRegistry.register(Water).registerFluid();
        GasRegistry.register(Chlorine).registerFluid("liquidchlorine");
        GasRegistry.register(SulfurDioxide).registerFluid("liquidsulfurdioxide");
        GasRegistry.register(SulfurTrioxide).registerFluid("liquidsulfurtrioxide");
        GasRegistry.register(SulfuricAcid).registerFluid();
        GasRegistry.register(HydrogenChloride).registerFluid("liquidhydrogenchloride");
        GasRegistry.register(Ethene).registerFluid("liquidethene");
        GasRegistry.register(Sodium).registerFluid("liquidsodium");
        GasRegistry.register(Brine).registerFluid();
        GasRegistry.register(Deuterium).registerFluid("liquiddeuterium");
        GasRegistry.register(Tritium).registerFluid("liquidtritium");
        GasRegistry.register(FusionFuel).registerFluid("liquidfusionfuel");
        GasRegistry.register(Lithium).registerFluid("liquidlithium");
        GasRegistry.register(LiquidOsmium).setVisible(false);
        GasRegistry.register(HydrofluoricAcid).registerFluid("liquidhydrofluricacid");
        GasRegistry.register(Antimatter);
        GasRegistry.register(FissileFuel);
        GasRegistry.register(SuperheatedSodium).registerFluid("liquidsuperheatedsodium");
        GasRegistry.register(UraniumHexafluoride);
        GasRegistry.register(Uraniumoxide);
        GasRegistry.register(NutritionalPaste);
        GasRegistry.register(NuclearWaste).setRadiation(true);
        GasRegistry.register(Plutonium).setRadiation(true);
        GasRegistry.register(Polonium).setRadiation(true);
        GasRegistry.register(SpentNuclearWaste).setRadiation(true);
        GasRegistry.register(Biofuel).setVisible(false);
        GasRegistry.register(WHITE);
        GasRegistry.register(ORANGE);
        GasRegistry.register(MAGENTA);
        GasRegistry.register(LIGHT_BLUE);
        GasRegistry.register(YELLOW);
        GasRegistry.register(LIME);
        GasRegistry.register(PINK);
        GasRegistry.register(GRAY);
        GasRegistry.register(SILVER);
        GasRegistry.register(CYAN);
        GasRegistry.register(PURPLE);
        GasRegistry.register(BLUE);
        GasRegistry.register(BROWN);
        GasRegistry.register(GREEN);
        GasRegistry.register(RED);
        GasRegistry.register(BLACK);
        GasRegistry.register(NutrientSolution);
        GasRegistry.register(OxygenEnrichedWater);
        GasRegistry.register(UnstableDimensional);
        FluidRegistry.registerFluid((Fluid)HeavyWater);
        FluidRegistry.registerFluid((Fluid)Steam);
        for (Resource resource : Resource.values()) {
            String name = resource.getName();
            String nameLower = name.toLowerCase(Locale.ROOT);
            OreGas clean = new OreGas("clean" + name, "oregas." + nameLower, resource.tint);
            GasRegistry.register(clean);
            GasRegistry.register(new OreGas(nameLower, "oregas." + nameLower, resource.tint, clean));
        }
        FluidRegistry.enableUniversalBucket();
        FluidRegistry.addBucketForFluid((Fluid)HeavyWater);
        List list = GasRegistry.getRegisteredGasses().stream().filter(Gas::isRegisterFluid).map(g -> new GasStack((Gas)g, 1000)).collect(Collectors.toList());
        for (GasStack gas : list) {
            FluidRegistry.addBucketForFluid((Fluid)gas.getGas().getFluid());
        }
    }
}

