/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import com.mojang.authlib.GameProfile;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.api.MekanismAPI;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.TransmitterNetworkRegistry;
import mekanism.client.ClientTickHandler;
import mekanism.common.BoxBlacklistParser;
import mekanism.common.CommonPlayerTickHandler;
import mekanism.common.CommonPlayerTracker;
import mekanism.common.CommonProxy;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.CoreGuiHandler;
import mekanism.common.CreativeTabMekanism;
import mekanism.common.CreativeTabMekanismAddition;
import mekanism.common.KeySync;
import mekanism.common.MekFakePlayer;
import mekanism.common.MekanismBlocks;
import mekanism.common.MekanismFluids;
import mekanism.common.MekanismItems;
import mekanism.common.MekanismOreDict;
import mekanism.common.MekanismRecipe;
import mekanism.common.MekanismSounds;
import mekanism.common.PacketHandler;
import mekanism.common.PlayerState;
import mekanism.common.Version;
import mekanism.common.base.IModule;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.chunkloading.ChunkManager;
import mekanism.common.command.CommandMek;
import mekanism.common.concurrent.TaskExecutor;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.content.entangloporter.InventoryFrequency;
import mekanism.common.content.matrix.SynchronizedMatrixData;
import mekanism.common.content.tank.SynchronizedTankData;
import mekanism.common.content.transporter.PathfinderCache;
import mekanism.common.content.transporter.TransporterManager;
import mekanism.common.entity.EntityBabySkeleton;
import mekanism.common.entity.EntityBalloon;
import mekanism.common.entity.EntityFlame;
import mekanism.common.entity.EntityObsidianTNT;
import mekanism.common.entity.EntityRobit;
import mekanism.common.fixers.MekanismDataFixers;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.integration.IMCHandler;
import mekanism.common.integration.MekanismHooks;
import mekanism.common.integration.multipart.MultipartMekanism;
import mekanism.common.multiblock.MultiblockManager;
import mekanism.common.network.PacketDataRequest;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.network.PacketTransmitterUpdate;
import mekanism.common.recipe.BinRecipe;
import mekanism.common.recipe.GasConversionHandler;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.ItemStackInput;
import mekanism.common.recipe.machines.SmeltingRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.security.SecurityFrequency;
import mekanism.common.tile.TileEntityAdvancedBoundingBlock;
import mekanism.common.tile.TileEntityBin;
import mekanism.common.tile.TileEntityBoundingBlock;
import mekanism.common.tile.TileEntityCardboardBox;
import mekanism.common.tile.TileEntityChargepad;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.tile.TileEntityFluidTank;
import mekanism.common.tile.TileEntityFuelwoodHeater;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.tile.TileEntityGlowPanel;
import mekanism.common.tile.TileEntityHybridStorage;
import mekanism.common.tile.TileEntityIndustrialAlarm;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.tile.TileEntityModificationStation;
import mekanism.common.tile.TileEntityPersonalChest;
import mekanism.common.tile.TileEntityPressureDisperser;
import mekanism.common.tile.TileEntityQuantumEntangloporter;
import mekanism.common.tile.TileEntityRadioactiveWasteBarrel;
import mekanism.common.tile.TileEntityResistiveHeater;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.tile.TileEntityStructuralGlass;
import mekanism.common.tile.TileEntitySuperchargedCoil;
import mekanism.common.tile.TileEntitySuperheatingElement;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.tile.factory.TileEntityAdvancedFactory;
import mekanism.common.tile.factory.TileEntityCreativeFactory;
import mekanism.common.tile.factory.TileEntityEliteFactory;
import mekanism.common.tile.factory.TileEntityFactory;
import mekanism.common.tile.factory.TileEntityUltimateFactory;
import mekanism.common.tile.laser.TileEntityLaser;
import mekanism.common.tile.laser.TileEntityLaserAmplifier;
import mekanism.common.tile.laser.TileEntityLaserTractorBeam;
import mekanism.common.tile.machine.TileEntityAlloy;
import mekanism.common.tile.machine.TileEntityAmbientAccumulator;
import mekanism.common.tile.machine.TileEntityAmbientAccumulatorEnergy;
import mekanism.common.tile.machine.TileEntityAntiprotonicNucleosynthesizer;
import mekanism.common.tile.machine.TileEntityBrushed;
import mekanism.common.tile.machine.TileEntityCellExtractor;
import mekanism.common.tile.machine.TileEntityCellSeparator;
import mekanism.common.tile.machine.TileEntityChemicalCrystallizer;
import mekanism.common.tile.machine.TileEntityChemicalDissolutionChamber;
import mekanism.common.tile.machine.TileEntityChemicalInfuser;
import mekanism.common.tile.machine.TileEntityChemicalInjectionChamber;
import mekanism.common.tile.machine.TileEntityChemicalOxidizer;
import mekanism.common.tile.machine.TileEntityChemicalWasher;
import mekanism.common.tile.machine.TileEntityCombiner;
import mekanism.common.tile.machine.TileEntityCrusher;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.tile.machine.TileEntityElectricPump;
import mekanism.common.tile.machine.TileEntityElectrolyticSeparator;
import mekanism.common.tile.machine.TileEntityEnergizedSmelter;
import mekanism.common.tile.machine.TileEntityEnrichmentChamber;
import mekanism.common.tile.machine.TileEntityFluidicPlenisher;
import mekanism.common.tile.machine.TileEntityFormulaicAssemblicator;
import mekanism.common.tile.machine.TileEntityIsotopicCentrifuge;
import mekanism.common.tile.machine.TileEntityMetallurgicInfuser;
import mekanism.common.tile.machine.TileEntityNutritionalLiquifier;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import mekanism.common.tile.machine.TileEntityOrganicFarm;
import mekanism.common.tile.machine.TileEntityOsmiumCompressor;
import mekanism.common.tile.machine.TileEntityPRC;
import mekanism.common.tile.machine.TileEntityPrecisionSawmill;
import mekanism.common.tile.machine.TileEntityPurificationChamber;
import mekanism.common.tile.machine.TileEntityRecycler;
import mekanism.common.tile.machine.TileEntityRolling;
import mekanism.common.tile.machine.TileEntityRotaryCondensentrator;
import mekanism.common.tile.machine.TileEntitySeismicVibrator;
import mekanism.common.tile.machine.TileEntitySolarNeutronActivator;
import mekanism.common.tile.machine.TileEntityStamping;
import mekanism.common.tile.machine.TileEntityTurning;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import mekanism.common.tile.multiblock.TileEntityBoilerValve;
import mekanism.common.tile.multiblock.TileEntityDynamicTank;
import mekanism.common.tile.multiblock.TileEntityDynamicValve;
import mekanism.common.tile.multiblock.TileEntityInductionCasing;
import mekanism.common.tile.multiblock.TileEntityInductionCell;
import mekanism.common.tile.multiblock.TileEntityInductionPort;
import mekanism.common.tile.multiblock.TileEntityInductionProvider;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationBlock;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationController;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationValve;
import mekanism.common.tile.transmitter.TileEntityDiversionTransporter;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporter;
import mekanism.common.tile.transmitter.TileEntityMechanicalPipe;
import mekanism.common.tile.transmitter.TileEntityPressurizedTube;
import mekanism.common.tile.transmitter.TileEntityRestrictiveTransporter;
import mekanism.common.tile.transmitter.TileEntityThermodynamicConductor;
import mekanism.common.tile.transmitter.TileEntityUniversalCable;
import mekanism.common.transmitters.grid.EnergyNetwork;
import mekanism.common.transmitters.grid.FluidNetwork;
import mekanism.common.transmitters.grid.GasNetwork;
import mekanism.common.voice.VoiceServerManager;
import mekanism.common.world.GenHandler;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="mekanism", useMetadata=true, guiFactory="mekanism.client.gui.ConfigGuiFactory", acceptedMinecraftVersions="[1.12,1.13)", version="9.9.1.214")
@Mod.EventBusSubscriber
public class Mekanism {
    public static final String MODID = "mekanism";
    public static final String MOD_NAME = "Mekanism";
    public static final String LOG_TAG = "[Mekanism]";
    public static final PlayerState playerState = new PlayerState();
    public static final Set<UUID> freeRunnerOn = new ObjectOpenHashSet();
    public static final Set<UUID> jumpBoostOn = new ObjectOpenHashSet();
    public static final Set<UUID> stepAssistOn = new ObjectOpenHashSet();
    public static PacketHandler packetHandler = new PacketHandler();
    public static Logger logger = LogManager.getLogger((String)"Mekanism");
    @SidedProxy(clientSide="mekanism.client.ClientProxy", serverSide="mekanism.common.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="mekanism")
    public static Mekanism instance;
    public static MekanismHooks hooks;
    public static Configuration configuration;
    public static Configuration configurationce;
    public static Configuration configurationgenerators;
    public static Configuration configurationtools;
    public static Configuration configurationMultiblockMachine;
    public static Configuration configurationmekaweapons;
    public static Configuration configurationMeka;
    public static Version versionNumber;
    public static MultiblockManager<SynchronizedTankData> tankManager;
    public static MultiblockManager<SynchronizedMatrixData> matrixManager;
    public static MultiblockManager<SynchronizedBoilerData> boilerManager;
    public static FrequencyManager publicTeleporters;
    public static Map<UUID, FrequencyManager> privateTeleporters;
    public static FrequencyManager publicEntangloporters;
    public static Map<UUID, FrequencyManager> privateEntangloporters;
    public static FrequencyManager securityFrequencies;
    public static CreativeTabMekanism tabMekanism;
    public static CreativeTabMekanismAddition tabMekanismAddition;
    public static List<IModule> modulesLoaded;
    public static CommonWorldTickHandler worldTickHandler;
    public static GenHandler genHandler;
    public static int baseWorldGenVersion;
    public static VoiceServerManager voiceManager;
    public static GameProfile gameProfile;
    public static KeySync keyMap;
    public static Set<Coord4D> activeVibrators;
    public static final TaskExecutor EXECUTE_MANAGER;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        MekanismBlocks.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        MekanismItems.registerItems((IForgeRegistry<Item>)event.getRegistry());
        MekanismBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
        MekanismOreDict.registerOreDict();
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> event) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "ObsidianTNT"), EntityObsidianTNT.class, (String)"ObsidianTNT", (int)0, (Object)instance, (int)64, (int)5, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "Robit"), EntityRobit.class, (String)"Robit", (int)1, (Object)instance, (int)64, (int)2, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "Balloon"), EntityBalloon.class, (String)"Balloon", (int)2, (Object)instance, (int)64, (int)1, (boolean)true);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "BabySkeleton"), EntityBabySkeleton.class, (String)"BabySkeleton", (int)3, (Object)instance, (int)64, (int)5, (boolean)true, (int)0xFFFFFF, (int)0x800080);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "Flame"), EntityFlame.class, (String)"Flame", (int)4, (Object)instance, (int)64, (int)5, (boolean)true);
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        proxy.registerBlockRenders();
        proxy.registerItemRenders();
    }

    @SubscribeEvent
    public static void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        MekanismSounds.register((IForgeRegistry<SoundEvent>)event.getRegistry());
    }

    @SubscribeEvent
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        if (!MekanismConfig.current().mekce.BinRecipeClosed.val()) {
            event.getRegistry().register((IForgeRegistryEntry)new BinRecipe());
        }
        MekanismRecipe.addRecipes();
        GasConversionHandler.addDefaultGasMappings();
    }

    private static void registerTileEntity(Class<? extends TileEntity> clazz, String name) {
        GameRegistry.registerTileEntity(clazz, (ResourceLocation)new ResourceLocation(MODID, name));
    }

    private void registerTileEntities() {
        Mekanism.registerTileEntity(TileEntityAdvancedBoundingBlock.class, "advanced_bounding_block");
        Mekanism.registerTileEntity(TileEntityAdvancedFactory.class, "advanced_smelting_factory");
        Mekanism.registerTileEntity(TileEntityAmbientAccumulator.class, "ambient_accumulator");
        Mekanism.registerTileEntity(TileEntityBin.class, "bin");
        Mekanism.registerTileEntity(TileEntityBoilerCasing.class, "boiler_casing");
        Mekanism.registerTileEntity(TileEntityBoilerValve.class, "boiler_valve");
        Mekanism.registerTileEntity(TileEntityBoundingBlock.class, "bounding_block");
        Mekanism.registerTileEntity(TileEntityCardboardBox.class, "cardboard_box");
        Mekanism.registerTileEntity(TileEntityChargepad.class, "chargepad");
        Mekanism.registerTileEntity(TileEntityChemicalCrystallizer.class, "chemical_crystallizer");
        Mekanism.registerTileEntity(TileEntityChemicalDissolutionChamber.class, "chemical_dissolution_chamber");
        Mekanism.registerTileEntity(TileEntityChemicalInfuser.class, "chemical_infuser");
        Mekanism.registerTileEntity(TileEntityChemicalInjectionChamber.class, "chemical_injection_chamber");
        Mekanism.registerTileEntity(TileEntityChemicalOxidizer.class, "chemical_oxidizer");
        Mekanism.registerTileEntity(TileEntityChemicalWasher.class, "chemical_washer");
        Mekanism.registerTileEntity(TileEntityCombiner.class, "combiner");
        Mekanism.registerTileEntity(TileEntityCrusher.class, "crusher");
        Mekanism.registerTileEntity(TileEntityDigitalMiner.class, "digital_miner");
        Mekanism.registerTileEntity(TileEntityDiversionTransporter.class, "diversion_transporter");
        Mekanism.registerTileEntity(TileEntityDynamicTank.class, "dynamic_tank");
        Mekanism.registerTileEntity(TileEntityDynamicValve.class, "dynamic_valve");
        Mekanism.registerTileEntity(TileEntityElectricPump.class, "electric_pump");
        Mekanism.registerTileEntity(TileEntityElectrolyticSeparator.class, "electrolytic_separator");
        Mekanism.registerTileEntity(TileEntityEliteFactory.class, "ultimate_smelting_factory");
        Mekanism.registerTileEntity(TileEntityEnergizedSmelter.class, "energized_smelter");
        Mekanism.registerTileEntity(TileEntityEnergyCube.class, "energy_cube");
        Mekanism.registerTileEntity(TileEntityEnrichmentChamber.class, "enrichment_chamber");
        Mekanism.registerTileEntity(TileEntityFactory.class, "smelting_factory");
        Mekanism.registerTileEntity(TileEntityFluidTank.class, "fluid_tank");
        Mekanism.registerTileEntity(TileEntityFluidicPlenisher.class, "fluidic_plenisher");
        Mekanism.registerTileEntity(TileEntityFormulaicAssemblicator.class, "formulaic_assemblicator");
        Mekanism.registerTileEntity(TileEntityFuelwoodHeater.class, "fuelwood_heater");
        Mekanism.registerTileEntity(TileEntityGasTank.class, "gas_tank");
        Mekanism.registerTileEntity(TileEntityGlowPanel.class, "glow_panel");
        Mekanism.registerTileEntity(TileEntityInductionCasing.class, "induction_casing");
        Mekanism.registerTileEntity(TileEntityInductionCell.class, "induction_cell");
        Mekanism.registerTileEntity(TileEntityInductionPort.class, "induction_port");
        Mekanism.registerTileEntity(TileEntityInductionProvider.class, "induction_provider");
        Mekanism.registerTileEntity(TileEntityLaser.class, "laser");
        Mekanism.registerTileEntity(TileEntityLaserAmplifier.class, "laser_amplifier");
        Mekanism.registerTileEntity(TileEntityLaserTractorBeam.class, "laser_tractor_beam");
        Mekanism.registerTileEntity(TileEntityLogisticalSorter.class, "logistical_sorter");
        Mekanism.registerTileEntity(TileEntityLogisticalTransporter.class, "logistical_transporter");
        Mekanism.registerTileEntity(TileEntityMechanicalPipe.class, "mechanical_pipe");
        Mekanism.registerTileEntity(TileEntityMetallurgicInfuser.class, "metallurgic_infuser");
        Mekanism.registerTileEntity(TileEntityOredictionificator.class, "oredictionificator");
        Mekanism.registerTileEntity(TileEntityOsmiumCompressor.class, "osmium_compressor");
        Mekanism.registerTileEntity(TileEntityPRC.class, "pressurized_reaction_chamber");
        Mekanism.registerTileEntity(TileEntityPersonalChest.class, "personal_chest");
        Mekanism.registerTileEntity(TileEntityPrecisionSawmill.class, "precision_sawmill");
        Mekanism.registerTileEntity(TileEntityPressureDisperser.class, "pressure_disperser");
        Mekanism.registerTileEntity(TileEntityPressurizedTube.class, "pressurized_tube");
        Mekanism.registerTileEntity(TileEntityPurificationChamber.class, "purification_chamber");
        Mekanism.registerTileEntity(TileEntityQuantumEntangloporter.class, "quantum_entangloporter");
        Mekanism.registerTileEntity(TileEntityResistiveHeater.class, "resistive_heater");
        Mekanism.registerTileEntity(TileEntityRestrictiveTransporter.class, "restrictive_transporter");
        Mekanism.registerTileEntity(TileEntityRotaryCondensentrator.class, "rotary_condensentrator");
        Mekanism.registerTileEntity(TileEntitySecurityDesk.class, "security_desk");
        Mekanism.registerTileEntity(TileEntitySeismicVibrator.class, "seismic_vibrator");
        Mekanism.registerTileEntity(TileEntitySolarNeutronActivator.class, "solar_neutron_activator");
        Mekanism.registerTileEntity(TileEntityStructuralGlass.class, "structural_glass");
        Mekanism.registerTileEntity(TileEntitySuperheatingElement.class, "superheating_element");
        Mekanism.registerTileEntity(TileEntityTeleporter.class, "mekanism_teleporter");
        Mekanism.registerTileEntity(TileEntityThermalEvaporationBlock.class, "thermal_evaporation_block");
        Mekanism.registerTileEntity(TileEntityThermalEvaporationController.class, "thermal_evaporation_controller");
        Mekanism.registerTileEntity(TileEntityThermalEvaporationValve.class, "thermal_evaporation_valve");
        Mekanism.registerTileEntity(TileEntityThermodynamicConductor.class, "thermodynamic_conductor");
        Mekanism.registerTileEntity(TileEntityUniversalCable.class, "universal_cable");
        Mekanism.registerTileEntity(TileEntityUltimateFactory.class, "elite_smelting_factory");
        Mekanism.registerTileEntity(TileEntityCreativeFactory.class, "creative_smelting_factory");
        Mekanism.registerTileEntity(TileEntityIsotopicCentrifuge.class, "isotopic_centrifuge");
        Mekanism.registerTileEntity(TileEntityNutritionalLiquifier.class, "nutritional_liquifier");
        Mekanism.registerTileEntity(TileEntitySuperchargedCoil.class, "supercharged_coil");
        Mekanism.registerTileEntity(TileEntityOrganicFarm.class, "organic_farm");
        Mekanism.registerTileEntity(TileEntityAntiprotonicNucleosynthesizer.class, "antiprotonic_nucleosynthesizer");
        Mekanism.registerTileEntity(TileEntityStamping.class, "stamping");
        Mekanism.registerTileEntity(TileEntityRolling.class, "rolling");
        Mekanism.registerTileEntity(TileEntityBrushed.class, "brushed");
        Mekanism.registerTileEntity(TileEntityTurning.class, "turning");
        Mekanism.registerTileEntity(TileEntityAlloy.class, "alloy");
        Mekanism.registerTileEntity(TileEntityCellExtractor.class, "cell_extractor");
        Mekanism.registerTileEntity(TileEntityCellSeparator.class, "cell_separator");
        Mekanism.registerTileEntity(TileEntityRecycler.class, "Recycler");
        Mekanism.registerTileEntity(TileEntityIndustrialAlarm.class, "industrial_alarm");
        Mekanism.registerTileEntity(TileEntityAmbientAccumulatorEnergy.class, "ambient_accumulator_energy");
        Mekanism.registerTileEntity(TileEntityHybridStorage.class, "Hybrid_storage");
        Mekanism.registerTileEntity(TileEntityModificationStation.class, "Modification_Station");
        Mekanism.registerTileEntity(TileEntityRadioactiveWasteBarrel.class, "radioactive_waste_barrel");
        proxy.registerTESRs();
        MekanismDataFixers.register();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        if (MekanismConfig.current().general.voiceServerEnabled.val()) {
            voiceManager.start();
        }
        CommandMek.register(event);
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        if (MekanismConfig.current().general.voiceServerEnabled.val()) {
            voiceManager.stop();
        }
        playerState.clear();
        activeVibrators.clear();
        worldTickHandler.resetRegenChunks();
        privateTeleporters.clear();
        privateEntangloporters.clear();
        freeRunnerOn.clear();
        jumpBoostOn.clear();
        stepAssistOn.clear();
        MultiblockManager.reset();
        FrequencyManager.reset();
        TransporterManager.reset();
        PathfinderCache.reset();
        TransmitterNetworkRegistry.reset();
    }

    @Mod.EventHandler
    public void loadComplete(FMLInterModComms.IMCEvent event) {
        new IMCHandler().onIMCEvent((List<FMLInterModComms.IMCMessage>)event.getMessages());
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        String apiLocation;
        if (!((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue() && (apiLocation = MekanismAPI.class.getProtectionDomain().getCodeSource().getLocation().toString()).toLowerCase(Locale.ROOT).contains("-api.jar")) {
            proxy.throwApiPresentException();
        }
        configuration = new Configuration(new File("config/mekanism/Mekanism.cfg"));
        configurationce = new Configuration(new File("config/mekanism/MekanismCE.cfg"));
        configurationgenerators = new Configuration(new File("config/mekanism/MekanismGenerators.cfg"));
        configurationtools = new Configuration(new File("config/mekanism/MekanismTools.cfg"));
        configurationMultiblockMachine = new Configuration(new File("config/mekanism/MekanismMultiblockMachine.cfg"));
        configurationmekaweapons = new Configuration(new File("config/mekanism/MekanismWeapons.cfg"));
        configurationMeka = new Configuration(new File("config/mekanism/MekaSuitArmor.cfg"));
        proxy.loadConfiguration();
        proxy.onConfigSync(false);
        MinecraftForge.EVENT_BUS.register((Object)MekanismItems.GasMask);
        MinecraftForge.EVENT_BUS.register((Object)MekanismItems.FreeRunners);
        if (Loader.isModLoaded((String)"mcmultipart")) {
            new MultipartMekanism();
        } else {
            logger.info("Didn't detect MCMP, ignoring compatibility package");
        }
        proxy.preInit();
        InfuseRegistry.registerInfuseType(new InfuseType("CARBON", new ResourceLocation(MODID, "blocks/infuse/Carbon")).setTranslationKey("carbon"));
        InfuseRegistry.registerInfuseType(new InfuseType("TIN", new ResourceLocation(MODID, "blocks/infuse/Tin")).setTranslationKey("tin"));
        InfuseRegistry.registerInfuseType(new InfuseType("DIAMOND", new ResourceLocation(MODID, "blocks/infuse/Diamond")).setTranslationKey("diamond"));
        InfuseRegistry.registerInfuseType(new InfuseType("REDSTONE", new ResourceLocation(MODID, "blocks/infuse/Redstone")).setTranslationKey("redstone"));
        InfuseRegistry.registerInfuseType(new InfuseType("FUNGI", new ResourceLocation(MODID, "blocks/infuse/Fungi")).setTranslationKey("fungi"));
        InfuseRegistry.registerInfuseType(new InfuseType("BIO", new ResourceLocation(MODID, "blocks/infuse/Bio")).setTranslationKey("bio"));
        InfuseRegistry.registerInfuseType(new InfuseType("OBSIDIAN", new ResourceLocation(MODID, "blocks/infuse/Obsidian")).setTranslationKey("obsidian"));
        Capabilities.registerCapabilities();
        hooks.hookPreInit();
        MinecraftForge.EVENT_BUS.register((Object)EXECUTE_MANAGER);
        EXECUTE_MANAGER.init();
        logger.info(String.format("Parallel executor is ready (%s Threads), Let's get started!!!", TaskExecutor.THREAD_COUNT));
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        GameRegistry.registerWorldGenerator((IWorldGenerator)genHandler, (int)1);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new CoreGuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CommonPlayerTracker());
        MinecraftForge.EVENT_BUS.register((Object)new CommonPlayerTickHandler());
        logger.info("Version " + versionNumber + " initializing...");
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ChunkManager());
        MinecraftForge.EVENT_BUS.register((Object)this);
        PacketSimpleGui.handlers.add(0, proxy);
        if (MekanismConfig.current().general.voiceServerEnabled.val()) {
            voiceManager = new VoiceServerManager();
        }
        TransmitterNetworkRegistry.initiate();
        if (MekanismConfig.current().general.spawnBabySkeletons.val()) {
            for (Biome biome : BiomeProvider.allowedBiomes) {
                if (biome.func_76747_a(EnumCreatureType.MONSTER) == null || biome.func_76747_a(EnumCreatureType.MONSTER).size() <= 0) continue;
                EntityRegistry.addSpawn(EntityBabySkeleton.class, (int)40, (int)1, (int)3, (EnumCreatureType)EnumCreatureType.MONSTER, (Biome[])new Biome[]{biome});
            }
        }
        this.registerTileEntities();
        hooks.hookInit();
        packetHandler.initialize();
        proxy.init();
        logger.info("Loading complete.");
        logger.info("Mod loaded.");
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        logger.info("Fake player readout: UUID = " + gameProfile.getId().toString() + ", name = " + gameProfile.getName());
        for (Map.Entry entry : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            SmeltingRecipe recipe = new SmeltingRecipe(new ItemStackInput((ItemStack)entry.getKey()), new ItemStackOutput((ItemStack)entry.getValue()));
            RecipeHandler.Recipe.ENERGIZED_SMELTER.put(recipe);
        }
        hooks.hookPostInit();
        MinecraftForge.EVENT_BUS.post((Event)new MekanismAPI.BoxBlacklistEvent());
        logger.info("Hooking complete.");
    }

    @SubscribeEvent
    public void onEnergyTransferred(EnergyNetwork.EnergyTransferEvent event) {
        try {
            packetHandler.sendToReceivers(new PacketTransmitterUpdate.TransmitterUpdateMessage(PacketTransmitterUpdate.PacketType.ENERGY, event.energyNetwork.firstTransmitter().coord(), event.power), event.energyNetwork.getPacketRange());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onGasTransferred(GasNetwork.GasTransferEvent event) {
        try {
            packetHandler.sendToReceivers(new PacketTransmitterUpdate.TransmitterUpdateMessage(PacketTransmitterUpdate.PacketType.GAS, event.gasNetwork.firstTransmitter().coord(), event.transferType, event.didTransfer), event.gasNetwork.getPacketRange());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onLiquidTransferred(FluidNetwork.FluidTransferEvent event) {
        try {
            packetHandler.sendToReceivers(new PacketTransmitterUpdate.TransmitterUpdateMessage(PacketTransmitterUpdate.PacketType.FLUID, event.fluidNetwork.firstTransmitter().coord(), event.fluidType, event.didTransfer), event.fluidNetwork.getPacketRange());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onTransmittersAddedEvent(DynamicNetwork.TransmittersAddedEvent event) {
        try {
            packetHandler.sendToReceivers(new PacketTransmitterUpdate.TransmitterUpdateMessage(PacketTransmitterUpdate.PacketType.UPDATE, event.network.firstTransmitter().coord(), event.newNetwork, event.newTransmitters), event.network.getPacketRange());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onNetworkClientRequest(DynamicNetwork.NetworkClientRequest event) {
        try {
            packetHandler.sendToServer(new PacketDataRequest.DataRequestMessage(Coord4D.get(event.tileEntity)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onClientTickUpdate(DynamicNetwork.ClientTickUpdate event) {
        try {
            if (event.operation == 0) {
                ClientTickHandler.tickingSet.remove(event.network);
            } else {
                ClientTickHandler.tickingSet.add(event.network);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @SubscribeEvent
    public void onBlacklistUpdate(MekanismAPI.BoxBlacklistEvent event) {
        event.blacklistWildcard(MekanismBlocks.CardboardBox);
        event.blacklistWildcard(MekanismBlocks.BoundingBlock);
        event.blacklist(MekanismBlocks.BasicBlock2, 9);
        event.blacklist(MekanismBlocks.MachineBlock, 4);
        event.blacklist(MekanismBlocks.MachineBlock2, 9);
        event.blacklist(MekanismBlocks.MachineBlock3, 1);
        event.blacklist(Blocks.field_150357_h, 0);
        event.blacklistWildcard((Block)Blocks.field_150427_aO);
        event.blacklistWildcard(Blocks.field_150384_bq);
        event.blacklistWildcard(Blocks.field_150378_br);
        event.blacklistWildcard(Blocks.field_150324_C);
        event.blacklistWildcard((Block)Blocks.field_180413_ao);
        event.blacklistWildcard((Block)Blocks.field_180414_ap);
        event.blacklistWildcard((Block)Blocks.field_180412_aq);
        event.blacklistWildcard((Block)Blocks.field_180411_ar);
        event.blacklistWildcard((Block)Blocks.field_180410_as);
        event.blacklistWildcard((Block)Blocks.field_180409_at);
        event.blacklistWildcard((Block)Blocks.field_150454_av);
        event.blacklistWildcard(new ResourceLocation("extrautils2", "machine"));
        event.blacklistWildcard(new ResourceLocation("immersiveengineering", "metal_device0"));
        event.blacklistWildcard(new ResourceLocation("immersiveengineering", "metal_device1"));
        event.blacklistWildcard(new ResourceLocation("immersiveengineering", "wooden_device0"));
        event.blacklistWildcard(new ResourceLocation("immersiveengineering", "wooden_device1"));
        event.blacklistWildcard(new ResourceLocation("immersiveengineering", "connector"));
        event.blacklistWildcard(new ResourceLocation("immersiveengineering", "metal_multiblock"));
        event.blacklistWildcard(new ResourceLocation("ic2", "te"));
        event.blacklistMod("storagedrawers");
        event.blacklistMod("colossalchests");
        event.blacklist(MekanismBlocks.MachineBlock3, 9);
        BoxBlacklistParser.load();
    }

    @SubscribeEvent
    public void chunkSave(ChunkDataEvent.Save event) {
        if (!event.getWorld().field_72995_K) {
            NBTTagCompound nbtTags = event.getData();
            nbtTags.func_74768_a("MekanismWorldGen", baseWorldGenVersion);
            nbtTags.func_74768_a("MekanismUserWorldGen", MekanismConfig.current().general.userWorldGenVersion.val());
        }
    }

    @SubscribeEvent
    public synchronized void onChunkDataLoad(ChunkDataEvent.Load event) {
        if (!event.getWorld().field_72995_K && MekanismConfig.current().general.enableWorldRegeneration.val()) {
            NBTTagCompound loadData = event.getData();
            if (loadData.func_74762_e("MekanismWorldGen") == baseWorldGenVersion && loadData.func_74762_e("MekanismUserWorldGen") == MekanismConfig.current().general.userWorldGenVersion.val()) {
                return;
            }
            ChunkPos coordPair = event.getChunk().func_76632_l();
            worldTickHandler.addRegenChunk(event.getWorld().field_73011_w.getDimension(), coordPair);
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            proxy.loadConfiguration();
            proxy.onConfigSync(false);
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        playerState.init(event.getWorld());
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld() instanceof WorldServer) {
            MekFakePlayer.releaseInstance(event.getWorld());
        }
    }

    static {
        hooks = new MekanismHooks();
        versionNumber = new Version(999, 999, 999);
        tankManager = new MultiblockManager("dynamicTank");
        matrixManager = new MultiblockManager("inductionMatrix");
        boilerManager = new MultiblockManager("thermoelectricBoiler");
        publicTeleporters = new FrequencyManager(Frequency.class, "Teleporter");
        privateTeleporters = new Object2ObjectOpenHashMap();
        publicEntangloporters = new FrequencyManager(InventoryFrequency.class, "Entangloporter");
        privateEntangloporters = new Object2ObjectOpenHashMap();
        securityFrequencies = new FrequencyManager(SecurityFrequency.class, "Security");
        tabMekanism = new CreativeTabMekanism();
        tabMekanismAddition = new CreativeTabMekanismAddition();
        modulesLoaded = new ArrayList<IModule>();
        worldTickHandler = new CommonWorldTickHandler();
        genHandler = new GenHandler();
        baseWorldGenVersion = 0;
        gameProfile = new GameProfile(UUID.nameUUIDFromBytes("mekanism.common".getBytes()), LOG_TAG);
        keyMap = new KeySync();
        activeVibrators = new ObjectOpenHashSet();
        EXECUTE_MANAGER = new TaskExecutor();
        MekanismFluids.register();
    }
}

