/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.fuels.IFuel;
import buildcraft.api.mj.MjAPI;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import mekanism.api.gas.Gas;
import mekanism.common.integration.redstoneflux.RFIntegration;
import mekanism.common.util.MekanismUtils;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.ModAPIManager;

public class FuelHandler {
    public static Reference2ObjectMap<Gas, FuelGas> fuels = new Reference2ObjectOpenHashMap();

    public static void addGas(Gas gas, int burnTicks, double energyPerMilliBucket) {
        fuels.put((Object)gas, (Object)new FuelGas(burnTicks, energyPerMilliBucket));
    }

    public static FuelGas getFuel(Gas gas) {
        IFuel bcFuel;
        FuelGas fuelGas = (FuelGas)fuels.get((Object)gas);
        if (fuelGas != null) {
            return fuelGas;
        }
        if (FuelHandler.BCPresent() && gas.hasFluid() && BuildcraftFuelRegistry.fuel != null && (bcFuel = BuildcraftFuelRegistry.fuel.getFuel(new FluidStack(gas.getFluid(), 1))) != null) {
            FuelGas fuel = new FuelGas(bcFuel);
            fuels.put((Object)gas, (Object)fuel);
            return fuel;
        }
        return null;
    }

    public static boolean BCPresent() {
        return ModAPIManager.INSTANCE.hasAPI("BuildCraftAPI|fuels") && MekanismUtils.classExists("buildcraft.api.fuels.BuildcraftFuelRegistry") && MekanismUtils.classExists("buildcraft.api.fuels.IFuel");
    }

    public static class FuelGas {
        public int burnTicks;
        public double energyPerTick;

        public FuelGas(int duration, double energyDensity) {
            this.burnTicks = duration;
            this.energyPerTick = energyDensity / (double)duration;
        }

        public FuelGas(IFuel bcFuel) {
            this.burnTicks = bcFuel.getTotalBurningTime() / 1000;
            this.energyPerTick = RFIntegration.fromRF((double)bcFuel.getPowerPerCycle() / (double)MjAPI.MJ * 20.0);
        }
    }
}

