/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import mekanism.api.gas.GasStack;
import mekanism.common.KeySync;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.entity.EntityFlame;
import mekanism.common.item.ItemFlamethrower;
import mekanism.common.item.ItemFreeRunners;
import mekanism.common.item.ItemGasMask;
import mekanism.common.item.ItemScubaTank;
import mekanism.common.item.armor.ItemMekAsuitBodyArmour;
import mekanism.common.item.armor.ItemMekAsuitFeetArmour;
import mekanism.common.item.armor.ItemMekAsuitHeadArmour;
import mekanism.common.item.armor.ItemMekAsuitLegsArmour;
import mekanism.common.item.armor.ItemMekaSuitArmor;
import mekanism.common.item.interfaces.IJetpackItem;
import mekanism.common.moduleUpgrade;
import mekanism.common.util.TextComponentGroup;
import mekanism.common.util.UpgradeHelper;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.PlayerCapabilities;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.Nullable;

public class CommonPlayerTickHandler {
    public static final List<UUID> FLYING_PLAYERS = new ArrayList<UUID>();
    boolean isHeadItem = false;

    public static boolean isOnGroundOrSleeping(EntityPlayer player) {
        return player.field_70122_E || player.func_70093_af();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isScubaMaskOn(EntityPlayer player, ItemStack tank) {
        ItemStack mask = player.func_184582_a(EntityEquipmentSlot.HEAD);
        if (tank.func_190926_b()) return false;
        if (mask.func_190926_b()) return false;
        Item item = tank.func_77973_b();
        if (!(item instanceof ItemScubaTank)) return false;
        ItemScubaTank scubaTank = (ItemScubaTank)item;
        if (!(mask.func_77973_b() instanceof ItemGasMask)) return false;
        if (scubaTank.getGas(tank) == null) return false;
        if (!scubaTank.getFlowing(tank)) return false;
        return true;
    }

    public static boolean isFlamethrowerOn(EntityPlayer player, ItemStack currentItem) {
        return Mekanism.playerState.isFlamethrowerOn(player) && !currentItem.func_190926_b() && currentItem.func_77973_b() instanceof ItemFlamethrower;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float getStepBoost(EntityPlayer player) {
        ItemFreeRunners freeRunners;
        Item item;
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.FEET);
        if (!stack.func_190926_b() && (item = stack.func_77973_b()) instanceof ItemFreeRunners && (freeRunners = (ItemFreeRunners)item).getMode(stack).providesStepBoost() && !player.func_175149_v()) {
            return 1.002f;
        }
        if (!stack.func_190926_b() && (item = stack.func_77973_b()) instanceof ItemMekAsuitFeetArmour) {
            ItemMekAsuitFeetArmour feetArmour = (ItemMekAsuitFeetArmour)item;
            if (!player.func_175149_v()) {
                if (!UpgradeHelper.isUpgradeInstalled(stack, moduleUpgrade.HYDRAULIC_PROPULSION_UNIT)) return 0.6f;
                float height = feetArmour.getStepAssistMode(stack).getHeight();
                if (height == 0.5f) {
                    return 1.002f;
                }
                if (height == 1.0f) {
                    return 1.6f;
                }
                if (height == 1.5f) {
                    return 2.002f;
                }
                if (height != 2.0f) return 0.6f;
                return 2.6f;
            }
        }
        if (!(player.field_70138_W >= 1.0f)) return 0.6f;
        return 0.6f;
    }

    @SubscribeEvent
    public static void playerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        CommonPlayerTickHandler.removeFlyingPlayer(event.player.func_110124_au());
    }

    private static void removeFlyingPlayer(UUID playerUUID) {
        FLYING_PLAYERS.removeIf(uuid -> uuid.equals(playerUUID));
    }

    @SubscribeEvent
    public void onTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == Side.SERVER) {
            this.tickEnd(event.player);
        }
        if (event.phase == TickEvent.Phase.START) {
            this.isMekAsuitArmorFlying(event.player);
        }
    }

    public void tickEnd(EntityPlayer player) {
        ItemStack chest;
        IJetpackItem.JetpackMode primaryMode;
        IJetpackItem.JetpackMode mode;
        ItemStack primaryJetpack;
        ItemStack jetpack;
        player.field_70138_W = CommonPlayerTickHandler.getStepBoost(player);
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        if (CommonPlayerTickHandler.isFlamethrowerOn(player, currentItem)) {
            player.field_70170_p.func_72838_d((Entity)new EntityFlame(player));
            if (!player.func_184812_l_() && !player.func_175149_v()) {
                ((ItemFlamethrower)currentItem.func_77973_b()).useGas(currentItem);
            }
        }
        if (!(jetpack = IJetpackItem.getActiveJetpack((EntityLivingBase)player)).func_190926_b() && !(primaryJetpack = IJetpackItem.getPrimaryJetpack((EntityLivingBase)player)).func_190926_b() && (mode = IJetpackItem.getPlayerJetpackMode(player, primaryMode = ((IJetpackItem)primaryJetpack.func_77973_b()).getJetpackMode(primaryJetpack), () -> Mekanism.keyMap.has(player, KeySync.ASCEND))) != IJetpackItem.JetpackMode.DISABLED) {
            if (IJetpackItem.handleJetpackMotion(player, mode, () -> Mekanism.keyMap.has(player, KeySync.ASCEND))) {
                player.field_70143_R = 0.0f;
                if (player instanceof EntityPlayerMP) {
                    EntityPlayerMP serverPlayer = (EntityPlayerMP)player;
                    serverPlayer.field_71135_a.field_147365_f = 0;
                }
            }
            ((IJetpackItem)jetpack.func_77973_b()).useJetpackFuel(jetpack);
        }
        if (CommonPlayerTickHandler.isScubaMaskOn(player, chest = player.func_184582_a(EntityEquipmentSlot.CHEST))) {
            ItemScubaTank tank = (ItemScubaTank)chest.func_77973_b();
            int max = 300;
            tank.useGas(chest, 1);
            GasStack received = tank.useGas(chest, 300 - player.func_70086_ai());
            if (received != null) {
                player.func_70050_g(player.func_70086_ai() + received.amount);
            }
            if (player.func_70086_ai() == 300) {
                for (PotionEffect effect : player.func_70651_bq()) {
                    for (int i = 0; i < 9; ++i) {
                        effect.func_76455_a((EntityLivingBase)player);
                    }
                }
            }
        }
        this.isMekAsuitArmorHeadEff(player);
    }

    public void isMekAsuitArmorFlying(EntityPlayer player) {
        ItemStack chest = player.func_184582_a(EntityEquipmentSlot.CHEST);
        PlayerCapabilities capabilities = player.field_71075_bZ;
        UUID playerUUID = player.func_110124_au();
        if (!chest.func_190926_b() && chest.func_77973_b() instanceof ItemMekAsuitBodyArmour && UpgradeHelper.isUpgradeInstalled(chest, moduleUpgrade.GRAVITATIONAL_MODULATING_UNIT)) {
            if (!capabilities.field_75101_c) {
                capabilities.field_75101_c = true;
                player.func_71016_p();
                if (!FLYING_PLAYERS.contains(playerUUID)) {
                    FLYING_PLAYERS.add(playerUUID);
                }
            }
        } else if (FLYING_PLAYERS.contains(playerUUID)) {
            if (capabilities.field_75101_c && !player.func_175149_v() && !player.func_184812_l_()) {
                capabilities.field_75101_c = false;
                capabilities.field_75100_b = false;
                player.func_71016_p();
            }
            CommonPlayerTickHandler.removeFlyingPlayer(playerUUID);
        }
    }

    public void isMekAsuitArmorHeadEff(EntityPlayer player) {
        ItemStack head = player.func_184582_a(EntityEquipmentSlot.HEAD);
        PotionEffect nv = player.func_70660_b(MobEffects.field_76439_r);
        if (!head.func_190926_b()) {
            Item item = head.func_77973_b();
            if (item instanceof ItemMekAsuitHeadArmour) {
                ItemMekAsuitHeadArmour headArmour = (ItemMekAsuitHeadArmour)item;
                this.isHeadItem = true;
            } else {
                this.isHeadItem = false;
            }
        }
        if (nv != null && this.isHeadItem) {
            player.func_184589_d(MobEffects.field_76439_r);
        }
    }

    @SubscribeEvent
    public void onEntityAttacked(LivingAttackEvent event) {
        EntityPlayer player;
        FallEnergyInfo info;
        ItemScubaTank tank;
        Item item;
        ItemStack chestStack;
        ItemStack headStack;
        EntityLivingBase entity = event.getEntityLiving();
        if (event.getAmount() <= 0.0f || !entity.func_70089_S()) {
            return;
        }
        if (event.getSource().func_82725_o() && !(headStack = entity.func_184582_a(EntityEquipmentSlot.HEAD)).func_190926_b() && headStack.func_77973_b() instanceof ItemGasMask && !(chestStack = entity.func_184582_a(EntityEquipmentSlot.CHEST)).func_190926_b() && (item = chestStack.func_77973_b()) instanceof ItemScubaTank && (tank = (ItemScubaTank)item).getFlowing(chestStack) && tank.getGas(chestStack) != null) {
            event.setCanceled(true);
            return;
        }
        if (event.getSource() == DamageSource.field_76379_h && (info = this.getFallAbsorptionEnergyInfo(entity)) != null && this.tryAbsorbAll(event, entity.func_184582_a(EntityEquipmentSlot.FEET), info.damageRatio, info.energyCost)) {
            return;
        }
        if (entity instanceof EntityPlayer && ItemMekaSuitArmor.tryAbsorbAll(player = (EntityPlayer)entity, event.getSource(), event.getAmount())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        EntityPlayer player;
        float ratioAbsorbed;
        FallEnergyInfo info;
        EntityLivingBase entity = event.getEntityLiving();
        if (event.getAmount() <= 0.0f || !entity.func_70089_S()) {
            return;
        }
        if (event.getSource() == DamageSource.field_76379_h && (info = this.getFallAbsorptionEnergyInfo(entity)) != null && this.handleDamage(event, entity.func_184582_a(EntityEquipmentSlot.FEET), info.damageRatio, info.energyCost)) {
            return;
        }
        if (entity instanceof EntityPlayer && (ratioAbsorbed = ItemMekaSuitArmor.getDamageAbsorbed(player = (EntityPlayer)entity, event.getSource(), event.getAmount())) > 0.0f) {
            float damageRemaining = event.getAmount() * Math.max(0.0f, 1.0f - ratioAbsorbed);
            if (damageRemaining <= 0.0f) {
                event.setCanceled(true);
            } else {
                event.setAmount(damageRemaining);
            }
        }
    }

    @SubscribeEvent
    public void onLivingDamage(LivingDamageEvent event) {
        EntityPlayer player;
        float ratioAbsorbed;
        EntityLivingBase entity = event.getEntityLiving();
        if (event.getAmount() <= 0.0f || !entity.func_70089_S()) {
            return;
        }
        if (entity instanceof EntityPlayer && (ratioAbsorbed = ItemMekaSuitArmor.getDamageAbsorbed(player = (EntityPlayer)entity, event.getSource(), event.getAmount())) > 0.0f) {
            float damageRemaining = event.getAmount() * Math.max(0.0f, 1.0f - ratioAbsorbed);
            if (damageRemaining <= 0.0f) {
                event.setCanceled(true);
            } else {
                event.setAmount(damageRemaining);
            }
        }
    }

    private boolean handleDamage(LivingHurtEvent event, ItemStack energyContainer, float absorptionRatio, float energyCost) {
        if (!energyContainer.func_190926_b()) {
            float absorption = absorptionRatio;
            float amount = event.getAmount() * absorption;
            float energyRequirement = energyCost * amount;
            float ratioAbsorbed = 0.0f;
            if (energyRequirement == 0.0f) {
                ratioAbsorbed = absorption;
            } else {
                Item item = energyContainer.func_77973_b();
                if (item instanceof ItemFreeRunners) {
                    ItemFreeRunners boots = (ItemFreeRunners)item;
                    ratioAbsorbed = (float)((double)absorption * ((boots.getEnergy(energyContainer) - (double)energyRequirement) / (double)amount));
                    boots.setEnergy(energyContainer, boots.getEnergy(energyContainer) - (boots.getEnergy(energyContainer) - (double)energyRequirement) / (double)amount);
                } else {
                    item = energyContainer.func_77973_b();
                    if (item instanceof ItemMekaSuitArmor) {
                        ItemMekaSuitArmor armor = (ItemMekaSuitArmor)item;
                        ratioAbsorbed = (float)((double)absorption * ((armor.getEnergy(energyContainer) - (double)energyRequirement) / (double)amount));
                        armor.setEnergy(energyContainer, armor.getEnergy(energyContainer) - (armor.getEnergy(energyContainer) - (double)energyRequirement) / (double)amount);
                    }
                }
            }
            if (ratioAbsorbed > 0.0f) {
                float damageRemaining = event.getAmount() * Math.max(0.0f, 1.0f - ratioAbsorbed);
                if (damageRemaining <= 0.0f) {
                    event.setCanceled(true);
                    return true;
                }
                event.setAmount(damageRemaining);
            }
        }
        return false;
    }

    @Nullable
    private FallEnergyInfo getFallAbsorptionEnergyInfo(EntityLivingBase base) {
        ItemStack feetStack = base.func_184582_a(EntityEquipmentSlot.FEET);
        if (!feetStack.func_190926_b()) {
            Item item = feetStack.func_77973_b();
            if (item instanceof ItemFreeRunners) {
                ItemFreeRunners boots = (ItemFreeRunners)item;
                if (boots.getMode(feetStack).preventsFallDamage()) {
                    return new FallEnergyInfo(feetStack, 1.0f, 50.0f);
                }
            } else if (feetStack.func_77973_b() instanceof ItemMekaSuitArmor) {
                return new FallEnergyInfo(feetStack, MekanismConfig.current().meka.mekaSuitFallDamageRatio.val(), MekanismConfig.current().meka.mekaSuitEnergyUsageFall.val());
            }
        }
        return null;
    }

    private boolean tryAbsorbAll(LivingAttackEvent event, ItemStack stack, float absorptionRatio, float energyCost) {
        if (!stack.func_190926_b() && absorptionRatio == 1.0f) {
            double energyRequirement = energyCost * event.getAmount();
            if (energyRequirement == 0.0) {
                event.setCanceled(true);
                return true;
            }
            Item item = stack.func_77973_b();
            if (item instanceof ItemFreeRunners) {
                ItemFreeRunners boot = (ItemFreeRunners)item;
                if (boot.getEnergy(stack) > energyRequirement) {
                    boot.setEnergy(stack, boot.getEnergy(stack) - energyRequirement);
                    event.setCanceled(true);
                    return true;
                }
            } else {
                ItemMekaSuitArmor meka;
                item = stack.func_77973_b();
                if (item instanceof ItemMekaSuitArmor && (meka = (ItemMekaSuitArmor)item).getEnergy(stack) > energyRequirement) {
                    meka.setEnergy(stack, meka.getEnergy(stack) - energyRequirement);
                    event.setCanceled(true);
                    return true;
                }
            }
        }
        return false;
    }

    @SubscribeEvent
    public void onLivingJump(LivingEvent.LivingJumpEvent event) {
        Item item;
        EntityPlayer player;
        ItemStack feet;
        Entity entity = event.getEntity();
        if (entity instanceof EntityPlayer && !(feet = (player = (EntityPlayer)entity).func_184582_a(EntityEquipmentSlot.FEET)).func_190926_b() && (item = feet.func_77973_b()) instanceof ItemMekAsuitFeetArmour) {
            ItemMekAsuitFeetArmour feetArmor = (ItemMekAsuitFeetArmour)item;
            if (UpgradeHelper.isUpgradeInstalled(feet, moduleUpgrade.HYDRAULIC_PROPULSION_UNIT)) {
                float boost = feetArmor.getJumpBoostMode(feet).getBoost();
                double usage = MekanismConfig.current().meka.mekaSuitBaseJumpEnergyUsage.val() * (double)(boost / 0.1f);
                if (feetArmor.getEnergy(feet) > usage) {
                    ItemStack leg = player.func_184582_a(EntityEquipmentSlot.LEGS);
                    if (!leg.func_190926_b() && leg.func_77973_b() instanceof ItemMekAsuitLegsArmour && UpgradeHelper.isUpgradeInstalled(leg, moduleUpgrade.LOCOMOTIVE_BOOSTING_UNIT)) {
                        boost = (float)Math.sqrt(boost);
                    }
                    player.field_70181_x += (double)boost;
                    feetArmor.setEnergy(feet, feetArmor.getEnergy(feet) - usage);
                }
            }
        }
    }

    @SubscribeEvent
    public void getBreakSpeed(PlayerEvent.BreakSpeed event) {
        EntityPlayer player = event.getEntityPlayer();
        float speed = event.getNewSpeed();
        BlockPos position = event.getPos();
        ItemStack legs = player.func_184582_a(EntityEquipmentSlot.LEGS);
        if (!legs.func_190926_b() && legs.func_77973_b() instanceof ItemMekaSuitArmor && UpgradeHelper.isUpgradeInstalled(legs, moduleUpgrade.GYROSCOPIC_STABILIZATION_UNIT)) {
            if (player.func_70055_a(Material.field_151586_h) && !EnchantmentHelper.func_185287_i((EntityLivingBase)player)) {
                speed *= 5.0f;
            }
            if (!player.field_70122_E) {
                speed *= 5.0f;
            }
        }
        event.setNewSpeed(speed);
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        EntityPlayer player;
        ItemStack head;
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (entityLivingBase instanceof EntityPlayer && !(head = (player = (EntityPlayer)entityLivingBase).func_184582_a(EntityEquipmentSlot.HEAD)).func_190926_b() && head.func_77973_b() instanceof ItemMekAsuitHeadArmour && UpgradeHelper.isUpgradeInstalled(head, moduleUpgrade.EMERGENCY_RESCUE)) {
            event.setCanceled(true);
            if (!UpgradeHelper.isUpgradeInstalled(head, moduleUpgrade.ADVANCED_INTERCEPTION_SYSTEM_UNIT)) {
                int installed = UpgradeHelper.getUpgradeLevel(head, moduleUpgrade.EMERGENCY_RESCUE);
                int toAdd = Math.max(installed - 1, 0);
                UpgradeHelper.setUpgradeLevel(head, moduleUpgrade.EMERGENCY_RESCUE, toAdd);
            }
            player.func_70606_j(5.0f);
            player.func_70674_bp();
            player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 800, 2));
            player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 900, 2));
            player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 100, 2));
            player.func_70050_g(300);
            player.func_71024_bL().func_75122_a(20, 20.0f);
            player.func_145747_a((ITextComponent)new TextComponentGroup(TextFormatting.GRAY).string("[", TextFormatting.RED).translation("item.module.emergency_rescue.name", TextFormatting.RED).string("]", TextFormatting.RED).string(":").translation("module.emergency_rescue.use", TextFormatting.YELLOW));
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        EntityLivingBase entityLivingBase;
        if (MekanismConfig.current().mekce.MekAsuitOverloadProtection.val() && (entityLivingBase = event.getEntityLiving()) instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLivingBase;
            ItemStack head = player.func_184582_a(EntityEquipmentSlot.HEAD);
            if (!player.func_70089_S() && !head.func_190926_b() && head.func_77973_b() instanceof ItemMekAsuitHeadArmour && UpgradeHelper.isUpgradeInstalled(head, moduleUpgrade.EMERGENCY_RESCUE)) {
                player.field_70172_ad = 20;
                player.field_70725_aQ = 0;
                player.field_70128_L = false;
                player.func_70606_j(5.0f);
                player.func_70674_bp();
                player.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 800, 2));
                player.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 900, 2));
                player.func_70690_d(new PotionEffect(MobEffects.field_76444_x, 100, 2));
                player.func_70050_g(300);
                player.func_71024_bL().func_75122_a(20, 20.0f);
                if (!UpgradeHelper.isUpgradeInstalled(head, moduleUpgrade.ADVANCED_INTERCEPTION_SYSTEM_UNIT)) {
                    int installed = UpgradeHelper.getUpgradeLevel(head, moduleUpgrade.EMERGENCY_RESCUE);
                    int toAdd = Math.max(installed - 1, 0);
                    UpgradeHelper.setUpgradeLevel(head, moduleUpgrade.EMERGENCY_RESCUE, toAdd);
                }
            }
        }
    }

    private static final class FallEnergyInfo {
        private final ItemStack stack;
        private final float damageRatio;
        private final float energyCost;

        private FallEnergyInfo(ItemStack stack, float damageRatio, float energyCost) {
            this.stack = stack;
            this.damageRatio = damageRatio;
            this.energyCost = energyCost;
        }

        public String toString() {
            return "FallEnergyInfo[" + "stack=" + this.stack + "," + "damageRatio=" + this.damageRatio + "," + "energyCost=" + this.energyCost + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.stack != null ? this.stack.hashCode() : 0);
            result = 31 * result + (this.damageRatio != 0.0f ? Float.floatToIntBits(this.damageRatio) : 0);
            result = 31 * result + (this.energyCost != 0.0f ? Float.floatToIntBits(this.energyCost) : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((FallEnergyInfo)arg0).stack, this.stack)) {
                return false;
            }
            if (((FallEnergyInfo)arg0).damageRatio != this.damageRatio) {
                return false;
            }
            return ((FallEnergyInfo)arg0).energyCost == this.energyCost;
            {
            }
        }

        public ItemStack stack() {
            return this.stack;
        }

        public float damageRatio() {
            return this.damageRatio;
        }

        public float energyCost() {
            return this.energyCost;
        }
    }
}

