/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import mekanism.api.gas.GasStack;
import mekanism.client.model.ModelNutritionalLiquifier;
import mekanism.client.render.GasRenderMap;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.tile.machine.TileEntityNutritionalLiquifier;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderNutritionalLiquifier
extends TileEntitySpecialRenderer<TileEntityNutritionalLiquifier> {
    private static final float BASE_SPEED = 512.0f;
    public static final RenderNutritionalLiquifier INSTANCE = new RenderNutritionalLiquifier();
    private static GasRenderMap<MekanismRenderer.DisplayInteger[]> cachedCenterGas = new GasRenderMap();
    private static final int stages = 1000;
    private ModelNutritionalLiquifier model = new ModelNutritionalLiquifier();

    public static void resetDisplayInts() {
        cachedCenterGas.clear();
    }

    public void render(TileEntityNutritionalLiquifier tileEntity, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        ItemStack stack = tileEntity.func_70301_a(0);
        if (!stack.func_190926_b() && tileEntity.gasTank.getStored() < tileEntity.gasTank.getMaxGas() / 2) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.65), (double)(z + 0.5));
            float scale = stack.func_77973_b() instanceof ItemBlock ? 0.425f : 0.325f;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            double tick = (double)Minecraft.func_71386_F() / 800.0;
            GlStateManager.func_179137_b((double)0.0, (double)(Math.sin(tick % (Math.PI * 2)) * 0.065), (double)0.0);
            GlStateManager.func_179114_b((float)((float)(tick * 40.0 % 360.0)), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179123_a();
            RenderHelper.func_74519_b();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
            RenderHelper.func_74518_a();
            GlStateManager.func_179099_b();
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
        }
        if (tileEntity.gasTank.getStored() > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179089_o();
            GlStateManager.func_179140_f();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_147499_a(TextureMap.field_110575_b);
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            MekanismRenderer.GlowInfo glowInfo = MekanismRenderer.enableGlow();
            MekanismRenderer.DisplayInteger[] displayList = this.getListAndRender(tileEntity.gasTank.getGas());
            MekanismRenderer.color(tileEntity.gasTank.getGas());
            displayList[Math.min(999, (int)(tileEntity.prevScale * 999.0f))].render();
            MekanismRenderer.resetColor();
            MekanismRenderer.disableGlow(glowInfo);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179145_e();
            GlStateManager.func_179129_p();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        this.func_147499_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "NutritionalLiquifier.png"));
        MekanismRenderer.rotate(tileEntity.facing, 0.0f, 180.0f, 90.0f, 270.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.render(0.0625f, tileEntity.getActive());
        if (tileEntity.getActive()) {
            double tick = (double)Minecraft.func_71386_F() / 800.0;
            GlStateManager.func_179114_b((float)((float)(tick * 100.0 % 360.0)), (float)0.0f, (float)1.0f, (float)0.0f);
            this.model.renderBlade(0.0625f);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        MekanismRenderer.rotate(tileEntity.facing, 0.0f, 180.0f, 90.0f, 270.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.renderGlass(0.0625f, true);
        GlStateManager.func_179121_F();
        MekanismRenderer.machineRenderer().func_192841_a(tileEntity, x, y, z, partialTick, destroyStage, alpha);
    }

    private MekanismRenderer.DisplayInteger[] getListAndRender(GasStack gasStack) {
        if (cachedCenterGas.containsKey(gasStack)) {
            return (MekanismRenderer.DisplayInteger[])cachedCenterGas.get(gasStack);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(gasStack.getGas().getSprite());
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[1000];
        cachedCenterGas.put(gasStack, displays);
        for (int i = 0; i < 1000; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            toReturn.minZ = 0.0725;
            toReturn.maxZ = 0.9275;
            toReturn.minX = 0.0725;
            toReturn.maxX = 0.9275;
            toReturn.minY = 0.3225;
            toReturn.maxY = 0.3125 + (double)((float)i / 1000.0f) * 0.625 - 0.01;
            MekanismRenderer.renderObject(toReturn);
            MekanismRenderer.DisplayInteger.endList();
        }
        return displays;
    }
}

