/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.tileentity;

import mekanism.api.gas.GasStack;
import mekanism.client.model.ModelIsotopicCentrifuge;
import mekanism.client.render.GasRenderMap;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.tile.machine.TileEntityIsotopicCentrifuge;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderIsotopicCentrifuge
extends TileEntitySpecialRenderer<TileEntityIsotopicCentrifuge> {
    public static final RenderIsotopicCentrifuge INSTANCE = new RenderIsotopicCentrifuge();
    private static GasRenderMap<MekanismRenderer.DisplayInteger[]> cachedCenterGas = new GasRenderMap();
    private ModelIsotopicCentrifuge model = new ModelIsotopicCentrifuge();
    private static final int stages = 1200;

    public static void resetDisplayInts() {
        cachedCenterGas.clear();
    }

    public void render(TileEntityIsotopicCentrifuge tileEntity, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        if (tileEntity.outputTank.getStored() > 0) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179089_o();
            GlStateManager.func_179140_f();
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_147499_a(TextureMap.field_110575_b);
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            MekanismRenderer.GlowInfo glowInfo = MekanismRenderer.enableGlow();
            MekanismRenderer.DisplayInteger[] displayList = this.getListAndRender(tileEntity.outputTank.getGas());
            MekanismRenderer.color(tileEntity.outputTank.getGas());
            displayList[Math.min(1199, (int)(tileEntity.prevScale * 1199.0f))].render();
            MekanismRenderer.resetColor();
            MekanismRenderer.disableGlow(glowInfo);
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
            GlStateManager.func_179145_e();
            GlStateManager.func_179129_p();
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        this.func_147499_a(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "IsotopicCentrifuge.png"));
        MekanismRenderer.rotate(tileEntity.facing, 0.0f, 180.0f, 90.0f, 270.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.model.render(0.0625f, true);
        GlStateManager.func_179121_F();
        MekanismRenderer.machineRenderer().func_192841_a(tileEntity, x, y, z, partialTick, destroyStage, alpha);
    }

    private MekanismRenderer.DisplayInteger[] getListAndRender(GasStack gasStack) {
        if (cachedCenterGas.containsKey(gasStack)) {
            return (MekanismRenderer.DisplayInteger[])cachedCenterGas.get(gasStack);
        }
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        toReturn.baseBlock = Blocks.field_150355_j;
        toReturn.setTexture(gasStack.getGas().getSprite());
        MekanismRenderer.DisplayInteger[] displays = new MekanismRenderer.DisplayInteger[1200];
        cachedCenterGas.put(gasStack, displays);
        for (int i = 0; i < 1200; ++i) {
            displays[i] = MekanismRenderer.DisplayInteger.createAndStart();
            toReturn.minZ = 0.335;
            toReturn.maxZ = 0.7275;
            toReturn.minX = 0.335;
            toReturn.maxX = 0.7275;
            toReturn.minY = 0.9475;
            toReturn.maxY = 0.9375 + (double)((float)i / 1200.0f) * 0.75 - 0.01;
            MekanismRenderer.renderObject(toReturn);
            MekanismRenderer.DisplayInteger.endList();
        }
        return displays;
    }
}

