/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.obj;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import mekanism.client.render.obj.OBJBakedModelBase;
import mekanism.common.block.property.PropertyColor;
import mekanism.common.block.property.PropertyConnection;
import mekanism.common.config.MekanismConfig;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import org.apache.commons.lang3.tuple.Pair;

public class TransmitterModel
extends OBJBakedModelBase {
    public static Map<ItemCameraTransforms.TransformType, TRSRTransformation> transforms = ImmutableMap.builder().put((Object)ItemCameraTransforms.TransformType.GUI, (Object)TransmitterModel.get(0.0f, 0.0f, 0.0f, 30.0f, 225.0f, 0.0f, 0.625f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, (Object)TransmitterModel.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, (Object)TransmitterModel.get(0.0f, 2.5f, 0.0f, 75.0f, 45.0f, 0.0f, 0.375f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND, (Object)TransmitterModel.get(0.0f, 0.0f, 0.0f, 0.0f, 45.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND, (Object)TransmitterModel.get(0.0f, 0.0f, 0.0f, 0.0f, 225.0f, 0.0f, 0.4f)).put((Object)ItemCameraTransforms.TransformType.GROUND, (Object)TransmitterModel.get(0.0f, 2.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.25f)).put((Object)ItemCameraTransforms.TransformType.HEAD, (Object)TransmitterModel.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f)).put((Object)ItemCameraTransforms.TransformType.FIXED, (Object)TransmitterModel.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f)).put((Object)ItemCameraTransforms.TransformType.NONE, (Object)TransmitterModel.get(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f)).build();
    private static Set<TransmitterModel> modelInstances = Collections.newSetFromMap(new ConcurrentHashMap());
    private static TextureAtlasSprite[] transporter_center = new TextureAtlasSprite[2];
    private static TextureAtlasSprite[] transporter_center_color = new TextureAtlasSprite[2];
    private static TextureAtlasSprite[] transporter_side = new TextureAtlasSprite[2];
    private static TextureAtlasSprite[] transporter_side_color = new TextureAtlasSprite[2];
    private Map<Integer, List<BakedQuad>> modelCache = new ConcurrentHashMap<Integer, List<BakedQuad>>();
    private TransmitterModel itemCache;
    private IBlockState tempState;
    private ItemStack tempStack;
    private TextureAtlasSprite particle;
    private TransmitterOverride override = new TransmitterOverride();

    public TransmitterModel(IBakedModel base, OBJModel model, IModelState state, VertexFormat format, ImmutableMap<String, TextureAtlasSprite> textures, Map<ItemCameraTransforms.TransformType, Matrix4f> transform) {
        super(base, model, state, format, textures, transform);
        this.particle = (TextureAtlasSprite)this.textureMap.getOrDefault((Object)"None_Center", (Object)((TextureAtlasSprite)this.textureMap.getOrDefault((Object)"CentreMaterial", (Object)this.tempSprite)));
        modelInstances.add(this);
    }

    private static TRSRTransformation get(float tx, float ty, float tz, float ax, float ay, float az, float s) {
        return new TRSRTransformation(new Vector3f(tx / 16.0f, ty / 16.0f, tz / 16.0f), TRSRTransformation.quatFromXYZDegrees((Vector3f)new Vector3f(ax, ay, az)), new Vector3f(s, s, s), null);
    }

    public static void registerIcons(TextureMap map) {
        TransmitterModel.transporter_center[0] = map.func_174942_a(new ResourceLocation("mekanism", "blocks/models/multipart/LogisticalTransporterGlass"));
        TransmitterModel.transporter_center_color[0] = map.func_174942_a(new ResourceLocation("mekanism", "blocks/models/multipart/LogisticalTransporterGlassColored"));
        TransmitterModel.transporter_side[0] = map.func_174942_a(new ResourceLocation("mekanism", "blocks/models/multipart/LogisticalTransporterVerticalGlass"));
        TransmitterModel.transporter_side_color[0] = map.func_174942_a(new ResourceLocation("mekanism", "blocks/models/multipart/LogisticalTransporterVerticalGlassColored"));
        TransmitterModel.transporter_center[1] = map.func_174942_a(new ResourceLocation("mekanism", "blocks/models/multipart/opaque/LogisticalTransporterGlass"));
        TransmitterModel.transporter_center_color[1] = map.func_174942_a(new ResourceLocation("mekanism", "blocks/models/multipart/opaque/LogisticalTransporterGlassColored"));
        TransmitterModel.transporter_side[1] = map.func_174942_a(new ResourceLocation("mekanism", "blocks/models/multipart/opaque/LogisticalTransporterVerticalGlass"));
        TransmitterModel.transporter_side_color[1] = map.func_174942_a(new ResourceLocation("mekanism", "blocks/models/multipart/opaque/LogisticalTransporterVerticalGlassColored"));
    }

    public static void clearCache() {
        for (TransmitterModel model : modelInstances) {
            model.modelCache.clear();
            model.itemCache = null;
        }
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.override;
    }

    @Override
    @Nonnull
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        if (side != null) {
            return ImmutableList.of();
        }
        if (state != null && this.tempState == null) {
            IExtendedBlockState extended = (IExtendedBlockState)state;
            BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
            PropertyColor colorProp = (PropertyColor)extended.getValue((IUnlistedProperty)PropertyColor.INSTANCE);
            int color = -1;
            if (colorProp != null && colorProp.color != null) {
                color = colorProp.color.ordinal();
            }
            OBJModel.OBJState obj = (OBJModel.OBJState)extended.getValue((IUnlistedProperty)OBJModel.OBJProperty.INSTANCE);
            if (layer != BlockRenderLayer.TRANSLUCENT) {
                color = -1;
            }
            try {
                int hash = Objects.hash(layer.ordinal(), color, PropertyConnection.INSTANCE.valueToString((PropertyConnection)extended.getValue((IUnlistedProperty)PropertyConnection.INSTANCE)));
                if (obj.getVisibilityMap().containsKey("OBJModel.Group.All.Key") || obj.getVisibilityMap().containsKey("OBJModel.Group.All.Except.Key")) {
                    this.updateStateVisibilityMap(obj);
                }
                if (!this.modelCache.containsKey(hash)) {
                    TransmitterModel model = new TransmitterModel(this.baseModel, this.getModel(), (IModelState)obj, this.vertexFormat, (ImmutableMap<String, TextureAtlasSprite>)this.textureMap, this.transformationMap);
                    model.tempState = state;
                    this.modelCache.put(hash, model.func_188616_a(state, side, rand));
                }
                return this.modelCache.get(hash);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return super.func_188616_a(state, side, rand);
    }

    @Override
    public float[] getOverrideColor(OBJModel.Face f, String groupName) {
        if (this.tempState != null) {
            PropertyColor prop = (PropertyColor)((IExtendedBlockState)this.tempState).getValue((IUnlistedProperty)PropertyColor.INSTANCE);
            if (MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.TRANSLUCENT && prop != null && prop.color != null) {
                return new float[]{prop.color.getColor(0), prop.color.getColor(1), prop.color.getColor(2), 1.0f};
            }
        }
        return null;
    }

    @Override
    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    @Override
    public TextureAtlasSprite getOverrideTexture(OBJModel.Face f, String groupName) {
        if (this.tempState != null) {
            boolean sideIconOverride;
            EnumFacing side = EnumFacing.func_176737_a((float)f.getNormal().x, (float)f.getNormal().y, (float)f.getNormal().z);
            PropertyColor prop = (PropertyColor)((IExtendedBlockState)this.tempState).getValue((IUnlistedProperty)PropertyColor.INSTANCE);
            PropertyConnection connection = (PropertyConnection)((IExtendedBlockState)this.tempState).getValue((IUnlistedProperty)PropertyConnection.INSTANCE);
            boolean bl = sideIconOverride = connection != null && this.getIconStatus(side, connection) > 0;
            if (MinecraftForgeClient.getRenderLayer() == BlockRenderLayer.TRANSLUCENT) {
                int opaqueVal;
                int n = opaqueVal = MekanismConfig.current().client.opaqueTransmitters.val() ? 1 : 0;
                if (prop != null && prop.color != null) {
                    return !sideIconOverride && f.getMaterialName().contains("Center") ? transporter_center_color[opaqueVal] : transporter_side_color[opaqueVal];
                }
                return !sideIconOverride && f.getMaterialName().contains("Center") ? transporter_center[opaqueVal] : transporter_side[opaqueVal];
            }
            if (groupName.endsWith("NONE") && sideIconOverride) {
                for (String s : this.getModel().getMatLib().getMaterialNames()) {
                    if (s.contains("Texture.Name") || s.contains("Center") || s.contains("Centre") || MekanismConfig.current().client.opaqueTransmitters.val() != s.contains("Opaque")) continue;
                    return (TextureAtlasSprite)this.textureMap.get((Object)s);
                }
            } else if (MekanismConfig.current().client.opaqueTransmitters.val()) {
                return (TextureAtlasSprite)this.textureMap.get((Object)(f.getMaterialName() + "_Opaque"));
            }
        }
        return null;
    }

    @Override
    public boolean shouldRotate(OBJModel.Face f, String groupName) {
        if (this.tempState != null) {
            EnumFacing side = EnumFacing.func_176737_a((float)f.getNormal().x, (float)f.getNormal().y, (float)f.getNormal().z);
            PropertyConnection connection = (PropertyConnection)((IExtendedBlockState)this.tempState).getValue((IUnlistedProperty)PropertyConnection.INSTANCE);
            return connection != null && groupName.endsWith("NONE") && this.getIconStatus(side, connection) == 2;
        }
        return false;
    }

    public byte getIconStatus(EnumFacing side, PropertyConnection connection) {
        TileEntitySidedPipe.ConnectionType type = TileEntitySidedPipe.getConnectionType(side, connection.connectionByte, connection.transmitterConnections, connection.connectionTypes);
        if (type == TileEntitySidedPipe.ConnectionType.NONE) {
            if (connection.renderCenter) {
                return 0;
            }
            if (connection.connectionByte == 3 && side != EnumFacing.DOWN && side != EnumFacing.UP) {
                return 1;
            }
            if (connection.connectionByte == 12 && (side == EnumFacing.DOWN || side == EnumFacing.UP)) {
                return 1;
            }
            if (connection.connectionByte == 12 && (side == EnumFacing.EAST || side == EnumFacing.WEST)) {
                return 2;
            }
            if (connection.connectionByte == 48 && side != EnumFacing.EAST && side != EnumFacing.WEST) {
                return 2;
            }
        }
        return 0;
    }

    @Nonnull
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        return Pair.of((Object)((Object)this), (Object)transforms.get(cameraTransformType).getMatrix());
    }

    private class TransmitterOverride
    extends ItemOverrideList {
        public TransmitterOverride() {
            super(new ArrayList());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            if (TransmitterModel.this.itemCache == null) {
                ArrayList<String> visible = new ArrayList<String>();
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    visible.add(side.func_176610_l() + (side.func_176740_k() == EnumFacing.Axis.Y ? "NORMAL" : "NONE"));
                }
                TransmitterModel.this.itemCache = new TransmitterModel(TransmitterModel.this.baseModel, TransmitterModel.this.getModel(), (IModelState)new OBJModel.OBJState(visible, true), TransmitterModel.this.vertexFormat, (ImmutableMap<String, TextureAtlasSprite>)TransmitterModel.this.textureMap, TransmitterModel.this.transformationMap);
                TransmitterModel.this.itemCache.tempStack = stack;
            }
            return TransmitterModel.this.itemCache;
        }
    }
}

