/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render.obj;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.common.model.IModelState;

public abstract class OBJBakedModelBase
extends OBJModel.OBJBakedModel {
    private static Method m_updateStateVisibilityMap;
    private static Field f_textures;
    protected IBakedModel baseModel;
    protected TextureAtlasSprite tempSprite;
    protected VertexFormat vertexFormat;
    protected ImmutableMap<String, TextureAtlasSprite> textureMap;
    protected Map<ItemCameraTransforms.TransformType, Matrix4f> transformationMap;

    public OBJBakedModelBase(IBakedModel base, OBJModel model, IModelState state, VertexFormat format, ImmutableMap<String, TextureAtlasSprite> textures, Map<ItemCameraTransforms.TransformType, Matrix4f> transform) {
        OBJModel oBJModel = model;
        Objects.requireNonNull(oBJModel);
        super(oBJModel, model, state, format, textures);
        this.tempSprite = ModelLoader.White.INSTANCE;
        this.baseModel = base;
        this.transformationMap = transform;
        this.textureMap = textures;
        this.vertexFormat = format;
        if (state instanceof OBJModel.OBJState) {
            this.updateStateVisibilityMap((OBJModel.OBJState)state);
        }
    }

    public static void putVertexData(UnpackedBakedQuad.Builder builder, OBJModel.Vertex v, OBJModel.Normal faceNormal, OBJModel.TextureCoordinate defUV, TextureAtlasSprite sprite, VertexFormat format, float[] color) {
        block6: for (int e = 0; e < format.func_177345_h(); ++e) {
            switch (format.func_177348_c(e).func_177375_c()) {
                case POSITION: {
                    builder.put(e, new float[]{v.getPos().x, v.getPos().y, v.getPos().z, v.getPos().w});
                    continue block6;
                }
                case COLOR: {
                    float d = v.hasNormal() ? LightUtil.diffuseLight((float)v.getNormal().x, (float)v.getNormal().y, (float)v.getNormal().z) : LightUtil.diffuseLight((float)faceNormal.x, (float)faceNormal.y, (float)faceNormal.z);
                    builder.put(e, new float[]{d * v.getMaterial().getColor().x * color[0], d * v.getMaterial().getColor().y * color[1], d * v.getMaterial().getColor().z * color[2], v.getMaterial().getColor().w * color[3]});
                    continue block6;
                }
                case UV: {
                    if (!v.hasTextureCoordinate()) {
                        builder.put(e, new float[]{sprite.func_94214_a((double)(defUV.u * 16.0f)), sprite.func_94207_b((double)((1.0f - defUV.v) * 16.0f)), 0.0f, 1.0f});
                        continue block6;
                    }
                    builder.put(e, new float[]{sprite.func_94214_a((double)(v.getTextureCoordinate().u * 16.0f)), sprite.func_94207_b((double)((1.0f - v.getTextureCoordinate().v) * 16.0f)), 0.0f, 1.0f});
                    continue block6;
                }
                case NORMAL: {
                    if (!v.hasNormal()) {
                        builder.put(e, new float[]{faceNormal.x, faceNormal.y, faceNormal.z, 0.0f});
                        continue block6;
                    }
                    builder.put(e, new float[]{v.getNormal().x, v.getNormal().y, v.getNormal().z, 0.0f});
                    continue block6;
                }
                default: {
                    builder.put(e, new float[0]);
                }
            }
        }
    }

    public static ImmutableMap<String, TextureAtlasSprite> getTexturesForOBJModel(IBakedModel model) {
        try {
            return (ImmutableMap)f_textures.get(model);
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            Mekanism.logger.error("Could not get private field textures", (Throwable)e);
            return ImmutableMap.of();
        }
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(IBlockState blockState, EnumFacing side, long rand) {
        if (side != null) {
            return ImmutableList.of();
        }
        ArrayList<BakedQuad> bakedQuads = new ArrayList<BakedQuad>();
        Set<Object> faces = Collections.synchronizedSet(new LinkedHashSet());
        Optional transform = Optional.empty();
        Object2ObjectOpenHashMap groupNameMap = new Object2ObjectOpenHashMap();
        for (OBJModel.Group group : this.getModel().getMatLib().getGroups().values()) {
            if (this.getState() instanceof OBJModel.OBJState) {
                OBJModel.OBJState state = (OBJModel.OBJState)this.getState();
                if (state.parent != null) {
                    transform = state.parent.apply(Optional.empty());
                }
                this.updateStateVisibilityMap(state);
                if (!state.getGroupsWithVisibility(true).contains(group.getName())) continue;
                LinkedHashSet groupFaces = group.applyTransform(transform);
                Iterator iterator = groupFaces.iterator();
                while (iterator.hasNext()) {
                    OBJModel.Face f = (OBJModel.Face)iterator.next();
                    groupNameMap.put(f, group.getName());
                    faces.add(f);
                }
                continue;
            }
            transform = this.getState().apply(Optional.empty());
            LinkedHashSet groupFaces = group.applyTransform(transform);
            for (OBJModel.Vertex[] f : groupFaces) {
                groupNameMap.put(f, group.getName());
                faces.add(f);
            }
        }
        for (OBJModel.Face face : faces) {
            String groupName;
            TextureAtlasSprite overrideTexture = this.getOverrideTexture(face, groupName = (String)groupNameMap.get(face));
            if (overrideTexture != null) {
                this.tempSprite = overrideTexture;
            } else if (this.getModel().getMatLib().getMaterial(face.getMaterialName()).isWhite()) {
                for (OBJModel.Vertex v : face.getVertices()) {
                    if (v.getMaterial().equals(this.getModel().getMatLib().getMaterial(v.getMaterial().getName()))) continue;
                    v.setMaterial(this.getModel().getMatLib().getMaterial(v.getMaterial().getName()));
                }
                this.tempSprite = ModelLoader.White.INSTANCE;
            } else {
                this.tempSprite = (TextureAtlasSprite)this.textureMap.get((Object)face.getMaterialName());
            }
            float[] color = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
            float[] overrideColor = this.getOverrideColor(face, groupName);
            if (overrideColor != null) {
                color = overrideColor;
            }
            EnumFacing facing = EnumFacing.func_176737_a((float)face.getNormal().x, (float)face.getNormal().y, (float)face.getNormal().z);
            UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(this.vertexFormat);
            builder.setContractUVs(true);
            builder.setQuadOrientation(facing);
            builder.setTexture(this.tempSprite);
            builder.setQuadTint(0);
            OBJModel.Normal faceNormal = face.getNormal();
            boolean rotate = this.shouldRotate(face, groupName);
            OBJBakedModelBase.putVertexData(builder, face.getVertices()[0], faceNormal, OBJModel.TextureCoordinate.getDefaultUVs()[0], this.tempSprite, this.vertexFormat, color);
            OBJBakedModelBase.putVertexData(builder, face.getVertices()[1], faceNormal, OBJModel.TextureCoordinate.getDefaultUVs()[1], this.tempSprite, this.vertexFormat, color);
            OBJBakedModelBase.putVertexData(builder, face.getVertices()[2], faceNormal, OBJModel.TextureCoordinate.getDefaultUVs()[2], this.tempSprite, this.vertexFormat, color);
            OBJBakedModelBase.putVertexData(builder, face.getVertices()[3], faceNormal, OBJModel.TextureCoordinate.getDefaultUVs()[3], this.tempSprite, this.vertexFormat, color);
            UnpackedBakedQuad quad = builder.build();
            if (rotate) {
                quad = MekanismRenderer.rotate((BakedQuad)quad, 1);
            }
            bakedQuads.add((BakedQuad)quad);
        }
        return bakedQuads;
    }

    protected void updateStateVisibilityMap(OBJModel.OBJState state) {
        try {
            m_updateStateVisibilityMap.invoke((Object)this, state);
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            Mekanism.logger.error("Could not get private field updateStateVisibilityMap", (Throwable)e);
        }
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.tempSprite;
    }

    protected float[] getOverrideColor(OBJModel.Face f, String groupName) {
        return null;
    }

    protected TextureAtlasSprite getOverrideTexture(OBJModel.Face f, String groupName) {
        return null;
    }

    protected boolean shouldRotate(OBJModel.Face f, String groupName) {
        return false;
    }

    static {
        try {
            f_textures = OBJModel.OBJBakedModel.class.getDeclaredField("textures");
            f_textures.setAccessible(true);
            m_updateStateVisibilityMap = OBJModel.OBJBakedModel.class.getDeclaredMethod("updateStateVisibilityMap", OBJModel.OBJState.class);
            m_updateStateVisibilityMap.setAccessible(true);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not set up reflection helpers", e);
        }
    }
}

