/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import mekanism.api.Coord4D;
import mekanism.api.MekanismAPI;
import mekanism.api.Pos3D;
import mekanism.client.ClientTickHandler;
import mekanism.client.render.particle.EntityJetpackFlameFX;
import mekanism.client.render.particle.EntityJetpackSmokeFX;
import mekanism.client.render.particle.EntityScubaBubbleFX;
import mekanism.common.ColourRGBA;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.item.ItemFlamethrower;
import mekanism.common.item.interfaces.IItemHUDProvider;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderTickHandler {
    private static final EntityEquipmentSlot[] EQUIPMENT_ORDER = new EntityEquipmentSlot[]{EntityEquipmentSlot.OFFHAND, EntityEquipmentSlot.MAINHAND, EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
    public static int modeSwitchTimer = 0;
    public Random rand = new Random();
    public Minecraft mc = Minecraft.func_71410_x();

    @SubscribeEvent
    public void tickEnd(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && this.mc.field_71439_g != null && this.mc.field_71441_e != null && !this.mc.func_147113_T()) {
            EntityPlayer p;
            Coord4D obj;
            Block block;
            FontRenderer font = this.mc.field_71466_p;
            if (font == null) {
                return;
            }
            EntityPlayerSP player = this.mc.field_71439_g;
            World world = this.mc.field_71439_g.field_70170_p;
            RayTraceResult pos = player.func_174822_a(40.0, 1.0f);
            if (pos != null && (block = (obj = new Coord4D(pos.func_178782_a(), world)).getBlock((IBlockAccess)world)) != null && MekanismAPI.debug && this.mc.field_71462_r == null && !this.mc.field_71474_y.field_74330_P) {
                String tileDisplay = "";
                if (obj.getTileEntity((IBlockAccess)world) != null && obj.getTileEntity((IBlockAccess)world).getClass() != null) {
                    tileDisplay = obj.getTileEntity((IBlockAccess)world).getClass().getSimpleName();
                }
                font.func_175063_a("Block: " + block.func_149739_a(), 1.0f, 1.0f, 0x404040);
                font.func_175063_a("Metadata: " + obj.getBlockState((IBlockAccess)world), 1.0f, 10.0f, 0x404040);
                font.func_175063_a("Location: " + MekanismUtils.getCoordDisplay(obj), 1.0f, 19.0f, 0x404040);
                font.func_175063_a("TileEntity: " + tileDisplay, 1.0f, 28.0f, 0x404040);
                font.func_175063_a("Side: " + pos.field_178784_b, 1.0f, 37.0f, 0x404040);
            }
            if (modeSwitchTimer > 1 && this.mc.field_71462_r == null && player.func_184614_ca().func_77973_b() instanceof ItemConfigurator) {
                ItemStack stack = player.func_184614_ca();
                ScaledResolution scaledresolution = new ScaledResolution(this.mc);
                ItemConfigurator.ConfiguratorMode mode = ((ItemConfigurator)stack.func_77973_b()).getState(stack);
                int x = scaledresolution.func_78326_a();
                int y = scaledresolution.func_78328_b();
                int stringWidth = font.func_78256_a(mode.getName());
                int color = new ColourRGBA(1.0, 1.0, 1.0, (float)modeSwitchTimer / 100.0f).argb();
                font.func_78276_b((Object)((Object)mode.getColor()) + mode.getName(), x / 2 - stringWidth / 2, y - 60, color);
            }
            if ((modeSwitchTimer = Math.max(modeSwitchTimer - 1, 0)) == 0) {
                ClientTickHandler.wheelStatus = 0;
            }
            if (this.mc.field_71462_r == null && !this.mc.field_71474_y.field_74319_N && !player.func_175149_v() && MekanismConfig.current().client.enableHUD.val()) {
                boolean reverseHud;
                ScaledResolution scaledresolution = new ScaledResolution(this.mc);
                int count = 0;
                ArrayList<List<String>> renderStrings = new ArrayList<List<String>>();
                for (EntityEquipmentSlot slotType : EQUIPMENT_ORDER) {
                    ItemStack stack = player.func_184582_a(slotType);
                    Item item = stack.func_77973_b();
                    if (!(item instanceof IItemHUDProvider)) continue;
                    IItemHUDProvider hudProvider = (IItemHUDProvider)item;
                    count += this.makeComponent(arg_0 -> RenderTickHandler.lambda$tickEnd$0(hudProvider, (EntityPlayer)player, stack, slotType, arg_0), renderStrings);
                }
                boolean bl = reverseHud = !MekanismConfig.current().client.alignHUDLeft.val();
                if (count > 0) {
                    float hudScale = MekanismConfig.current().client.hudScale.val();
                    int xScale = (int)((float)scaledresolution.func_78326_a() / hudScale);
                    int yScale = (int)((float)scaledresolution.func_78328_b() / hudScale);
                    int start = renderStrings.size() * 2 + count * 9;
                    int y = yScale - start;
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179152_a((float)hudScale, (float)hudScale, (float)hudScale);
                    for (List list : renderStrings) {
                        for (String text : list) {
                            int textWidth = font.func_78256_a(text);
                            int x = reverseHud ? xScale - textWidth - 2 : 2;
                            font.func_175063_a(text, (float)(MekanismConfig.current().client.hudX.val() + x), (float)(MekanismConfig.current().client.hudY.val() + y), -3618616);
                            y += 9;
                        }
                        y += 2;
                    }
                    GlStateManager.func_179121_F();
                }
            }
            for (UUID uuid : Mekanism.playerState.getActiveJetpacks()) {
                p = this.mc.field_71441_e.func_152378_a(uuid);
                if (p == null) continue;
                Pos3D playerPos = new Pos3D((Entity)p).translate(0.0, 1.7, 0.0);
                float random = (this.rand.nextFloat() - 0.5f) * 0.1f;
                Pos3D vLeft = new Pos3D(-0.43, -0.55, -0.54).rotatePitch(p.func_70093_af() ? 20.0f : 0.0f).rotateYaw(p.field_70761_aq);
                Pos3D vRight = new Pos3D(0.43, -0.55, -0.54).rotatePitch(p.func_70093_af() ? 20.0f : 0.0f).rotateYaw(p.field_70761_aq);
                Pos3D vCenter = new Pos3D((this.rand.nextFloat() - 0.5f) * 0.4f, -0.86, -0.3).rotatePitch(p.func_70093_af() ? 25.0f : 0.0f).rotateYaw(p.field_70761_aq);
                Pos3D rLeft = vLeft.scale(random);
                Pos3D rRight = vRight.scale(random);
                Pos3D pos3D = vLeft.scale(0.2).translate(new Pos3D(p.field_70159_w, p.field_70181_x, p.field_70179_y));
                Pos3D mRight = vRight.scale(0.2).translate(new Pos3D(p.field_70159_w, p.field_70181_x, p.field_70179_y));
                Pos3D mCenter = vCenter.scale(0.2).translate(new Pos3D(p.field_70159_w, p.field_70181_x, p.field_70179_y));
                Pos3D pos3D2 = pos3D.translate(rLeft);
                mRight = mRight.translate(rRight);
                Pos3D v = playerPos.translate(vLeft).translate(new Pos3D(p.field_70159_w, p.field_70181_x, p.field_70179_y));
                this.spawnAndSetParticle(EnumParticleTypes.FLAME, world, v.field_72450_a, v.field_72448_b, v.field_72449_c, pos3D2.field_72450_a, pos3D2.field_72448_b, pos3D2.field_72449_c);
                this.spawnAndSetParticle(EnumParticleTypes.SMOKE_NORMAL, world, v.field_72450_a, v.field_72448_b, v.field_72449_c, pos3D2.field_72450_a, pos3D2.field_72448_b, pos3D2.field_72449_c);
                v = playerPos.translate(vRight).translate(new Pos3D(p.field_70159_w, p.field_70181_x, p.field_70179_y));
                this.spawnAndSetParticle(EnumParticleTypes.FLAME, world, v.field_72450_a, v.field_72448_b, v.field_72449_c, mRight.field_72450_a, mRight.field_72448_b, mRight.field_72449_c);
                this.spawnAndSetParticle(EnumParticleTypes.SMOKE_NORMAL, world, v.field_72450_a, v.field_72448_b, v.field_72449_c, mRight.field_72450_a, mRight.field_72448_b, mRight.field_72449_c);
                v = playerPos.translate(vCenter).translate(new Pos3D(p.field_70159_w, p.field_70181_x, p.field_70179_y));
                this.spawnAndSetParticle(EnumParticleTypes.FLAME, world, v.field_72450_a, v.field_72448_b, v.field_72449_c, mCenter.field_72450_a, mCenter.field_72448_b, mCenter.field_72449_c);
                this.spawnAndSetParticle(EnumParticleTypes.SMOKE_NORMAL, world, v.field_72450_a, v.field_72448_b, v.field_72449_c, mCenter.field_72450_a, mCenter.field_72448_b, mCenter.field_72449_c);
            }
            if (world.func_72820_D() % 4L == 0L) {
                for (UUID uuid : Mekanism.playerState.getActiveGasmasks()) {
                    p = this.mc.field_71441_e.func_152378_a(uuid);
                    if (p == null || !p.func_70090_H()) continue;
                    Pos3D playerPos = new Pos3D((Entity)p).translate(0.0, 1.7, 0.0);
                    float xRand = (this.rand.nextFloat() - 0.5f) * 0.08f;
                    float yRand = (this.rand.nextFloat() - 0.5f) * 0.05f;
                    Pos3D vec = new Pos3D(0.4, 0.4, 0.4).multiply(new Pos3D(p.func_70676_i(1.0f))).translate(0.0, -0.2, 0.0);
                    Pos3D motion = vec.scale(0.2).translate(new Pos3D(p.field_70159_w, p.field_70181_x, p.field_70179_y));
                    Pos3D v = playerPos.translate(vec);
                    this.spawnAndSetParticle(EnumParticleTypes.WATER_BUBBLE, world, v.field_72450_a, v.field_72448_b, v.field_72449_c, motion.field_72450_a, motion.field_72448_b + 0.2, motion.field_72449_c);
                }
            }
            if (world.func_72820_D() % 4L == 0L) {
                for (EntityPlayer p2 : world.field_73010_i) {
                    Pos3D flameVec;
                    ItemStack currentItem;
                    if (Mekanism.playerState.isFlamethrowerOn(p2) || p2.field_82175_bq || (currentItem = p2.field_71071_by.func_70448_g()).func_190926_b() || !(currentItem.func_77973_b() instanceof ItemFlamethrower) || ((ItemFlamethrower)currentItem.func_77973_b()).getGas(currentItem) == null) continue;
                    Pos3D playerPos = new Pos3D((Entity)p2);
                    double flameXCoord = 0.0;
                    double flameYCoord = 1.5;
                    double flameZCoord = 0.0;
                    Pos3D flameMotion = new Pos3D(p2.field_70159_w, p2.field_70122_E ? 0.0 : p2.field_70181_x, p2.field_70179_y);
                    if (player == p2 && this.mc.field_71474_y.field_74320_O == 0) {
                        flameVec = new Pos3D(1.0, 1.0, 1.0).multiply(p2.func_70676_i(1.0f)).rotateYaw(5.0f).translate(flameXCoord, flameYCoord + 0.1, flameZCoord);
                    } else {
                        flameXCoord += 0.25;
                        flameXCoord -= (double)0.45f;
                        flameZCoord += (double)0.15f;
                        if (p2.func_70093_af()) {
                            flameYCoord -= (double)0.55f;
                            flameZCoord -= (double)0.15f;
                        }
                        flameYCoord = player == p2 ? (flameYCoord -= 0.5) : (flameYCoord -= 0.5);
                        flameVec = new Pos3D(flameXCoord, flameYCoord, flameZCoord += (double)1.05f).rotateYaw(p2.field_70761_aq);
                    }
                    Pos3D mergedVec = playerPos.translate(flameVec);
                    this.spawnAndSetParticle(EnumParticleTypes.FLAME, world, mergedVec.field_72450_a, mergedVec.field_72448_b, mergedVec.field_72449_c, flameMotion.field_72450_a, flameMotion.field_72448_b, flameMotion.field_72449_c);
                }
            }
        }
    }

    public void spawnAndSetParticle(EnumParticleTypes s, World world, double x, double y, double z, double velX, double velY, double velZ) {
        Object fx = null;
        if (s.equals((Object)EnumParticleTypes.FLAME)) {
            fx = new EntityJetpackFlameFX(world, x, y, z, velX, velY, velZ);
        } else if (s.equals((Object)EnumParticleTypes.SMOKE_NORMAL)) {
            fx = new EntityJetpackSmokeFX(world, x, y, z, velX, velY, velZ);
        } else if (s.equals((Object)EnumParticleTypes.WATER_BUBBLE)) {
            fx = new EntityScubaBubbleFX(world, x, y, z, velX, velY, velZ);
        }
        this.mc.field_71452_i.func_78873_a((Particle)fx);
    }

    private void drawString(ScaledResolution res, String s, boolean leftSide, int y, int color) {
        FontRenderer font = this.mc.field_71466_p;
        if (leftSide) {
            font.func_175063_a(s, 2.0f, (float)y, color);
        } else {
            int width = font.func_78256_a(s) + 2;
            font.func_175063_a(s, (float)(res.func_78326_a() - width), (float)y, color);
        }
    }

    private int makeComponent(Consumer<List<String>> adder, List<List<String>> initial) {
        ArrayList list = new ArrayList();
        adder.accept(list);
        int size = list.size();
        if (size > 0) {
            initial.add(list);
        }
        return size;
    }

    private static /* synthetic */ void lambda$tickEnd$0(IItemHUDProvider hudProvider, EntityPlayer player, ItemStack stack, EntityEquipmentSlot slotType, List list) {
        hudProvider.addHUDStrings(list, player, stack, slotType);
    }
}

