/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import mekanism.client.model.mekasuitarmour.ModelMekAsuitBodyArm;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.config.MekanismConfig;
import mekanism.common.item.armor.ItemMekAsuitBodyArmour;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class RenderFirstPersonMekaSuitArms {
    @SubscribeEvent
    public void renderHand(RenderSpecificHandEvent event) {
        ItemStack chestStack;
        if (!MekanismConfig.current().client.enableFirstPersonMekaSuitArms.val()) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && !player.func_82150_aj() && !player.func_175149_v() && (chestStack = player.func_184582_a(EntityEquipmentSlot.CHEST)).func_77973_b() instanceof ItemMekAsuitBodyArmour) {
            ItemStack stack = event.getItemStack();
            EnumHand hand = event.getHand();
            if (stack.func_190926_b()) {
                if (hand == EnumHand.MAIN_HAND) {
                    this.renderFirstPersonHand((AbstractClientPlayer)player, player.func_184591_cq() == EnumHandSide.RIGHT, event.getSwingProgress(), event.getEquipProgress());
                    event.setCanceled(true);
                }
            } else if (stack.func_77973_b() instanceof ItemMap) {
                if (hand == EnumHand.MAIN_HAND && player.func_184592_cb().func_190926_b()) {
                    this.renderTwoHandedMap((AbstractClientPlayer)player, event.getSwingProgress(), event.getEquipProgress(), event.getInterpolatedPitch(), stack);
                } else {
                    this.renderOneHandedMap((AbstractClientPlayer)player, event.getSwingProgress(), event.getEquipProgress(), hand, stack);
                }
                event.setCanceled(true);
            }
        }
    }

    private void renderArm(boolean rightHand, AbstractClientPlayer player) {
        ModelMekAsuitBodyArm armor = ModelMekAsuitBodyArm.armorModel;
        armor.func_178719_a(true);
        if (rightHand) {
            armor.field_187076_m = ModelBiped.ArmPose.EMPTY;
        } else {
            armor.field_187075_l = ModelBiped.ArmPose.EMPTY;
        }
        GlStateManager.func_179147_l();
        armor.field_78117_n = false;
        armor.field_78095_p = 0.0f;
        armor.func_78087_a(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0625f, (Entity)player);
        MekanismRenderer.bindTexture(MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "MekAsuit.png"));
        if (rightHand) {
            armor.rightArmRender(0.0625f);
        } else {
            armor.leftArmRender(0.0625f);
        }
        GlStateManager.func_179084_k();
    }

    private void renderFirstPersonHand(AbstractClientPlayer player, boolean rightHand, float swingProgress, float equipProgress) {
        GlStateManager.func_179094_E();
        float f = rightHand ? 1.0f : -1.0f;
        float f1 = MathHelper.func_76129_c((float)swingProgress);
        float f2 = -0.3f * MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f4 = -0.4f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        GlStateManager.func_179109_b((float)(f * (f2 + 0.64000005f)), (float)(f3 - 0.6f + equipProgress * -0.6f), (float)(f4 - 0.71999997f));
        GlStateManager.func_179114_b((float)(f * 45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        float f5 = MathHelper.func_76126_a((float)(swingProgress * swingProgress * (float)Math.PI));
        float f6 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        GlStateManager.func_179114_b((float)(f * f6 * 70.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * f5 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179137_b((double)(f * -1.0f), (double)3.6f, (double)3.5);
        GlStateManager.func_179114_b((float)(f * 120.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * -135.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)(f * 5.6f), (float)0.0f, (float)0.0f);
        this.renderArm(rightHand, player);
        GlStateManager.func_179121_F();
    }

    private void renderTwoHandedMap(AbstractClientPlayer player, float swingProgress, float equipProgress, float interpolatedPitch, ItemStack map) {
        GlStateManager.func_179094_E();
        ItemRenderer firstPersonRenderer = Minecraft.func_71410_x().func_175597_ag();
        float f = MathHelper.func_76129_c((float)swingProgress);
        float f1 = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        float f2 = -0.4f * MathHelper.func_76126_a((float)(f * (float)Math.PI));
        GlStateManager.func_179137_b((double)0.0, (double)(-f1 / 2.0f), (double)f2);
        float f3 = firstPersonRenderer.func_178100_c(interpolatedPitch);
        GlStateManager.func_179137_b((double)0.0, (double)(0.04f + equipProgress * -1.2f + f3 * -0.5f), (double)-0.72f);
        GlStateManager.func_179114_b((float)(f3 * -85.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)92.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)45.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        this.renderMapHand(true, player);
        this.renderMapHand(false, player);
        GlStateManager.func_179121_F();
        float f4 = MathHelper.func_76126_a((float)(f * (float)Math.PI));
        GlStateManager.func_179114_b((float)(f4 * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        firstPersonRenderer.func_187461_a(map);
        GlStateManager.func_179121_F();
    }

    private void renderMapHand(boolean rightHand, AbstractClientPlayer player) {
        GlStateManager.func_179094_E();
        float f = rightHand ? 1.0f : -1.0f;
        GlStateManager.func_179114_b((float)(f * -41.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(f * 0.3f), (float)-1.1f, (float)0.45f);
        this.renderArm(rightHand, player);
        GlStateManager.func_179121_F();
    }

    private void renderOneHandedMap(AbstractClientPlayer player, float swingProgress, float equipProgress, EnumHand hand, ItemStack map) {
        boolean rightHand = player.func_184591_cq() == EnumHandSide.RIGHT == (hand == EnumHand.MAIN_HAND);
        float f = rightHand ? 1.0f : -1.0f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(f * 0.125f), (double)-0.125, (double)0.0);
        GlStateManager.func_179094_E();
        GlStateManager.func_179114_b((float)(f * 10.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderFirstPersonHand(player, rightHand, swingProgress, equipProgress);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(f * 0.51f), (double)(-0.08f + equipProgress * -1.2f), (double)-0.75);
        float f1 = MathHelper.func_76129_c((float)swingProgress);
        float f2 = MathHelper.func_76126_a((float)(f1 * (float)Math.PI));
        float f3 = -0.5f * f2;
        float f4 = 0.4f * MathHelper.func_76126_a((float)(f1 * ((float)Math.PI * 2)));
        float f5 = -0.3f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        GlStateManager.func_179109_b((float)(f * f3), (float)(f4 - 0.3f * f2), (float)f5);
        GlStateManager.func_179114_b((float)(f2 * -45.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(f * f2 * -30.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        Minecraft.func_71410_x().func_175597_ag().func_187461_a(map);
        GlStateManager.func_179121_F();
        GlStateManager.func_179121_F();
    }
}

