/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.init.Blocks;

public final class MinerVisualRenderer {
    private static final double offset = 0.01;
    private static Minecraft mc = Minecraft.func_71410_x();
    private static Map<MinerRenderData, MekanismRenderer.DisplayInteger> cachedVisuals = new Object2ObjectOpenHashMap();

    public static void render(TileEntityDigitalMiner miner) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)MinerVisualRenderer.getX(miner.func_174877_v().func_177958_n())), (float)((float)MinerVisualRenderer.getY(miner.func_174877_v().func_177956_o())), (float)((float)MinerVisualRenderer.getZ(miner.func_174877_v().func_177952_p())));
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        MekanismRenderer.GlowInfo glowInfo = MekanismRenderer.enableGlow();
        GlStateManager.func_179089_o();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        mc.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        MinerVisualRenderer.getList(new MinerRenderData(miner)).render();
        MekanismRenderer.resetColor();
        GlStateManager.func_179129_p();
        MekanismRenderer.disableGlow(glowInfo);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179121_F();
    }

    private static MekanismRenderer.DisplayInteger getList(MinerRenderData data) {
        if (cachedVisuals.containsKey(data)) {
            return cachedVisuals.get(data);
        }
        MekanismRenderer.DisplayInteger display = MekanismRenderer.DisplayInteger.createAndStart();
        cachedVisuals.put(data, display);
        MekanismRenderer.Model3D toReturn = new MekanismRenderer.Model3D();
        if (data.radius <= 64) {
            toReturn.setBlockBounds((double)(-data.radius) + 0.01, (double)(data.minY - data.yCoord) + 0.01, (double)(-data.radius) + 0.01, (double)(data.radius + 1) - 0.01, (double)(data.maxY - data.yCoord + 1) - 0.01, (double)(data.radius + 1) - 0.01);
            toReturn.baseBlock = Blocks.field_150355_j;
            toReturn.setTexture(MekanismRenderer.whiteIcon);
            MekanismRenderer.renderObject(toReturn);
        }
        MekanismRenderer.DisplayInteger.endList();
        return display;
    }

    private static double getX(int x) {
        return (double)x - TileEntityRendererDispatcher.field_147554_b;
    }

    private static double getY(int y) {
        return (double)y - TileEntityRendererDispatcher.field_147555_c;
    }

    private static double getZ(int z) {
        return (double)z - TileEntityRendererDispatcher.field_147552_d;
    }

    public static class MinerRenderData {
        public int minY;
        public int maxY;
        public int radius;
        public int yCoord;

        public MinerRenderData(int min, int max, int rad, int y) {
            this.minY = min;
            this.maxY = max;
            this.radius = rad;
            this.yCoord = y;
        }

        public MinerRenderData(TileEntityDigitalMiner miner) {
            this(miner.minY, miner.maxY, miner.getRadius(), miner.func_174877_v().func_177956_o());
        }

        public boolean equals(Object data) {
            return data instanceof MinerRenderData && ((MinerRenderData)data).minY == this.minY && ((MinerRenderData)data).maxY == this.maxY && ((MinerRenderData)data).radius == this.radius && ((MinerRenderData)data).yCoord == this.yCoord;
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.minY;
            code = 31 * code + this.maxY;
            code = 31 * code + this.radius;
            code = 31 * code + this.yCoord;
            return code;
        }
    }
}

