/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.render;

import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.EnumColor;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.api.infuse.InfuseType;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.render.FluidRenderer;
import mekanism.client.render.RenderResizableCuboid;
import mekanism.client.render.obj.TransmitterModel;
import mekanism.client.render.tileentity.RenderChemicalCrystallizer;
import mekanism.client.render.tileentity.RenderChemicalDissolutionChamber;
import mekanism.client.render.tileentity.RenderConfigurableMachine;
import mekanism.client.render.tileentity.RenderFluidTank;
import mekanism.client.render.tileentity.RenderIsotopicCentrifuge;
import mekanism.client.render.tileentity.RenderNutritionalLiquifier;
import mekanism.client.render.transmitter.RenderLogisticalTransporter;
import mekanism.client.render.transmitter.RenderMechanicalPipe;
import mekanism.common.base.IMetaItem;
import mekanism.common.tier.BaseTier;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MekanismRenderer {
    public static final GlowInfo NO_GLOW = new GlowInfo(0.0f, 0.0f, false);
    public static TextureAtlasSprite energyIcon;
    public static TextureAtlasSprite heatIcon;
    public static TextureAtlasSprite laserIcon;
    public static TextureAtlasSprite whiteIcon;
    public static Map<TransmissionType, TextureAtlasSprite> overlays;
    private static RenderConfigurableMachine machineRenderer;
    public static TextureAtlasSprite missingIcon;
    private static TextureMap texMap;

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new MekanismRenderer());
    }

    public static <S extends TileEntity> RenderConfigurableMachine<S> machineRenderer() {
        return machineRenderer;
    }

    public static void registerItemRender(String domain, Item item) {
        if (item instanceof IMetaItem) {
            IMetaItem metaItem = (IMetaItem)item;
            for (int i = 0; i < metaItem.getVariants(); ++i) {
                if (metaItem.getTexture(i) == null) continue;
                ModelResourceLocation loc = new ModelResourceLocation(new ResourceLocation(domain, metaItem.getTexture(i)), "inventory");
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)loc);
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(domain, metaItem.getTexture(i))});
            }
            return;
        }
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "inventory"));
    }

    public static void initFluidTextures(TextureMap map) {
        missingIcon = map.func_174944_f();
        texMap = map;
    }

    public static TextureAtlasSprite getBaseFluidTexture(Fluid fluid, FluidType type) {
        if (fluid == null || type == null) {
            return missingIcon;
        }
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getStill() : fluid.getFlowing();
        return MekanismRenderer.getTextureAtlasSprite(spriteLocation);
    }

    public static TextureAtlasSprite getFluidTexture(FluidStack fluidStack, FluidType type) {
        if (fluidStack == null || type == null) {
            return missingIcon;
        }
        Fluid fluid = fluidStack.getFluid();
        ResourceLocation spriteLocation = type == FluidType.STILL ? fluid.getStill(fluidStack) : fluid.getFlowing(fluidStack);
        return MekanismRenderer.getTextureAtlasSprite(spriteLocation);
    }

    public static TextureAtlasSprite getTextureAtlasSprite(ResourceLocation spriteLocation) {
        TextureAtlasSprite sprite = texMap.getTextureExtry(spriteLocation.toString());
        return sprite != null ? sprite : missingIcon;
    }

    public static RenderState pauseRenderer(Tessellator tess) {
        RenderState state = null;
        if (MekanismRenderer.isDrawing(tess)) {
            state = new RenderState(tess.func_178180_c().func_178973_g(), tess.func_178180_c().func_178979_i());
            tess.func_78381_a();
        }
        return state;
    }

    public static void resumeRenderer(Tessellator tess, RenderState renderState) {
        if (renderState != null) {
            tess.func_178180_c().func_181668_a(renderState.prevMode, renderState.prevFormat);
        }
    }

    public static boolean isDrawing(Tessellator tess) {
        return tess.func_178180_c().field_179010_r;
    }

    public static boolean isDrawing(BufferBuilder buffer) {
        return buffer.field_179010_r;
    }

    public static BakedQuad iconTransform(BakedQuad quad, TextureAtlasSprite sprite) {
        int[] vertices = new int[quad.func_178209_a().length];
        System.arraycopy(quad.func_178209_a(), 0, vertices, 0, vertices.length);
        for (int i = 0; i < 4; ++i) {
            int uvIndex;
            int j = quad.getFormat().func_181719_f() * i;
            if (j + (uvIndex = quad.getFormat().func_177344_b(0) / 4) + 1 >= vertices.length) continue;
            vertices[j + uvIndex] = Float.floatToRawIntBits(sprite.func_94214_a((double)quad.func_187508_a().func_188537_a(Float.intBitsToFloat(vertices[j + uvIndex]))));
            vertices[j + uvIndex + 1] = Float.floatToRawIntBits(sprite.func_94207_b((double)quad.func_187508_a().func_188536_b(Float.intBitsToFloat(vertices[j + uvIndex + 1]))));
        }
        return new BakedQuad(vertices, quad.func_178211_c(), quad.func_178210_d(), sprite, quad.shouldApplyDiffuseLighting(), quad.getFormat());
    }

    public static BakedQuad rotate(BakedQuad quad, int amount) {
        int[] vertices = new int[quad.func_178209_a().length];
        System.arraycopy(quad.func_178209_a(), 0, vertices, 0, vertices.length);
        for (int i = 0; i < 4; ++i) {
            int nextIndex = (i + amount) % 4;
            int quadSize = quad.getFormat().func_181719_f();
            int uvIndex = quad.getFormat().func_177344_b(0) / 4;
            if (i + uvIndex + 1 >= vertices.length) continue;
            vertices[quadSize * i + uvIndex] = quad.func_178209_a()[quadSize * nextIndex + uvIndex];
            vertices[quadSize * i + uvIndex + 1] = quad.func_178209_a()[quadSize * nextIndex + uvIndex + 1];
        }
        return new BakedQuad(vertices, quad.func_178211_c(), quad.func_178210_d(), quad.func_187508_a(), quad.shouldApplyDiffuseLighting(), quad.getFormat());
    }

    public static void prepFlowing(Model3D model, FluidStack fluid) {
        TextureAtlasSprite still = MekanismRenderer.getFluidTexture(fluid, FluidType.STILL);
        TextureAtlasSprite flowing = MekanismRenderer.getFluidTexture(fluid, FluidType.FLOWING);
        model.setTextures(still, still, flowing, flowing, flowing, flowing);
    }

    public static void renderObject(Model3D object) {
        if (object == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)object.minX), (float)((float)object.minY), (float)((float)object.minZ));
        RenderResizableCuboid.INSTANCE.renderCube(object);
        GlStateManager.func_179121_F();
    }

    public static void bindTexture(ResourceLocation texture) {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
    }

    public static void resetColor() {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static float getRed(int color) {
        return (float)(color >> 16 & 0xFF) / 255.0f;
    }

    private static float getGreen(int color) {
        return (float)(color >> 8 & 0xFF) / 255.0f;
    }

    private static float getBlue(int color) {
        return (float)(color & 0xFF) / 255.0f;
    }

    public static void color(int color) {
        GlStateManager.func_179131_c((float)MekanismRenderer.getRed(color), (float)MekanismRenderer.getGreen(color), (float)MekanismRenderer.getBlue(color), (float)((float)(color >> 24 & 0xFF) / 255.0f));
    }

    public static void color(@Nullable FluidStack fluid, float fluidScale) {
        if (fluid != null) {
            int color = fluid.getFluid().getColor(fluid);
            if (fluid.getFluid().isGaseous(fluid)) {
                GlStateManager.func_179131_c((float)MekanismRenderer.getRed(color), (float)MekanismRenderer.getGreen(color), (float)MekanismRenderer.getBlue(color), (float)Math.min(1.0f, fluidScale + 0.2f));
            } else {
                MekanismRenderer.color(color);
            }
        }
    }

    public static void color(@Nullable FluidStack fluid) {
        if (fluid != null && fluid.getFluid() != null) {
            MekanismRenderer.color(fluid.getFluid().getColor(fluid));
        }
    }

    public static void color(@Nullable Fluid fluid) {
        if (fluid != null) {
            MekanismRenderer.color(fluid.getColor());
        }
    }

    public static void color(@Nullable GasStack gasStack) {
        if (gasStack != null) {
            MekanismRenderer.color(gasStack.getGas());
        }
    }

    public static void color(@Nullable Gas gas) {
        if (gas != null) {
            MekanismRenderer.color(gas, 1.0f);
        }
    }

    public static void color(@Nullable Gas gas, float alpha) {
        if (gas != null) {
            int color = gas.getTint();
            GlStateManager.func_179131_c((float)MekanismRenderer.getRed(color), (float)MekanismRenderer.getGreen(color), (float)MekanismRenderer.getBlue(color), (float)alpha);
        }
    }

    public static void color(@Nonnull BaseTier tier) {
        MekanismRenderer.color(tier.getColor());
    }

    public static void color(@Nullable EnumColor color) {
        MekanismRenderer.color(color, 1.0f);
    }

    public static void color(@Nullable EnumColor color, float alpha) {
        MekanismRenderer.color(color, alpha, 1.0f);
    }

    public static void color(@Nullable EnumColor color, float alpha, float multiplier) {
        if (color != null) {
            GlStateManager.func_179131_c((float)(color.getColor(0) * multiplier), (float)(color.getColor(1) * multiplier), (float)(color.getColor(2) * multiplier), (float)alpha);
        }
    }

    public static int getColorARGB(EnumColor color, float alpha) {
        if (alpha < 0.0f) {
            alpha = 0.0f;
        } else if (alpha > 1.0f) {
            alpha = 1.0f;
        }
        int argb = (int)(255.0f * alpha) << 24;
        argb |= color.rgbCode[0] << 16;
        argb |= color.rgbCode[1] << 8;
        return argb |= color.rgbCode[2];
    }

    @Nonnull
    public static GlowInfo enableGlow() {
        return MekanismRenderer.enableGlow(15);
    }

    @Nonnull
    public static GlowInfo enableGlow(int glow) {
        if (!FMLClientHandler.instance().hasOptifine() && glow > 0) {
            GlowInfo info = new GlowInfo(OpenGlHelper.lastBrightnessX, OpenGlHelper.lastBrightnessY, true);
            float glowStrength = (float)glow / 15.0f * 240.0f;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)Math.min(glowStrength + info.lightmapLastX, 240.0f), (float)Math.min(glowStrength + info.lightmapLastY, 240.0f));
            return info;
        }
        return NO_GLOW;
    }

    @Nonnull
    public static GlowInfo enableGlow(@Nullable FluidStack fluid) {
        return fluid == null ? NO_GLOW : MekanismRenderer.enableGlow(fluid.getFluid().getLuminosity(fluid));
    }

    @Nonnull
    public static GlowInfo enableGlow(@Nullable Fluid fluid) {
        return fluid == null ? NO_GLOW : MekanismRenderer.enableGlow(fluid.getLuminosity());
    }

    public static void disableGlow(@Nonnull GlowInfo info) {
        if (info.glowEnabled) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)info.lightmapLastX, (float)info.lightmapLastY);
        }
    }

    public static float getPartialTick() {
        return Minecraft.func_71410_x().func_184121_ak();
    }

    public static void rotate(EnumFacing facing, float north, float south, float west, float east) {
        switch (facing) {
            case NORTH: {
                GlStateManager.func_179114_b((float)north, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)south, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)west, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)east, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
    }

    @SubscribeEvent
    public void onStitch(TextureStitchEvent.Pre event) {
        for (TransmissionType type : TransmissionType.values()) {
            overlays.put(type, event.getMap().func_174942_a(new ResourceLocation("mekanism", "blocks/overlay/" + type.getTransmission() + "Overlay")));
        }
        whiteIcon = event.getMap().func_174942_a(new ResourceLocation("mekanism", "blocks/overlay/overlay_white"));
        energyIcon = event.getMap().func_174942_a(new ResourceLocation("mekanism", "blocks/liquid/LiquidEnergy"));
        heatIcon = event.getMap().func_174942_a(new ResourceLocation("mekanism", "blocks/liquid/LiquidHeat"));
        laserIcon = event.getMap().func_174942_a(new ResourceLocation("mekanism", "blocks/Laser"));
        event.getMap().func_174942_a(new ResourceLocation("mekanism", "blocks/liquid/LiquidHeavyWater"));
        TransmitterModel.registerIcons(event.getMap());
        for (Gas gas : GasRegistry.getRegisteredGasses()) {
            gas.registerIcon(event.getMap());
        }
        for (InfuseType type : InfuseRegistry.getInfuseMap().values()) {
            type.setIcon(event.getMap().func_174942_a(type.iconResource));
        }
        FluidRenderer.resetDisplayInts();
        RenderFluidTank.resetDisplayInts();
        RenderNutritionalLiquifier.resetDisplayInts();
        RenderIsotopicCentrifuge.resetDisplayInts();
        RenderChemicalCrystallizer.resetDisplayInts();
        RenderChemicalDissolutionChamber.resetDisplayInts();
    }

    @SubscribeEvent
    public void onStitch(TextureStitchEvent.Post event) {
        MekanismRenderer.initFluidTextures(event.getMap());
        RenderLogisticalTransporter.onStitch(event.getMap());
        RenderMechanicalPipe.onStitch();
        for (Gas gas : GasRegistry.getRegisteredGasses()) {
            gas.updateIcon(event.getMap());
        }
    }

    static {
        overlays = new EnumMap<TransmissionType, TextureAtlasSprite>(TransmissionType.class);
        machineRenderer = new RenderConfigurableMachine();
        texMap = null;
    }

    public static enum FluidType {
        STILL,
        FLOWING;

    }

    public static class RenderState {
        private final VertexFormat prevFormat;
        private final int prevMode;

        private RenderState(VertexFormat prevFormat, int prevMode) {
            this.prevFormat = prevFormat;
            this.prevMode = prevMode;
        }
    }

    public static class Model3D {
        public double posX;
        public double posY;
        public double posZ;
        public double minX;
        public double minY;
        public double minZ;
        public double maxX;
        public double maxY;
        public double maxZ;
        public double textureStartX = 0.0;
        public double textureStartY = 0.0;
        public double textureStartZ = 0.0;
        public double textureSizeX = 16.0;
        public double textureSizeY = 16.0;
        public double textureSizeZ = 16.0;
        public double textureOffsetX = 0.0;
        public double textureOffsetY = 0.0;
        public double textureOffsetZ = 0.0;
        public int[] textureFlips = new int[]{2, 2, 2, 2, 2, 2};
        public TextureAtlasSprite[] textures = new TextureAtlasSprite[6];
        public boolean[] renderSides = new boolean[]{true, true, true, true, true, true, false};
        public Block baseBlock = Blocks.field_150354_m;

        public final void setBlockBounds(double xNeg, double yNeg, double zNeg, double xPos, double yPos, double zPos) {
            this.minX = xNeg;
            this.minY = yNeg;
            this.minZ = zNeg;
            this.maxX = xPos;
            this.maxY = yPos;
            this.maxZ = zPos;
        }

        public double sizeX() {
            return this.maxX - this.minX;
        }

        public double sizeY() {
            return this.maxY - this.minY;
        }

        public double sizeZ() {
            return this.maxZ - this.minZ;
        }

        public void setSideRender(EnumFacing side, boolean value) {
            this.renderSides[side.ordinal()] = value;
        }

        public boolean shouldSideRender(EnumFacing side) {
            return this.renderSides[side.ordinal()];
        }

        public TextureAtlasSprite getBlockTextureFromSide(int i) {
            return this.textures[i];
        }

        public void setTexture(TextureAtlasSprite tex) {
            Arrays.fill(this.textures, tex);
        }

        public void setTextures(TextureAtlasSprite down, TextureAtlasSprite up, TextureAtlasSprite north, TextureAtlasSprite south, TextureAtlasSprite west, TextureAtlasSprite east) {
            this.textures[0] = down;
            this.textures[1] = up;
            this.textures[2] = north;
            this.textures[3] = south;
            this.textures[4] = west;
            this.textures[5] = east;
        }
    }

    public static class GlowInfo {
        private final boolean glowEnabled;
        private final float lightmapLastX;
        private final float lightmapLastY;

        public GlowInfo(float lightmapLastX, float lightmapLastY, boolean glowEnabled) {
            this.lightmapLastX = lightmapLastX;
            this.lightmapLastY = lightmapLastY;
            this.glowEnabled = glowEnabled;
        }
    }

    public static class DisplayInteger {
        public int display;

        public static DisplayInteger createAndStart() {
            DisplayInteger newInteger = new DisplayInteger();
            newInteger.display = GLAllocation.func_74526_a((int)1);
            GlStateManager.func_187423_f((int)newInteger.display, (int)4864);
            return newInteger;
        }

        public static void endList() {
            GlStateManager.func_187415_K();
        }

        public int hashCode() {
            int code = 1;
            code = 31 * code + this.display;
            return code;
        }

        public boolean equals(Object obj) {
            return obj instanceof DisplayInteger && ((DisplayInteger)obj).display == this.display;
        }

        public void render() {
            GlStateManager.func_179148_o((int)this.display);
        }
    }

    public static interface ICustomBlockIcon {
        public ResourceLocation getIcon(ItemStack var1, int var2);
    }
}

