/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import com.google.common.base.MoreObjects;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.common.MekanismBlocks;
import mekanism.common.util.ItemDataUtils;
import mezz.jei.api.ingredients.IIngredientHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class GasStackHelper
implements IIngredientHelper<GasStack> {
    public List<GasStack> expandSubtypes(List<GasStack> contained) {
        return contained;
    }

    @Nullable
    public GasStack getMatch(Iterable<GasStack> ingredients, GasStack toMatch) {
        for (GasStack stack : ingredients) {
            if (toMatch.getGas() != stack.getGas()) continue;
            return stack;
        }
        return null;
    }

    public String getDisplayName(GasStack ingredient) {
        return ingredient.getGas().getLocalizedName();
    }

    public String getUniqueId(GasStack ingredient) {
        return "gas:" + ingredient.getGas().getName();
    }

    public String getWildcardId(GasStack ingredient) {
        return this.getUniqueId(ingredient);
    }

    public String getModId(GasStack ingredient) {
        return ingredient.getGas().getIcon().func_110624_b();
    }

    public Iterable<Color> getColors(GasStack ingredient) {
        return Collections.emptyList();
    }

    public String getResourceId(GasStack ingredient) {
        return ingredient.getGas().getTranslationKey();
    }

    public ItemStack getCheatItemStack(GasStack ingredient) {
        ItemStack gas = new ItemStack(MekanismBlocks.GasTank);
        if (!gas.func_77942_o()) {
            gas.func_77982_d(new NBTTagCompound());
        }
        gas.func_77978_p().func_74768_a("tier", 4);
        GasStack gasStack = new GasStack(ingredient.getGas(), Integer.MAX_VALUE);
        ItemDataUtils.setCompound(gas, "stored", gasStack.write(new NBTTagCompound()));
        return gas;
    }

    public GasStack copyIngredient(GasStack ingredient) {
        return ingredient.copy();
    }

    public String getErrorInfo(@Nullable GasStack ingredient) {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper(GasStack.class);
        Gas gas = ingredient == null ? null : ingredient.getGas();
        toStringHelper.add("Gas", (Object)(gas != null ? gas.getLocalizedName() : "null"));
        if (ingredient != null) {
            toStringHelper.add("Amount", ingredient.amount);
        }
        return toStringHelper.toString();
    }
}

