/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import mekanism.api.Coord4D;
import mekanism.client.gui.button.GuiColorButton;
import mekanism.client.gui.button.GuiDisableableButton;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.filter.GuiModIDFilter;
import mekanism.common.Mekanism;
import mekanism.common.OreDictCache;
import mekanism.common.content.transporter.TModIDFilter;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiTModIDFilter
extends GuiModIDFilter<TModIDFilter, TileEntityLogisticalSorter> {
    public GuiTModIDFilter(EntityPlayer player, TileEntityLogisticalSorter tile, int index) {
        super(player, tile);
        this.origFilter = (TModIDFilter)((TileEntityLogisticalSorter)this.tileEntity).filters.get(index);
        this.filter = ((TModIDFilter)((TileEntityLogisticalSorter)this.tileEntity).filters.get(index)).clone();
        this.updateStackList(((TModIDFilter)this.filter).getModID());
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, this.getGuiLocation(), 11, 18));
        this.addGuiElement(new GuiInnerScreen(this, this.getGuiLocation(), 33, 18, 111, 43));
        this.addGuiElement(new GuiPlayerSlot(this, this.getGuiLocation()));
    }

    public GuiTModIDFilter(EntityPlayer player, TileEntityLogisticalSorter tile) {
        super(player, tile);
        this.isNew = true;
        this.filter = new TModIDFilter();
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, this.getGuiLocation(), 11, 18));
        this.addGuiElement(new GuiInnerScreen(this, this.getGuiLocation(), 33, 18, 111, 43));
        this.addGuiElement(new GuiPlayerSlot(this, this.getGuiLocation()));
    }

    private void updateEnabledButtons() {
        this.checkboxButton.field_146124_l = !this.text.func_146179_b().isEmpty();
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.updateEnabledButtons();
    }

    @Override
    protected void updateStackList(String modName) {
        this.iterStacks = OreDictCache.getModIDStacks(modName, false);
        this.stackSwitch = 0;
        this.stackIndex = -1;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.SWITCH, "switch_icon.png"));
        this.func_73729_b(this.field_147003_i + 38, this.field_147009_r + 48, 43, 0, 4, 7);
    }

    @Override
    protected void addButtons() {
        this.saveButton = new GuiDisableableButton(0, this.field_147003_i + 47, this.field_147009_r + 62, 60, 20, LangUtils.localize("gui.save"));
        this.field_146292_n.add(this.saveButton);
        this.deleteButton = new GuiDisableableButton(1, this.field_147003_i + 109, this.field_147009_r + 62, 60, 20, LangUtils.localize("gui.delete"));
        this.field_146292_n.add(this.deleteButton);
        this.backButton = new GuiDisableableButton(2, this.field_147003_i + 5, this.field_147009_r + 5, 11, 11).with(GuiDisableableButton.ImageOverlay.SMALL_BACK);
        this.field_146292_n.add(this.backButton);
        this.defaultButton = new GuiDisableableButton(3, this.field_147003_i + 11, this.field_147009_r + 64, 11, 11).with(GuiDisableableButton.ImageOverlay.DEFAULT);
        this.field_146292_n.add(this.defaultButton);
        this.checkboxButton = new GuiDisableableButton(4, this.field_147003_i + 130, this.field_147009_r + 47, 11, 11).with(GuiDisableableButton.ImageOverlay.CHECKMARK_DIGITAL);
        this.field_146292_n.add(this.checkboxButton);
        this.colorButton = new GuiColorButton(5, this.field_147003_i + 12, this.field_147009_r + 44, () -> ((TModIDFilter)this.filter).color);
        this.field_146292_n.add(this.colorButton);
    }

    @Override
    protected void sendPacketToServer(int guiID) {
        Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Coord4D.get(this.tileEntity), guiID, 0, 0));
    }
}

