/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import java.io.IOException;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.button.GuiColorButton;
import mekanism.client.gui.button.GuiDisableableButton;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.filter.GuiItemStackFilter;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.content.transporter.TItemStackFilter;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiTItemStackFilter
extends GuiItemStackFilter<TItemStackFilter, TileEntityLogisticalSorter> {
    private GuiTextField minField;
    private GuiTextField maxField;
    private GuiButton sizeButton;

    public GuiTItemStackFilter(EntityPlayer player, TileEntityLogisticalSorter tile, int index) {
        super(player, tile);
        this.origFilter = (TItemStackFilter)((TileEntityLogisticalSorter)this.tileEntity).filters.get(index);
        this.filter = ((TItemStackFilter)((TileEntityLogisticalSorter)this.tileEntity).filters.get(index)).clone();
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, this.getGuiLocation(), 11, 18));
        this.addGuiElement(new GuiInnerScreen(this, this.getGuiLocation(), 33, 18, 93, 43));
        this.addGuiElement(new GuiPlayerSlot(this, this.getGuiLocation()));
    }

    public GuiTItemStackFilter(EntityPlayer player, TileEntityLogisticalSorter tile) {
        super(player, tile);
        this.isNew = true;
        this.filter = new TItemStackFilter();
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, this.getGuiLocation(), 11, 18));
        this.addGuiElement(new GuiInnerScreen(this, this.getGuiLocation(), 33, 18, 93, 43));
        this.addGuiElement(new GuiPlayerSlot(this, this.getGuiLocation()));
    }

    @Override
    protected void addButtons() {
        this.saveButton = new GuiDisableableButton(0, this.field_147003_i + 47, this.field_147009_r + 62, 60, 20, LangUtils.localize("gui.save"));
        this.field_146292_n.add(this.saveButton);
        this.deleteButton = new GuiDisableableButton(1, this.field_147003_i + 109, this.field_147009_r + 62, 60, 20, LangUtils.localize("gui.delete"));
        this.field_146292_n.add(this.deleteButton);
        this.backButton = new GuiDisableableButton(2, this.field_147003_i + 5, this.field_147009_r + 5, 11, 11).with(GuiDisableableButton.ImageOverlay.SMALL_BACK);
        this.field_146292_n.add(this.backButton);
        this.defaultButton = new GuiDisableableButton(3, this.field_147003_i + 11, this.field_147009_r + 64, 11, 11).with(GuiDisableableButton.ImageOverlay.DEFAULT);
        this.field_146292_n.add(this.defaultButton);
        this.colorButton = new GuiColorButton(4, this.field_147003_i + 12, this.field_147009_r + 44, () -> ((TItemStackFilter)this.filter).color);
        this.field_146292_n.add(this.colorButton);
        this.sizeButton = new GuiDisableableButton(5, this.field_147003_i + 128, this.field_147009_r + 44, 11, 11).with(GuiDisableableButton.ImageOverlay.SILK_TOUCH);
        this.field_146292_n.add(this.sizeButton);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.minField = new GuiTextField(2, this.field_146289_q, this.field_147003_i + 149, this.field_147009_r + 19, 20, 11);
        this.minField.func_146203_f(2);
        this.minField.func_146180_a("" + ((TItemStackFilter)this.filter).min);
        this.maxField = new GuiTextField(3, this.field_146289_q, this.field_147003_i + 149, this.field_147009_r + 31, 20, 11);
        this.maxField.func_146203_f(2);
        this.maxField.func_146180_a("" + ((TItemStackFilter)this.filter).max);
    }

    @Override
    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.saveButton.field_146127_k) {
            if (!(((TItemStackFilter)this.filter).getItemStack().func_190926_b() || this.minField.func_146179_b().isEmpty() || this.maxField.func_146179_b().isEmpty())) {
                int min = Integer.parseInt(this.minField.func_146179_b());
                int max = Integer.parseInt(this.maxField.func_146179_b());
                if (max >= min && max <= 64) {
                    ((TItemStackFilter)this.filter).min = Integer.parseInt(this.minField.func_146179_b());
                    ((TItemStackFilter)this.filter).max = Integer.parseInt(this.maxField.func_146179_b());
                    if (this.isNew) {
                        Mekanism.packetHandler.sendToServer(new PacketNewFilter.NewFilterMessage(Coord4D.get(this.tileEntity), this.filter));
                    } else {
                        Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), false, this.origFilter, this.filter));
                    }
                    this.sendPacketToServer(0);
                } else if (min > max) {
                    this.status = (Object)((Object)EnumColor.DARK_RED) + "Max<min";
                    this.ticker = 20;
                } else {
                    this.status = (Object)((Object)EnumColor.DARK_RED) + "Max>64";
                    this.ticker = 20;
                }
            } else if (((TItemStackFilter)this.filter).getItemStack().func_190926_b()) {
                this.status = (Object)((Object)EnumColor.DARK_RED) + "No item";
                this.ticker = 20;
            } else if (this.minField.func_146179_b().isEmpty() || this.maxField.func_146179_b().isEmpty()) {
                this.status = (Object)((Object)EnumColor.DARK_RED) + "Max/min";
                this.ticker = 20;
            }
        } else if (guibutton.field_146127_k == this.sizeButton.field_146127_k) {
            ((TItemStackFilter)this.filter).sizeMode = !((TItemStackFilter)this.filter).sizeMode;
        } else {
            this.actionPerformedTransporter(guibutton, (TransporterFilter)this.filter);
        }
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.minField.func_146206_l() && !this.maxField.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (Character.isDigit(c) || GuiTItemStackFilter.isTextboxKey(c, i)) {
            this.minField.func_146201_a(c, i);
            this.maxField.func_146201_a(c, i);
        }
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.itemFilter.min") + ":", 128, 20, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.itemFilter.max") + ":", 128, 32, 0x404040);
        String sizeModeString = LangUtils.transOnOff(((TItemStackFilter)this.filter).sizeMode);
        if (((TileEntityLogisticalSorter)this.tileEntity).singleItem && ((TItemStackFilter)this.filter).sizeMode) {
            sizeModeString = (Object)((Object)EnumColor.RED) + sizeModeString + "!";
        }
        this.field_146289_q.func_78276_b(sizeModeString, 141, 46, 0x404040);
        this.drawTransporterForegroundLayer(mouseX, mouseY, ((TItemStackFilter)this.filter).getItemStack());
        if (!((TItemStackFilter)this.filter).getItemStack().func_190926_b()) {
            this.renderScaledText(((TItemStackFilter)this.filter).getItemStack().func_82833_r(), 35, 41, 52480, 89);
        }
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (this.sizeButton.func_146115_a()) {
            String sizeModeTooltip = LangUtils.localize("gui.sizeMode");
            if (((TileEntityLogisticalSorter)this.tileEntity).singleItem && ((TItemStackFilter)this.filter).sizeMode) {
                sizeModeTooltip = sizeModeTooltip + " - " + LangUtils.localize("mekanism.gui.sizeModeConflict");
            }
            this.displayTooltips(MekanismUtils.splitTooltip(sizeModeTooltip, ItemStack.field_190927_a), xAxis, yAxis);
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.minField.func_146178_a();
        this.maxField.func_146178_a();
    }

    @Override
    protected void drawItemStackBackground(int xAxis, int yAxis) {
        this.minField.func_146194_f();
        this.maxField.func_146194_f();
    }

    @Override
    protected void sendPacketToServer(int guiID) {
        Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, Coord4D.get(this.tileEntity), guiID, 0, 0));
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.minField.func_146192_a(mouseX, mouseY, button);
        this.maxField.func_146192_a(mouseX, mouseY, button);
        if (button == 0 && this.overTypeInput(mouseX - this.field_147003_i, mouseY - this.field_147009_r)) {
            ItemStack stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
            if (!stack.func_190926_b() && !Keyboard.isKeyDown((int)42)) {
                ((TItemStackFilter)this.filter).setItemStack(stack.func_77946_l());
                ((TItemStackFilter)this.filter).getItemStack().func_190920_e(1);
            } else if (stack.func_190926_b() && Keyboard.isKeyDown((int)42)) {
                ((TItemStackFilter)this.filter).setItemStack(ItemStack.field_190927_a);
            }
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        } else {
            this.transporterMouseClicked(button, (TransporterFilter)this.filter);
        }
    }
}

