/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.filter;

import java.io.IOException;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.gui.button.GuiDisableableButton;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.filter.GuiItemStackFilter;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.content.miner.MItemStackFilter;
import mekanism.common.content.miner.MinerFilter;
import mekanism.common.network.PacketDigitalMinerGui;
import mekanism.common.network.PacketEditFilter;
import mekanism.common.network.PacketNewFilter;
import mekanism.common.tile.machine.TileEntityDigitalMiner;
import mekanism.common.util.LangUtils;
import net.minecraft.block.Block;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiMItemStackFilter
extends GuiItemStackFilter<MItemStackFilter, TileEntityDigitalMiner> {
    private GuiDisableableButton fuzzyButton;

    public GuiMItemStackFilter(EntityPlayer player, TileEntityDigitalMiner tile, int index) {
        super(player, tile);
        this.origFilter = (MItemStackFilter)((TileEntityDigitalMiner)this.tileEntity).filters.get(index);
        this.filter = ((MItemStackFilter)((TileEntityDigitalMiner)this.tileEntity).filters.get(index)).clone();
        this.addGuiElement(new GuiInnerScreen(this, this.getGuiLocation(), 34, 19, 109, 41));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, this.getGuiLocation(), 11, 18));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, this.getGuiLocation(), 148, 18));
        this.addGuiElement(new GuiPlayerSlot(this, this.getGuiLocation()));
    }

    public GuiMItemStackFilter(EntityPlayer player, TileEntityDigitalMiner tile) {
        super(player, tile);
        this.isNew = true;
        this.filter = new MItemStackFilter();
        this.addGuiElement(new GuiInnerScreen(this, this.getGuiLocation(), 34, 19, 109, 41));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, this.getGuiLocation(), 11, 18));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, this.getGuiLocation(), 148, 18));
        this.addGuiElement(new GuiPlayerSlot(this, this.getGuiLocation()));
    }

    @Override
    protected void addButtons() {
        this.saveButton = new GuiDisableableButton(0, this.field_147003_i + 27, this.field_147009_r + 62, 60, 20, LangUtils.localize("gui.save"));
        this.field_146292_n.add(this.saveButton);
        this.deleteButton = new GuiDisableableButton(1, this.field_147003_i + 89, this.field_147009_r + 62, 60, 20, LangUtils.localize("gui.delete"));
        this.field_146292_n.add(this.deleteButton);
        this.backButton = new GuiDisableableButton(2, this.field_147003_i + 5, this.field_147009_r + 5, 11, 11).with(GuiDisableableButton.ImageOverlay.SMALL_BACK);
        this.field_146292_n.add(this.backButton);
        this.replaceButton = new GuiDisableableButton(3, this.field_147003_i + 148, this.field_147009_r + 45, 14, 14).with(GuiDisableableButton.ImageOverlay.EXCLAMATION);
        this.field_146292_n.add(this.replaceButton);
        this.fuzzyButton = new GuiDisableableButton(4, this.field_147003_i + 15, this.field_147009_r + 45, 14, 14).with(GuiDisableableButton.ImageOverlay.FUZZY);
        this.field_146292_n.add(this.fuzzyButton);
    }

    @Override
    protected void sendPacketToServer(int guiID) {
        Mekanism.packetHandler.sendToServer(new PacketDigitalMinerGui.DigitalMinerGuiMessage(PacketDigitalMinerGui.MinerGuiPacket.SERVER, Coord4D.get(this.tileEntity), guiID, 0, 0));
    }

    @Override
    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.saveButton.field_146127_k) {
            if (!((MItemStackFilter)this.filter).getItemStack().func_190926_b()) {
                if (this.isNew) {
                    Mekanism.packetHandler.sendToServer(new PacketNewFilter.NewFilterMessage(Coord4D.get(this.tileEntity), this.filter));
                } else {
                    Mekanism.packetHandler.sendToServer(new PacketEditFilter.EditFilterMessage(Coord4D.get(this.tileEntity), false, this.origFilter, this.filter));
                }
                this.sendPacketToServer(0);
            } else {
                this.status = (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.itemFilter.noItem");
                this.ticker = 20;
            }
        } else if (guibutton.field_146127_k == this.fuzzyButton.field_146127_k) {
            ((MItemStackFilter)this.filter).fuzzy = !((MItemStackFilter)this.filter).fuzzy;
        } else {
            this.actionPerformedMinerCommon(guibutton, (MinerFilter)this.filter);
        }
    }

    @Override
    protected void drawForegroundLayer(int mouseX, int mouseY) {
        if (!((MItemStackFilter)this.filter).getItemStack().func_190926_b()) {
            this.renderScaledText(((MItemStackFilter)this.filter).getItemStack().func_82833_r(), 35, 41, 52480, 107);
        }
        this.renderItem(((MItemStackFilter)this.filter).getItemStack(), 12, 19);
        this.renderItem(((MItemStackFilter)this.filter).replaceStack, 149, 19);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (this.replaceButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.digitalMiner.requireReplace") + ": " + LangUtils.transYesNo(((MItemStackFilter)this.filter).requireStack), xAxis, yAxis);
        } else if (this.fuzzyButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.digitalMiner.fuzzyMode") + ": " + LangUtils.transYesNo(((MItemStackFilter)this.filter).fuzzy), xAxis, yAxis);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        if (button == 0) {
            int xAxis = mouseX - this.field_147003_i;
            int yAxis = mouseY - this.field_147009_r;
            if (this.overTypeInput(xAxis, yAxis)) {
                ItemStack stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
                if (!stack.func_190926_b() && !Keyboard.isKeyDown((int)42)) {
                    if (stack.func_77973_b() instanceof ItemBlock && Block.func_149634_a((Item)stack.func_77973_b()) != Blocks.field_150357_h) {
                        ((MItemStackFilter)this.filter).setItemStack(stack.func_77946_l());
                        ((MItemStackFilter)this.filter).getItemStack().func_190920_e(1);
                    }
                } else if (stack.func_190926_b() && Keyboard.isKeyDown((int)42)) {
                    ((MItemStackFilter)this.filter).setItemStack(ItemStack.field_190927_a);
                }
                SoundHandler.playSound(SoundEvents.field_187909_gi);
            } else {
                this.minerFilterClickCommon(xAxis, yAxis, (MinerFilter)this.filter);
            }
        }
    }
}

