/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSideHolder
extends GuiElement {
    protected final boolean left;
    private final int xPosition;
    private final int yPosition;
    private final int xSize;
    private final int ySize;

    public GuiSideHolder(IGuiWrapper gui, ResourceLocation def, int x, int y, int sizeX, int sizeY) {
        this(gui, def, x, y, sizeX, sizeY, false);
    }

    public GuiSideHolder(IGuiWrapper gui, ResourceLocation def, int x, int y, int sizeX, int sizeY, boolean left) {
        super(left ? MekanismUtils.getResource(MekanismUtils.ResourceType.BUTTON_TAB, "holder_left.png") : MekanismUtils.getResource(MekanismUtils.ResourceType.BUTTON_TAB, "holder_right.png"), gui, def);
        this.left = left;
        this.xPosition = x;
        this.yPosition = y;
        this.xSize = sizeX;
        this.ySize = sizeY;
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth + this.xPosition, guiHeight + this.yPosition, this.xSize, this.ySize);
    }

    @Override
    protected boolean inBounds(int xAxis, int yAxis) {
        return xAxis >= this.xPosition && xAxis <= this.xPosition + this.xSize && yAxis >= this.yPosition && yAxis <= this.yPosition + this.ySize;
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiSideHolder.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.drawBlack(guiWidth, guiHeight);
        GuiSideHolder.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
    }

    public void drawBlack(int guiWidth, int guiHeight) {
        int halfWidthLeft = this.xSize / 2;
        int halfWidthRight = this.xSize % 2 == 0 ? halfWidthLeft : halfWidthLeft + 1;
        int halfHeightTop = this.ySize / 2;
        int halfHeight = this.ySize % 2 == 0 ? halfHeightTop : halfHeightTop + 1;
        this.guiObj.drawTexturedRect(guiWidth + this.xPosition, guiHeight + this.yPosition, 0, 0, halfWidthLeft, halfHeightTop);
        this.guiObj.drawTexturedRect(guiWidth + this.xPosition, guiHeight + this.yPosition + halfHeightTop, 0, 256 - halfHeight, halfWidthLeft, halfHeight);
        this.guiObj.drawTexturedRect(guiWidth + this.xPosition + halfWidthLeft, guiHeight + this.yPosition, 256 - halfWidthRight, 0, halfWidthRight, halfHeightTop);
        this.guiObj.drawTexturedRect(guiWidth + this.xPosition + halfWidthLeft, guiHeight + this.yPosition + halfHeightTop, 256 - halfWidthRight, 256 - halfHeight, halfWidthRight, halfHeight);
        MekanismRenderer.resetColor();
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
    }
}

