/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import java.util.Arrays;
import java.util.UUID;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.client.MekanismClient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTileEntityElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.network.PacketSecurityMode;
import mekanism.common.security.ISecurityItem;
import mekanism.common.security.ISecurityTile;
import mekanism.common.security.SecurityData;
import mekanism.common.security.SecurityFrequency;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.SecurityUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSecurityTab
extends GuiTileEntityElement<TileEntity> {
    private final int xLocation;
    private final int yLocation;
    private final EnumHand currentHand;
    private boolean isItem;

    public GuiSecurityTab(IGuiWrapper gui, TileEntity tile, ResourceLocation def, int x, int y) {
        super(gui, def, tile, 176 + x, 32 + y, 26, 26, 179 + x, 36 + y, 18, 18);
        this.currentHand = EnumHand.MAIN_HAND;
        this.xLocation = x;
        this.yLocation = y;
    }

    public GuiSecurityTab(IGuiWrapper gui, TileEntity tile, ResourceLocation def) {
        super(gui, def, tile, 176, 32, 26, 26, 179, 36, 18, 18);
        this.currentHand = EnumHand.MAIN_HAND;
        this.xLocation = 0;
        this.yLocation = 0;
    }

    public GuiSecurityTab(IGuiWrapper gui, TileEntity tile, ResourceLocation def, int y) {
        super(gui, def, tile, 176, 32 + y, 26, 26, 179, 36 + y, 18, 18);
        this.currentHand = EnumHand.MAIN_HAND;
        this.xLocation = 0;
        this.yLocation = y;
    }

    public GuiSecurityTab(IGuiWrapper gui, ResourceLocation def, EnumHand hand) {
        super(gui, def, null, 176, 32, 26, 26, 179, 36, 18, 18);
        this.isItem = true;
        this.currentHand = hand;
        this.xLocation = 0;
        this.yLocation = 0;
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        MekanismRenderer.color(-24224);
        super.renderBackground(xAxis, yAxis, guiWidth, guiHeight);
        MekanismRenderer.resetColor();
        GuiSecurityTab.mc.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.BUTTON_TAB, "Button_Tab_Icon.png"));
        ISecurityTile.SecurityMode mode = this.getSecurity();
        SecurityData data = MekanismClient.clientSecurityMap.get(this.getOwner());
        if (data != null && data.override) {
            mode = data.mode;
        }
        int renderX = 18 * mode.ordinal();
        if (this.getOwner() != null && this.getOwner().equals(GuiSecurityTab.mc.field_71439_g.func_110124_au()) && (data == null || !data.override)) {
            this.guiObj.drawTexturedRect(guiWidth + 179 + this.xLocation, guiHeight + 36 + this.yLocation, renderX, 18, 18, 18);
        } else {
            this.setNull(true);
        }
        GuiSecurityTab.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        GuiSecurityTab.mc.field_71446_o.func_110577_a(this.RESOURCE);
        if (this.inBounds(xAxis, yAxis)) {
            String securityDisplay = this.isItem ? SecurityUtils.getSecurityDisplay(this.getItem(), Side.CLIENT) : SecurityUtils.getSecurityDisplay(this.tileEntity, Side.CLIENT);
            String securityText = (Object)((Object)EnumColor.GREY) + LangUtils.localize("gui.security") + ": " + securityDisplay;
            String ownerText = SecurityUtils.getOwnerDisplay((EntityPlayer)GuiSecurityTab.mc.field_71439_g, this.getOwnerUsername());
            String overrideText = (Object)((Object)EnumColor.RED) + "(" + LangUtils.localize("gui.overridden") + ")";
            if (this.isItem ? SecurityUtils.isOverridden(this.getItem(), Side.CLIENT) : SecurityUtils.isOverridden(this.tileEntity, Side.CLIENT)) {
                this.displayTooltips(Arrays.asList(securityText, ownerText, overrideText), xAxis, yAxis);
            } else {
                this.displayTooltips(Arrays.asList(securityText, ownerText), xAxis, yAxis);
            }
        }
        GuiSecurityTab.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    private SecurityFrequency getFrequency() {
        if (this.isItem) {
            if (this.getItem().func_190926_b() || !(this.getItem().func_77973_b() instanceof ISecurityItem)) {
                GuiSecurityTab.mc.field_71439_g.func_71053_j();
                return null;
            }
            return SecurityUtils.getFrequency(this.getOwner());
        }
        return ((ISecurityTile)this.tileEntity).getSecurity().getFrequency();
    }

    private ISecurityTile.SecurityMode getSecurity() {
        if (!MekanismConfig.current().general.allowProtection.val()) {
            return ISecurityTile.SecurityMode.PUBLIC;
        }
        if (this.isItem) {
            if (this.getItem().func_190926_b() || !(this.getItem().func_77973_b() instanceof ISecurityItem)) {
                GuiSecurityTab.mc.field_71439_g.func_71053_j();
                return ISecurityTile.SecurityMode.PUBLIC;
            }
            return ((ISecurityItem)this.getItem().func_77973_b()).getSecurity(this.getItem());
        }
        return ((ISecurityTile)this.tileEntity).getSecurity().getMode();
    }

    private UUID getOwner() {
        if (this.isItem) {
            if (this.getItem().func_190926_b() || !(this.getItem().func_77973_b() instanceof ISecurityItem)) {
                GuiSecurityTab.mc.field_71439_g.func_71053_j();
                return null;
            }
            return ((ISecurityItem)this.getItem().func_77973_b()).getOwnerUUID(this.getItem());
        }
        return ((ISecurityTile)this.tileEntity).getSecurity().getOwnerUUID();
    }

    private String getOwnerUsername() {
        if (this.isItem) {
            if (this.getItem().func_190926_b() || !(this.getItem().func_77973_b() instanceof ISecurityItem)) {
                GuiSecurityTab.mc.field_71439_g.func_71053_j();
                return null;
            }
            return MekanismClient.clientUUIDMap.get(((ISecurityItem)this.getItem().func_77973_b()).getOwnerUUID(this.getItem()));
        }
        return ((ISecurityTile)this.tileEntity).getSecurity().getClientOwner();
    }

    private ItemStack getItem() {
        return GuiSecurityTab.mc.field_71439_g.func_184586_b(this.currentHand);
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
        if (button == 0 && MekanismConfig.current().general.allowProtection.val() && this.getOwner() != null && GuiSecurityTab.mc.field_71439_g.func_110124_au().equals(this.getOwner()) && this.inBounds(xAxis, yAxis)) {
            ISecurityTile.SecurityMode current = this.getSecurity();
            int ordinalToSet = current.ordinal() < ISecurityTile.SecurityMode.values().length - 1 ? current.ordinal() + 1 : 0;
            SoundHandler.playSound(SoundEvents.field_187909_gi);
            if (this.isItem) {
                Mekanism.packetHandler.sendToServer(new PacketSecurityMode.SecurityModeMessage(this.currentHand, ISecurityTile.SecurityMode.values()[ordinalToSet]));
            } else {
                Mekanism.packetHandler.sendToServer(new PacketSecurityMode.SecurityModeMessage(Coord4D.get(this.tileEntity), ISecurityTile.SecurityMode.values()[ordinalToSet]));
            }
        }
    }
}

