/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import mekanism.api.Coord4D;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.tab.GuiTabElementType;
import mekanism.client.gui.element.tab.TabType;
import mekanism.common.Mekanism;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.tile.multiblock.TileEntityInductionCasing;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiMatrixTab
extends GuiTabElementType<TileEntityInductionCasing, MatrixTab> {
    private MatrixTab tab;

    public GuiMatrixTab(IGuiWrapper gui, TileEntityInductionCasing tile, MatrixTab type, ResourceLocation def) {
        super(gui, tile, type, def);
        this.tab = type;
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        super.renderBackground(xAxis, yAxis, guiWidth, guiHeight);
        GuiMatrixTab.mc.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.BUTTON_TAB, "button_tab_icon.png"));
        this.guiObj.drawTexturedRect(guiWidth - 21, guiHeight + this.tab.getYPos() + 4, this.tab.xlocation, this.tab.ylocation, 18, 18);
    }

    public static enum MatrixTab implements TabType
    {
        MAIN(126, 0, 49, "gui.main"),
        STAT(198, 18, 50, "gui.matrixStats");

        private final String description;
        public final int xlocation;
        public final int ylocation;
        private final int guiId;

        private MatrixTab(int x, int y, int id, String desc) {
            this.xlocation = x;
            this.ylocation = y;
            this.guiId = id;
            this.description = desc;
        }

        @Override
        public ResourceLocation getResource() {
            return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Null.png");
        }

        @Override
        public void openGui(TileEntity tile) {
            Mekanism.packetHandler.sendToServer(new PacketSimpleGui.SimpleGuiMessage(Coord4D.get(tile), 0, this.guiId));
        }

        @Override
        public String getDesc() {
            return LangUtils.localize(this.description);
        }

        @Override
        public int getYPos() {
            return 6;
        }
    }
}

