/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab;

import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.GuiSideConfiguration;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.util.MekanismUtils;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiConfigTypeTab
extends GuiElement {
    private final TransmissionType transmission;
    private boolean visible;
    private boolean left;
    private int yPos;
    private final int ButtonsizeX;
    private final int ButtonsizeY;
    private final int xSize;
    private final int ySize;

    public GuiConfigTypeTab(IGuiWrapper gui, TransmissionType type, ResourceLocation def) {
        super(GuiConfigTypeTab.getResource(), gui, def);
        this.transmission = type;
        this.ButtonsizeX = 18;
        this.ButtonsizeY = 18;
        this.xSize = 26;
        this.ySize = 26;
    }

    private static ResourceLocation getResource() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Null.png");
    }

    public void setY(int y) {
        this.yPos = y;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setLeft(boolean left) {
        this.left = left;
    }

    public TransmissionType getTransmissionType() {
        return this.transmission;
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth + this.getLeftBound(false) - 4, guiHeight + this.yPos, 26, 26);
    }

    @Override
    protected boolean inBounds(int xAxis, int yAxis) {
        return xAxis >= this.getLeftBound(true) && xAxis <= this.getRightBound(true) && yAxis >= this.yPos + 4 && yAxis <= this.yPos + 22;
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        if (this.visible) {
            MekanismRenderer.color(this.getTransmissionType().getColor());
            this.drawBlack(guiWidth, guiHeight);
            MekanismRenderer.resetColor();
            this.drawButton(xAxis, yAxis, guiWidth, guiHeight);
            GuiConfigTypeTab.mc.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.BUTTON_TAB, "button_tab_icon.png"));
            this.guiObj.drawTexturedRect(guiWidth + this.getLeftBound(true), guiHeight + this.yPos + 4, this.getTransmissionType().getButtonx(), this.getTransmissionType().getButtony(), 18, 18);
            GuiConfigTypeTab.mc.field_71446_o.func_110577_a(this.defaultLocation);
        }
    }

    public void drawButton(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        mc.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.BUTTON, "Button.png"));
        int i = this.getHoverState(this.inBounds(xAxis, yAxis));
        int position = i * 20;
        int halfWidthLeft = this.ButtonsizeX / 2;
        int halfWidthRight = this.ButtonsizeX % 2 == 0 ? halfWidthLeft : halfWidthLeft + 1;
        int halfHeightTop = this.ButtonsizeY / 2;
        int halfHeightBottom = this.ButtonsizeY % 2 == 0 ? halfHeightTop : halfHeightTop + 1;
        this.guiObj.drawTexturedRect(guiWidth + this.getLeftBound(true), guiHeight + this.yPos + 4, 0, position, halfWidthLeft, halfHeightTop);
        this.guiObj.drawTexturedRect(guiWidth + this.getLeftBound(true), guiHeight + this.yPos + 4 + halfHeightTop, 0, position + 20 - halfHeightBottom, halfWidthLeft, halfHeightBottom);
        this.guiObj.drawTexturedRect(guiWidth + this.getLeftBound(true) + halfWidthLeft, guiHeight + this.yPos + 4, 200 - halfWidthRight, position, halfWidthRight, halfHeightTop);
        this.guiObj.drawTexturedRect(guiWidth + this.getLeftBound(true) + halfWidthLeft, guiHeight + this.yPos + 4 + halfHeightTop, 200 - halfWidthRight, position + 20 - halfHeightBottom, halfWidthRight, halfHeightBottom);
    }

    public void drawBlack(int guiWidth, int guiHeight) {
        mc.func_110434_K().func_110577_a(this.left ? MekanismUtils.getResource(MekanismUtils.ResourceType.BUTTON_TAB, "holder_left.png") : MekanismUtils.getResource(MekanismUtils.ResourceType.BUTTON_TAB, "holder_right.png"));
        int halfWidthLeft = this.xSize / 2;
        int halfWidthRight = this.xSize % 2 == 0 ? halfWidthLeft : halfWidthLeft + 1;
        int halfHeightTop = this.ySize / 2;
        int halfHeight = this.ySize % 2 == 0 ? halfHeightTop : halfHeightTop + 1;
        this.guiObj.drawTexturedRect(guiWidth + this.getLeftBound(false) - 4, guiHeight + this.yPos, 0, 0, halfWidthLeft, halfHeightTop);
        this.guiObj.drawTexturedRect(guiWidth + this.getLeftBound(false) - 4, guiHeight + this.yPos + halfHeightTop, 0, 256 - halfHeight, halfWidthLeft, halfHeight);
        this.guiObj.drawTexturedRect(guiWidth + this.getLeftBound(false) - 4 + halfWidthLeft, guiHeight + this.yPos, 256 - halfWidthRight, 0, halfWidthRight, halfHeightTop);
        this.guiObj.drawTexturedRect(guiWidth + this.getLeftBound(false) - 4 + halfWidthLeft, guiHeight + this.yPos + halfHeightTop, 256 - halfWidthRight, 256 - halfHeight, halfWidthRight, halfHeight);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        if (this.visible) {
            GuiConfigTypeTab.mc.field_71446_o.func_110577_a(this.RESOURCE);
            if (this.inBounds(xAxis, yAxis)) {
                this.displayTooltip(this.transmission.localize(), xAxis, yAxis);
            }
            GuiConfigTypeTab.mc.field_71446_o.func_110577_a(this.defaultLocation);
        }
    }

    public int getLeftBound(boolean adjust) {
        return this.left ? -21 + (adjust ? 1 : 0) : 159 - (adjust ? 1 : 0);
    }

    public int getRightBound(boolean adjust) {
        return this.left ? -3 + (adjust ? 1 : 0) : 177 - (adjust ? 1 : 0);
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
        if (this.visible && button == 0 && this.inBounds(xAxis, yAxis)) {
            ((GuiSideConfiguration)this.guiObj).setCurrentType(this.transmission);
            ((GuiSideConfiguration)this.guiObj).updateTabs();
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        }
    }

    protected int getHoverState(boolean hoveredOrFocused) {
        if (hoveredOrFocused) {
            return 2;
        }
        return 1;
    }
}

