/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.gauge;

import mekanism.api.EnumColor;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.SideData;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.item.ItemConfigurator;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiGauge<T>
extends GuiElement {
    protected final int xLocation;
    protected final int yLocation;
    protected final int texX;
    protected final int texY;
    protected final int width;
    protected final int height;
    protected final int number;
    protected EnumColor color;
    protected boolean dummy;
    protected T dummyType;
    private TypeColor typecolor = TypeColor.NORMAL;

    public GuiGauge(Type type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GAUGE, "Gauge_Icon.png"), gui, def);
        this.xLocation = x;
        this.yLocation = y;
        this.width = type.width;
        this.height = type.height;
        this.texX = type.texX;
        this.texY = type.texY;
        this.number = type.FluidWidth;
    }

    public abstract int getScaledLevel();

    public abstract TextureAtlasSprite getIcon();

    public abstract String getTooltipText();

    protected void applyRenderColor() {
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        this.drawBlack(guiWidth, guiHeight);
        GuiGauge.mc.field_71446_o.func_110577_a(this.RESOURCE);
        if (!this.dummy) {
            this.renderScale(guiWidth, guiHeight);
        }
        GuiGauge.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    public void drawBlack(int guiWidth, int guiHeight) {
        GuiGauge.mc.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GAUGE, this.typecolor.textureLocation));
        int halfWidthLeft = this.width / 2;
        int halfWidthRight = this.width % 2 == 0 ? halfWidthLeft : halfWidthLeft + 1;
        int halfHeightTop = this.height / 2;
        int halfHeight = this.height % 2 == 0 ? halfHeightTop : halfHeightTop + 1;
        MekanismRenderer.resetColor();
        this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation, 0, 0, halfWidthLeft, halfHeightTop);
        this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation + halfHeightTop, 0, 256 - halfHeight, halfWidthLeft, halfHeight);
        this.guiObj.drawTexturedRect(guiWidth + this.xLocation + halfWidthLeft, guiHeight + this.yLocation, 256 - halfWidthRight, 0, halfWidthRight, halfHeightTop);
        this.guiObj.drawTexturedRect(guiWidth + this.xLocation + halfWidthLeft, guiHeight + this.yLocation + halfHeightTop, 256 - halfWidthRight, 256 - halfHeight, halfWidthRight, halfHeight);
    }

    public void renderScale(int guiWidth, int guiHeight) {
        if (this.getScaledLevel() == 0 || this.getIcon() == null) {
            this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation, this.texX, this.texY, this.width, this.height);
            return;
        }
        int scale = this.getScaledLevel();
        int start = 0;
        this.applyRenderColor();
        while (scale > 0) {
            int renderRemaining;
            if (scale > 16) {
                renderRemaining = 16;
                scale -= 16;
            } else {
                renderRemaining = scale;
                scale = 0;
            }
            GuiGauge.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            for (int i = 0; i < this.number; ++i) {
                this.guiObj.drawTexturedRectFromIcon(guiWidth + this.xLocation + 16 * i + 1, guiHeight + this.yLocation + this.height - renderRemaining - start - 1, this.getIcon(), 16, renderRemaining);
            }
            start += 16;
            if (scale != 0) continue;
            break;
        }
        MekanismRenderer.resetColor();
        GuiGauge.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation, this.texX, this.texY, this.width, this.height);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        if (xAxis >= this.xLocation + 1 && xAxis <= this.xLocation + this.width - 1 && yAxis >= this.yLocation + 1 && yAxis <= this.yLocation + this.height - 1) {
            ItemStack stack = GuiGauge.mc.field_71439_g.field_71071_by.func_70445_o();
            if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemConfigurator && this.color != null) {
                Object tile;
                if (this.guiObj instanceof GuiMekanismTile && (tile = ((GuiMekanismTile)this.guiObj).getTileEntity()) instanceof ISideConfiguration && this.getTransmission() != null) {
                    SideData data = null;
                    for (SideData iterData : ((ISideConfiguration)tile).getConfig().getOutputs(this.getTransmission())) {
                        if (iterData.color != this.color) continue;
                        data = iterData;
                        break;
                    }
                    String localized = data == null ? "" : data.localize();
                    this.guiObj.displayTooltip((Object)((Object)this.color) + localized + " (" + this.color.getColoredName() + ")", xAxis, yAxis);
                }
            } else {
                this.guiObj.displayTooltip(this.getTooltipText(), xAxis, yAxis);
            }
        }
    }

    public GuiGauge withColor(TypeColor color) {
        this.typecolor = color;
        return this;
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
    }

    public abstract TransmissionType getTransmission();

    public void setDummyType(T type) {
        this.dummyType = type;
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth + this.xLocation, guiHeight + this.yLocation, this.width, this.height);
    }

    public static enum TypeColor {
        AQUA("Aqua.png"),
        BLUE("Blue.png"),
        NORMAL("Normal.png"),
        ORANGE("Orange.png"),
        RED("Red.png"),
        YELLOW("Yellow.png");

        public final String textureLocation;

        private TypeColor(String color) {
            this.textureLocation = color;
        }
    }

    public static enum Type {
        MEDIUM(34, 60, 0, 0),
        SMALL(18, 30, 72, 0),
        SMALL_MED(18, 48, 53, 0),
        STANDARD(18, 60, 34, 0),
        WIDE(66, 50, 91, 0);

        public final int width;
        public final int height;
        public final int texX;
        public final int texY;
        public final int FluidWidth;

        private Type(int w, int h, int tx, int ty) {
            this.width = w;
            this.height = h;
            this.texX = tx;
            this.texY = ty;
            this.FluidWidth = (w - 2) / 16;
        }
    }
}

