/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import mekanism.api.gas.GasStack;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.InfuseStorage;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiUtils {
    public static void drawBarSprite(int xPos, int yPos, int sizeX, int sizeY, int displayInt, TextureAtlasSprite textureSprite, boolean vertical) {
        if (displayInt > 0 && textureSprite != null) {
            GuiElement.mc.field_71446_o.func_110577_a(TextureMap.field_110575_b);
            if (vertical) {
                GuiUtils.drawTiledSprite(xPos + 1, yPos + 1, sizeY - 2, sizeX - 2, displayInt, textureSprite, TilingDirection.DOWN_RIGHT);
            } else {
                GuiUtils.drawTiledSprite(xPos + 1, yPos + 1, sizeY - 2, displayInt, sizeY - 2, textureSprite, TilingDirection.DOWN_RIGHT);
            }
            MekanismRenderer.resetColor();
        }
    }

    public static void drawGasBarSprite(int xPos, int yPos, int sizeX, int sizeY, int displayInt, GasStack gasStack, boolean vertical) {
        if (displayInt > 0 && gasStack != null) {
            MekanismRenderer.color(gasStack);
            GuiUtils.drawBarSprite(xPos, yPos, sizeX, sizeY, displayInt, gasStack.getGas().getSprite(), vertical);
        }
    }

    public static void drawFluidBarSprite(int xPos, int yPos, int sizeX, int sizeY, int displayInt, FluidStack fluidStack, boolean vertical) {
        if (displayInt > 0 && fluidStack != null) {
            MekanismRenderer.color(fluidStack);
            GuiUtils.drawBarSprite(xPos, yPos, sizeX, sizeY, displayInt, MekanismRenderer.getFluidTexture(fluidStack, MekanismRenderer.FluidType.STILL), vertical);
        }
    }

    public static void drawInfuseBarSprite(int xPos, int yPos, int sizeX, int sizeY, int displayInt, InfuseStorage infuseStorage, boolean vertical) {
        if (displayInt > 0 && infuseStorage.getType() != null) {
            GuiUtils.drawBarSprite(xPos, yPos, sizeX, sizeY, displayInt, infuseStorage.getType().sprite, vertical);
        }
    }

    public static void drawTiledSprite(int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, TilingDirection tilingDirection) {
        GuiUtils.drawTiledSprite(xPosition, yPosition, yOffset, desiredWidth, desiredHeight, sprite, 16, 16, 0, tilingDirection);
    }

    public static void drawTiledSprite(int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int zLevel, TilingDirection tilingDirection) {
        GuiUtils.drawTiledSprite(xPosition, yPosition, yOffset, desiredWidth, desiredHeight, sprite, textureWidth, textureHeight, zLevel, tilingDirection, true);
    }

    public static void drawTiledSprite(int xPosition, int yPosition, int yOffset, int desiredWidth, int desiredHeight, TextureAtlasSprite sprite, int textureWidth, int textureHeight, int zLevel, TilingDirection tilingDirection, boolean blend) {
        if (desiredWidth == 0 || desiredHeight == 0 || textureWidth == 0 || textureHeight == 0) {
            return;
        }
        int xTileCount = desiredWidth / textureWidth;
        int xRemainder = desiredWidth - xTileCount * textureWidth;
        int yTileCount = desiredHeight / textureHeight;
        int yRemainder = desiredHeight - yTileCount * textureHeight;
        int yStart = yPosition + yOffset;
        float uMin = sprite.func_94209_e();
        float uMax = sprite.func_94212_f();
        float vMin = sprite.func_94206_g();
        float vMax = sprite.func_94210_h();
        float uDif = uMax - uMin;
        float vDif = vMax - vMin;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        block0: for (int xTile = 0; xTile <= xTileCount; ++xTile) {
            float uLocalMax;
            float uLocalMin;
            int width;
            int n = width = xTile == xTileCount ? xRemainder : textureWidth;
            if (width == 0) break;
            int x = xPosition + xTile * textureWidth;
            int maskRight = textureWidth - width;
            int shiftedX = x + textureWidth - maskRight;
            float uLocalDif = uDif * (float)maskRight / (float)textureWidth;
            if (tilingDirection.right) {
                uLocalMin = uMin;
                uLocalMax = uMax - uLocalDif;
            } else {
                uLocalMin = uMin + uLocalDif;
                uLocalMax = uMax;
            }
            for (int yTile = 0; yTile <= yTileCount; ++yTile) {
                float vLocalMax;
                float vLocalMin;
                int height;
                int n2 = height = yTile == yTileCount ? yRemainder : textureHeight;
                if (height == 0) continue block0;
                int y = yStart - (yTile + 1) * textureHeight;
                int maskTop = textureHeight - height;
                float vLocalDif = vDif * (float)maskTop / (float)textureHeight;
                if (tilingDirection.down) {
                    vLocalMin = vMin;
                    vLocalMax = vMax - vLocalDif;
                } else {
                    vLocalMin = vMin + vLocalDif;
                    vLocalMax = vMax;
                }
                bufferbuilder.func_181662_b((double)x, (double)(y + textureHeight), (double)zLevel).func_187315_a((double)uLocalMin, (double)vLocalMax).func_181675_d();
                bufferbuilder.func_181662_b((double)shiftedX, (double)(y + textureHeight), (double)zLevel).func_187315_a((double)uLocalMax, (double)vLocalMax).func_181675_d();
                bufferbuilder.func_181662_b((double)shiftedX, (double)(y + maskTop), (double)zLevel).func_187315_a((double)uLocalMax, (double)vLocalMin).func_181675_d();
                bufferbuilder.func_181662_b((double)x, (double)(y + maskTop), (double)zLevel).func_187315_a((double)uLocalMin, (double)vLocalMin).func_181675_d();
            }
        }
        tessellator.func_78381_a();
    }

    public static enum TilingDirection {
        DOWN_RIGHT(true, true),
        DOWN_LEFT(true, false),
        UP_RIGHT(false, true),
        UP_LEFT(false, false);

        private final boolean down;
        private final boolean right;

        private TilingDirection(boolean down, boolean right) {
            this.down = down;
            this.right = right;
        }
    }
}

