/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.tab.GuiSideHolder;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiTileEntityElement<TILE extends TileEntity>
extends GuiSideHolder {
    protected final TILE tileEntity;
    private final int ButtonX;
    private final int ButtonY;
    private final int ButtonsizeX;
    private final int ButtonsizeY;
    private boolean IsNull;

    public GuiTileEntityElement(IGuiWrapper gui, ResourceLocation def, TILE tile, int x, int y, int sizeX, int sizeY) {
        super(gui, def, x, y, sizeX, sizeY, x < 0);
        this.tileEntity = tile;
        this.ButtonX = 0;
        this.ButtonY = 0;
        this.ButtonsizeX = 0;
        this.ButtonsizeY = 0;
    }

    public GuiTileEntityElement(IGuiWrapper gui, ResourceLocation def, TILE tile, int x, int y, int sizeX, int sizeY, int ButtonX, int ButtonY, int ButtonsizeX, int ButtonsizeY) {
        super(gui, def, x, y, sizeX, sizeY, x < 0);
        this.tileEntity = tile;
        this.ButtonX = ButtonX;
        this.ButtonY = ButtonY;
        this.ButtonsizeX = ButtonsizeX;
        this.ButtonsizeY = ButtonsizeY;
    }

    @Override
    protected boolean inBounds(int xAxis, int yAxis) {
        return xAxis >= this.ButtonX && xAxis <= this.ButtonX + this.ButtonsizeX && yAxis >= this.ButtonY && yAxis <= this.ButtonY + this.ButtonsizeY;
    }

    protected int getHoverState(boolean hoveredOrFocused) {
        if (this.IsNull) {
            return 0;
        }
        if (hoveredOrFocused) {
            return 2;
        }
        return 1;
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        super.renderBackground(xAxis, yAxis, guiWidth, guiHeight);
        int i = this.getHoverState(this.inBounds(xAxis, yAxis));
        int position = i * 20;
        if (this.ButtonsizeX > 0 && this.ButtonsizeY > 0) {
            MekanismRenderer.resetColor();
            int halfWidthLeft = this.ButtonsizeX / 2;
            int halfWidthRight = this.ButtonsizeX % 2 == 0 ? halfWidthLeft : halfWidthLeft + 1;
            int halfHeightTop = this.ButtonsizeY / 2;
            int halfHeightBottom = this.ButtonsizeY % 2 == 0 ? halfHeightTop : halfHeightTop + 1;
            mc.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.BUTTON, "Button.png"));
            this.guiObj.drawTexturedRect(guiWidth + this.ButtonX, guiHeight + this.ButtonY, 0, position, halfWidthLeft, halfHeightTop);
            this.guiObj.drawTexturedRect(guiWidth + this.ButtonX, guiHeight + this.ButtonY + halfHeightTop, 0, position + 20 - halfHeightBottom, halfWidthLeft, halfHeightBottom);
            this.guiObj.drawTexturedRect(guiWidth + this.ButtonX + halfWidthLeft, guiHeight + this.ButtonY, 200 - halfWidthRight, position, halfWidthRight, halfHeightTop);
            this.guiObj.drawTexturedRect(guiWidth + this.ButtonX + halfWidthLeft, guiHeight + this.ButtonY + halfHeightTop, 200 - halfWidthRight, position + 20 - halfHeightBottom, halfWidthRight, halfHeightBottom);
        }
    }

    public void setNull(boolean isNull) {
        this.IsNull = isNull;
    }
}

