/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import mekanism.api.Coord4D;
import mekanism.api.util.time.Timeticks;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiTileEntityElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.base.IRedstoneControl;
import mekanism.common.network.PacketRedstoneControl;
import mekanism.common.util.MekanismUtils;
import net.minecraft.init.SoundEvents;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiRedstoneControl
extends GuiTileEntityElement<TileEntity> {
    private final int xLocation;
    private final int yLocation;
    protected Timeticks time = new Timeticks(20, 20, false);

    public GuiRedstoneControl(IGuiWrapper gui, TileEntity tile, ResourceLocation def, int x, int y) {
        super(gui, def, tile, 176 + x, 138 + y, 26, 26);
        this.xLocation = x;
        this.yLocation = y;
    }

    public GuiRedstoneControl(IGuiWrapper gui, TileEntity tile, ResourceLocation def) {
        super(gui, def, tile, 176, 138, 26, 26);
        this.xLocation = 0;
        this.yLocation = 0;
    }

    @Override
    protected boolean inBounds(int xAxis, int yAxis) {
        return xAxis >= 179 + this.xLocation && xAxis <= 197 + this.xLocation && yAxis >= 142 + this.yLocation && yAxis <= 160 + this.yLocation;
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        MekanismRenderer.color(-3602657);
        super.renderBackground(xAxis, yAxis, guiWidth, guiHeight);
        MekanismRenderer.resetColor();
        GuiRedstoneControl.mc.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiRedstoneControl.png"));
        this.guiObj.drawTexturedRect(guiWidth + 176 + this.xLocation, guiHeight + 138 + this.yLocation, 0, 0, 26, 26);
        IRedstoneControl control = (IRedstoneControl)this.tileEntity;
        int renderX = 26 + 18 * control.getControlType().ordinal();
        if (control.getControlType() != IRedstoneControl.RedstoneControl.PULSE) {
            this.guiObj.drawTexturedRect(guiWidth + 179 + this.xLocation, guiHeight + 142 + this.yLocation, renderX, 0, 18, 18);
        } else {
            int DynamicGUI = 0;
            double tick = (float)this.time.getValue() / 20.0f;
            if (tick >= (double)0.1f && tick < (double)0.2f || tick >= (double)0.8f && tick < (double)0.9f) {
                DynamicGUI += 18;
            } else if (tick >= (double)0.2f && tick < (double)0.3f || tick >= (double)0.7f && tick < (double)0.8f) {
                DynamicGUI += 36;
            } else if (tick >= (double)0.3f && tick < (double)0.4f || tick >= (double)0.6f && tick < (double)0.7f) {
                DynamicGUI += 54;
            } else if (tick >= (double)0.4f && tick < (double)0.6f) {
                DynamicGUI += 72;
            }
            this.guiObj.drawTexturedRect(guiWidth + 179 + this.xLocation, guiHeight + 142 + this.yLocation, renderX, DynamicGUI, 18, 18);
        }
        GuiRedstoneControl.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        GuiRedstoneControl.mc.field_71446_o.func_110577_a(this.RESOURCE);
        IRedstoneControl control = (IRedstoneControl)this.tileEntity;
        if (this.inBounds(xAxis, yAxis)) {
            this.displayTooltip(control.getControlType().getDisplay(), xAxis, yAxis);
        }
        GuiRedstoneControl.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
        IRedstoneControl control = (IRedstoneControl)this.tileEntity;
        if (button == 0 && this.inBounds(xAxis, yAxis)) {
            int ordinalToSet;
            IRedstoneControl.RedstoneControl current = control.getControlType();
            int n = ordinalToSet = current.ordinal() < IRedstoneControl.RedstoneControl.values().length - 1 ? current.ordinal() + 1 : 0;
            if (ordinalToSet == IRedstoneControl.RedstoneControl.PULSE.ordinal() && !control.canPulse()) {
                ordinalToSet = 0;
            }
            SoundHandler.playSound(SoundEvents.field_187909_gi);
            Mekanism.packetHandler.sendToServer(new PacketRedstoneControl.RedstoneControlMessage(Coord4D.get(this.tileEntity), IRedstoneControl.RedstoneControl.values()[ordinalToSet]));
        }
    }
}

