/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiRateBarHorizontal
extends GuiElement {
    private final int xLocation;
    private final int yLocation;
    private final IRateInfoHandler handler;
    private final RateBarHorizontal type = RateBarHorizontal.HORIZONTAL;

    public GuiRateBarHorizontal(IGuiWrapper gui, IRateInfoHandler h, ResourceLocation def, int x, int y) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BAR, "Rate_Bar_Horizontal.png"), gui, def);
        this.handler = h;
        this.xLocation = x;
        this.yLocation = y;
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth + this.xLocation, guiHeight + this.yLocation, this.type.width, this.type.height);
    }

    @Override
    protected boolean inBounds(int xAxis, int yAxis) {
        return xAxis >= this.xLocation + 2 && xAxis <= this.xLocation + 80 && yAxis >= this.yLocation + 2 && yAxis <= this.yLocation + 10;
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiRateBarHorizontal.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation, this.type.textureX, this.type.textureY, this.type.width, this.type.height);
        if (this.handler.getLevel() > 0.0) {
            int innerOffsetX = 2;
            int displayInt = (int)(this.handler.getLevel() * (double)(this.type.width - 2 * innerOffsetX));
            this.guiObj.drawTexturedRect(guiWidth + this.xLocation + innerOffsetX + 1, guiHeight + this.yLocation, this.type.textureX + this.type.width + innerOffsetX, this.type.textureY, displayInt, this.type.height);
        }
        GuiRateBarHorizontal.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        GuiRateBarHorizontal.mc.field_71446_o.func_110577_a(this.RESOURCE);
        if (this.handler.getTooltip() != null && this.inBounds(xAxis, yAxis)) {
            this.displayTooltip(this.handler.getTooltip(), xAxis, yAxis);
        }
        GuiRateBarHorizontal.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
    }

    public static enum RateBarHorizontal {
        HORIZONTAL(84, 12, 0, 0);

        public final int width;
        public final int height;
        public final int textureX;
        public final int textureY;

        private RateBarHorizontal(int w, int h, int u, int v) {
            this.width = w;
            this.height = h;
            this.textureX = u;
            this.textureY = v;
        }
    }

    public static abstract class IRateInfoHandler {
        public String getTooltip() {
            return null;
        }

        public abstract double getLevel();
    }
}

