/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiProgress
extends GuiElement {
    protected final IProgressInfoHandler handler;
    protected final ProgressBar type;
    protected final int xLocation;
    protected final int yLocation;

    public GuiProgress(IProgressInfoHandler handler, ProgressBar type, IGuiWrapper gui, ResourceLocation def, int x, int y) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.PROGRESS, "Progress_Icon.png"), gui, def);
        this.xLocation = x;
        this.yLocation = y;
        this.type = type;
        this.handler = handler;
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth + this.xLocation, guiHeight + this.yLocation, this.type.width, this.type.height);
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiProgress.mc.field_71446_o.func_110577_a(this.RESOURCE);
        if (this.handler.isActive()) {
            this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation, this.type.textureX, this.type.textureY, this.type.width, this.type.height);
            int innerOffsetX = 2;
            if (this.type.vertical) {
                int displayInt = (int)(this.handler.getProgress() * (double)this.type.height);
                if (displayInt > 0) {
                    int innerOffsetY = 0;
                    if (this.type.isReverse()) {
                        innerOffsetY += this.type.height - displayInt;
                    }
                    this.guiObj.drawTexturedRect(guiWidth + this.xLocation + innerOffsetX, guiHeight + this.yLocation + innerOffsetY, this.type.textureX + this.type.width + innerOffsetX, this.type.textureY, this.type.width, displayInt);
                }
            } else {
                int displayInt = (int)(this.handler.getProgress() * (double)(this.type.width - 2 * innerOffsetX));
                if (displayInt > 0) {
                    if (this.type.isReverse()) {
                        innerOffsetX += this.type.width - 4 - displayInt;
                    }
                    this.guiObj.drawTexturedRect(guiWidth + this.xLocation + innerOffsetX, guiHeight + this.yLocation, this.type.textureX + this.type.width + innerOffsetX, this.type.textureY, displayInt, this.type.height);
                }
            }
        }
        GuiProgress.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
    }

    public static enum ProgressBar {
        BAR(28, 11, 0, 0, false),
        LARGE_RIGHT(52, 10, 128, 0, false),
        LARGE_LEFT(52, 10, 128, 10, false),
        MEDIUM(36, 10, 128, 20, false),
        SMALL_RIGHT(32, 10, 128, 30, false),
        SMALL_LEFT(32, 10, 128, 40, false),
        BI(20, 8, 128, 50, false),
        DOWN(12, 22, 128, 58, true),
        TALL_RIGHT(26, 17, 128, 80, false),
        INSTALLING(14, 16, 128, 97, true),
        BI_RIGHT(20, 8, 128, 130, false);

        public final int width;
        public final int height;
        public final int textureX;
        public final int textureY;
        public final boolean vertical;

        private ProgressBar(int w, int h, int u, int v, boolean vertical) {
            this.width = w;
            this.height = h;
            this.textureX = u;
            this.textureY = v;
            this.vertical = vertical;
        }

        public boolean isReverse() {
            return this == SMALL_LEFT || this == LARGE_LEFT;
        }
    }

    public static abstract class IProgressInfoHandler {
        public abstract double getProgress();

        public boolean isActive() {
            return true;
        }
    }
}

