/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiPowerBarshort
extends GuiElement {
    private final IStrictEnergyStorage tileEntity;
    private final IPowerInfoHandler handler;
    private final int xLocation;
    private final int yLocation;
    private final int width = 6;
    private final int height = 51;

    public GuiPowerBarshort(IGuiWrapper gui, IStrictEnergyStorage tile, ResourceLocation def, int x, int y) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BAR, "Power_Bar_Short.png"), gui, def);
        this.tileEntity = tile;
        this.handler = new IPowerInfoHandler(){

            @Override
            public String getTooltip() {
                return MekanismUtils.getEnergyDisplay(GuiPowerBarshort.this.tileEntity.getEnergy(), GuiPowerBarshort.this.tileEntity.getMaxEnergy());
            }

            @Override
            public double getLevel() {
                return GuiPowerBarshort.this.tileEntity.getEnergy() / GuiPowerBarshort.this.tileEntity.getMaxEnergy();
            }

            @Override
            public boolean powerbarWarning() {
                return GuiPowerBarshort.this.tileEntity.getEnergy() == 0.0;
            }
        };
        this.xLocation = x;
        this.yLocation = y;
    }

    public GuiPowerBarshort(IGuiWrapper gui, IPowerInfoHandler h, ResourceLocation def, int x, int y) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BAR, "Power_Bar_Short.png"), gui, def);
        this.tileEntity = null;
        this.handler = h;
        this.xLocation = x;
        this.yLocation = y;
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth + this.xLocation, guiHeight + this.yLocation, 6, 51);
    }

    @Override
    protected boolean inBounds(int xAxis, int yAxis) {
        return xAxis >= this.xLocation && xAxis <= this.xLocation + 6 && yAxis >= this.yLocation && yAxis <= this.yLocation + 51;
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiPowerBarshort.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation, 0, 0, 6, 51);
        if (this.handler.powerbarWarning()) {
            GuiPowerBarshort.mc.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Warning_Background.png"));
            this.guiObj.drawTexturedRect(guiWidth + this.xLocation + 1, guiHeight + this.yLocation + 2, 0, 0, 4, 47);
        } else if (this.handler.getLevel() > 0.0) {
            int displayInt = (int)(this.handler.getLevel() * 47.0) + 2;
            this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation + 51 - displayInt, 6, 51 - displayInt, 6, displayInt);
        }
        GuiPowerBarshort.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        GuiPowerBarshort.mc.field_71446_o.func_110577_a(this.RESOURCE);
        if (this.handler.getTooltip() != null && this.inBounds(xAxis, yAxis)) {
            this.displayTooltip(this.handler.getTooltip(), xAxis, yAxis);
        }
        GuiPowerBarshort.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
    }

    public static abstract class IPowerInfoHandler {
        public String getTooltip() {
            return null;
        }

        public abstract double getLevel();

        public boolean powerbarWarning() {
            return false;
        }
    }
}

