/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiPowerBarHorizontal
extends GuiElement {
    private final IStrictEnergyStorage tileEntity;
    private final IPowerInfoHandler handler;
    private final int xLocation;
    private final int yLocation;
    private final PowerBarHorizontal type = PowerBarHorizontal.HORIZONTAL;

    public GuiPowerBarHorizontal(IGuiWrapper gui, IStrictEnergyStorage tile, ResourceLocation def, int x, int y) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BAR, "Power_Bar_Horizontal.png"), gui, def);
        this.tileEntity = tile;
        this.handler = new IPowerInfoHandler(){

            @Override
            public String getTooltip() {
                return MekanismUtils.getEnergyDisplay(GuiPowerBarHorizontal.this.tileEntity.getEnergy(), GuiPowerBarHorizontal.this.tileEntity.getMaxEnergy());
            }

            @Override
            public double getLevel() {
                return GuiPowerBarHorizontal.this.tileEntity.getEnergy() / GuiPowerBarHorizontal.this.tileEntity.getMaxEnergy();
            }

            @Override
            public boolean powerbarWarning() {
                return GuiPowerBarHorizontal.this.tileEntity.getEnergy() == 0.0;
            }
        };
        this.xLocation = x;
        this.yLocation = y;
    }

    public GuiPowerBarHorizontal(IGuiWrapper gui, IPowerInfoHandler h, ResourceLocation def, int x, int y) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BAR, "Power_Bar_Horizontal.png"), gui, def);
        this.tileEntity = null;
        this.handler = h;
        this.xLocation = x;
        this.yLocation = y;
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth + this.xLocation, guiHeight + this.yLocation, this.type.width, this.type.height);
    }

    @Override
    protected boolean inBounds(int xAxis, int yAxis) {
        return xAxis >= this.xLocation + 2 && xAxis <= this.xLocation + 55 && yAxis >= this.yLocation + 2 && yAxis <= this.yLocation + 6;
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiPowerBarHorizontal.mc.field_71446_o.func_110577_a(this.RESOURCE);
        this.guiObj.drawTexturedRect(guiWidth + this.xLocation, guiHeight + this.yLocation, this.type.textureX, this.type.textureY, this.type.width, this.type.height);
        if (this.handler.powerbarWarning()) {
            GuiPowerBarHorizontal.mc.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Warning_Background.png"));
            this.guiObj.drawTexturedRect(guiWidth + this.xLocation + 3, guiHeight + this.yLocation + 2, 0, 0, 52, 4);
        } else if (this.handler.getLevel() > 0.0) {
            int innerOffsetX = 2;
            int displayInt = (int)(this.handler.getLevel() * (double)(this.type.width - 2 * innerOffsetX));
            this.guiObj.drawTexturedRect(guiWidth + this.xLocation + innerOffsetX + 1, guiHeight + this.yLocation, this.type.textureX + this.type.width + innerOffsetX, this.type.textureY, displayInt, this.type.height);
        }
        GuiPowerBarHorizontal.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        GuiPowerBarHorizontal.mc.field_71446_o.func_110577_a(this.RESOURCE);
        if (this.handler.getTooltip() != null && this.inBounds(xAxis, yAxis)) {
            this.displayTooltip(this.handler.getTooltip(), xAxis, yAxis);
        }
        GuiPowerBarHorizontal.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
    }

    public static enum PowerBarHorizontal {
        HORIZONTAL(58, 8, 0, 0);

        public final int width;
        public final int height;
        public final int textureX;
        public final int textureY;

        private PowerBarHorizontal(int w, int h, int u, int v) {
            this.width = w;
            this.height = h;
            this.textureX = u;
            this.textureY = v;
        }
    }

    public static abstract class IPowerInfoHandler {
        public String getTooltip() {
            return null;
        }

        public abstract double getLevel();

        public boolean powerbarWarning() {
            return false;
        }
    }
}

