/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import java.util.ArrayList;
import java.util.List;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiGraph
extends GuiElement {
    private final List<Integer> graphData = new ArrayList<Integer>();
    private final GraphDataHandler dataHandler;
    private final int xPosition;
    private final int yPosition;
    private final int xSize;
    private final int ySize;
    private int currentScale = 10;
    private boolean fixedScale = false;

    public GuiGraph(IGuiWrapper gui, ResourceLocation def, int x, int y, int sizeX, int sizeY, GraphDataHandler handler) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiGraph.png"), gui, def);
        this.xPosition = x;
        this.yPosition = y;
        this.xSize = sizeX;
        this.ySize = sizeY;
        this.dataHandler = handler;
    }

    public void enableFixedScale(int scale) {
        this.fixedScale = true;
        this.currentScale = scale;
    }

    public void addData(int data) {
        if (this.graphData.size() == this.xSize) {
            this.graphData.remove(0);
        }
        this.graphData.add(data);
        if (!this.fixedScale) {
            for (int i : this.graphData) {
                if (i <= this.currentScale) continue;
                this.currentScale = i;
            }
        }
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth + this.xPosition, guiHeight + this.yPosition, this.xSize, this.ySize);
    }

    @Override
    protected boolean inBounds(int xAxis, int yAxis) {
        return xAxis >= this.xPosition && xAxis <= this.xPosition + this.xSize && yAxis >= this.yPosition && yAxis <= this.yPosition + this.ySize;
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        this.drawBlack(guiWidth, guiHeight);
        this.drawGraph(guiWidth, guiHeight);
        GuiGraph.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
        if (this.inBounds(xAxis, yAxis)) {
            int height = this.ySize - (yAxis - this.yPosition);
            int scaled = (int)((double)height / (double)this.ySize * (double)this.currentScale);
            this.displayTooltip(this.dataHandler.getDataDisplay(scaled), xAxis, yAxis);
        }
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
    }

    public void drawBlack(int guiWidth, int guiHeight) {
        GuiGraph.mc.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Inner_Screen.png"));
        int halfWidthLeft = this.xSize / 2;
        int halfWidthRight = this.xSize % 2 == 0 ? halfWidthLeft : halfWidthLeft + 1;
        int halfHeightTop = (this.ySize + 1) / 2;
        int halfHeight = (this.ySize + 1) % 2 == 0 ? halfHeightTop : halfHeightTop + 1;
        MekanismRenderer.resetColor();
        this.guiObj.drawTexturedRect(guiWidth + this.xPosition, guiHeight + this.yPosition, 0, 0, halfWidthLeft, halfHeightTop);
        this.guiObj.drawTexturedRect(guiWidth + this.xPosition, guiHeight + this.yPosition + halfHeightTop, 0, 256 - halfHeight, halfWidthLeft, halfHeight);
        this.guiObj.drawTexturedRect(guiWidth + this.xPosition + halfWidthLeft, guiHeight + this.yPosition, 256 - halfWidthRight, 0, halfWidthRight, halfHeightTop);
        this.guiObj.drawTexturedRect(guiWidth + this.xPosition + halfWidthLeft, guiHeight + this.yPosition + halfHeightTop, 256 - halfWidthRight, 256 - halfHeight, halfWidthRight, halfHeight);
    }

    public void drawGraph(int guiWidth, int guiHeight) {
        GuiGraph.mc.field_71446_o.func_110577_a(this.RESOURCE);
        for (int i = 0; i < this.graphData.size(); ++i) {
            int data = Math.min(this.currentScale, this.graphData.get(i));
            int relativeHeight = (int)((double)data / (double)this.currentScale * (double)this.ySize);
            this.guiObj.drawTexturedRect(guiWidth + this.xPosition + i, guiHeight + this.yPosition + (this.ySize - relativeHeight), 10, 0, 1, 1);
            int displays = (relativeHeight - 1) / 10 + ((relativeHeight - 1) % 10 > 0 ? 1 : 0);
            GlStateManager.func_179103_j((int)7425);
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            for (int iter = 0; iter < displays; ++iter) {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)(0.2f + 0.8f * ((float)i / (float)this.graphData.size())));
                int height = (relativeHeight - 1) % 10 > 0 && iter == displays - 1 ? (relativeHeight - 1) % 10 : 10;
                this.guiObj.drawTexturedRect(guiWidth + this.xPosition + i, guiHeight + this.yPosition + (this.ySize - iter * 10) - 10 + (10 - height), 11, 0, 1, height);
            }
            MekanismRenderer.resetColor();
            GlStateManager.func_179084_k();
            GlStateManager.func_179141_d();
        }
    }

    public static interface GraphDataHandler {
        public String getDataDisplay(int var1);
    }
}

