/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element;

import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElement;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiElementScreen
extends GuiElement {
    private final int xPosition;
    private final int yPosition;
    private final int xSize;
    private final int ySize;
    private boolean isFrame = false;

    public GuiElementScreen(IGuiWrapper gui, ResourceLocation def, int x, int y, int sizeX, int sizeY) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Null.png"), gui, def);
        this.xPosition = x;
        this.yPosition = y;
        this.xSize = sizeX;
        this.ySize = sizeY;
    }

    @Override
    public GuiElement.Rectangle4i getBounds(int guiWidth, int guiHeight) {
        return new GuiElement.Rectangle4i(guiWidth + this.xPosition, guiHeight + this.yPosition, this.xSize, this.ySize);
    }

    @Override
    protected boolean inBounds(int xAxis, int yAxis) {
        return xAxis >= this.xPosition && xAxis <= this.xPosition + this.xSize && yAxis >= this.yPosition && yAxis <= this.yPosition + this.ySize;
    }

    public GuiElementScreen isFrame(boolean isFrame) {
        this.isFrame = isFrame;
        return this;
    }

    @Override
    public void renderBackground(int xAxis, int yAxis, int guiWidth, int guiHeight) {
        GuiElementScreen.mc.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, this.isFrame ? "Element_Holder_Frame.png" : "Element_Holder.png"));
        this.drawBlack(guiWidth, guiHeight);
        GuiElementScreen.mc.field_71446_o.func_110577_a(this.defaultLocation);
    }

    @Override
    public void renderForeground(int xAxis, int yAxis) {
    }

    @Override
    public void preMouseClicked(int xAxis, int yAxis, int button) {
    }

    @Override
    public void mouseClicked(int xAxis, int yAxis, int button) {
    }

    public void drawBlack(int guiWidth, int guiHeight) {
        int halfWidthLeft = this.xSize / 2;
        int halfWidthRight = this.xSize % 2 == 0 ? halfWidthLeft : halfWidthLeft + 1;
        int halfHeightTop = this.ySize / 2;
        int halfHeight = this.ySize % 2 == 0 ? halfHeightTop : halfHeightTop + 1;
        MekanismRenderer.resetColor();
        this.guiObj.drawTexturedRect(guiWidth + this.xPosition, guiHeight + this.yPosition, 0, 0, halfWidthLeft, halfHeightTop);
        this.guiObj.drawTexturedRect(guiWidth + this.xPosition, guiHeight + this.yPosition + halfHeightTop, 0, 256 - halfHeight, halfWidthLeft, halfHeight);
        this.guiObj.drawTexturedRect(guiWidth + this.xPosition + halfWidthLeft, guiHeight + this.yPosition, 256 - halfWidthRight, 0, halfWidthRight, halfHeightTop);
        this.guiObj.drawTexturedRect(guiWidth + this.xPosition + halfWidthLeft, guiHeight + this.yPosition + halfHeightTop, 256 - halfWidthRight, 256 - halfHeight, halfWidthRight, halfHeight);
    }
}

