/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.chemical;

import java.util.ArrayList;
import java.util.Arrays;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiBucketIO;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiPowerBarHorizontal;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiWarningInfo;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiSideConfigurationTab;
import mekanism.client.gui.element.tab.GuiTransporterConfigTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.common.inventory.container.ContainerChemicalWasher;
import mekanism.common.tile.machine.TileEntityChemicalWasher;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiChemicalWasher
extends GuiMekanismTile<TileEntityChemicalWasher> {
    public GuiChemicalWasher(InventoryPlayer inventory, TileEntityChemicalWasher tile) {
        super(tile, new ContainerChemicalWasher(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSideConfigurationTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiTransporterConfigTab((IGuiWrapper)this, 34, this.tileEntity, resource));
        this.addGuiElement(new GuiPowerBarHorizontal((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 113, 74));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            String usage = MekanismUtils.getEnergyDisplay(((TileEntityChemicalWasher)this.tileEntity).clientEnergyUsed);
            return Arrays.asList(LangUtils.localize("gui.using") + ": " + usage + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityChemicalWasher)this.tileEntity).getMaxEnergy() - ((TileEntityChemicalWasher)this.tileEntity).getEnergy()));
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiFluidGauge(() -> ((TileEntityChemicalWasher)this.tileEntity).fluidTank, GuiGauge.Type.STANDARD, this, resource, 5, 4).withColor(GuiGauge.TypeColor.RED));
        this.addGuiElement(new GuiGasGauge(() -> ((TileEntityChemicalWasher)this.tileEntity).inputTank, GuiGauge.Type.STANDARD, this, resource, 26, 13).withColor(GuiGauge.TypeColor.RED));
        this.addGuiElement(new GuiGasGauge(() -> ((TileEntityChemicalWasher)this.tileEntity).outputTank, GuiGauge.Type.STANDARD, this, resource, 133, 13).withColor(GuiGauge.TypeColor.BLUE));
        this.addGuiElement(new GuiBucketIO(this, resource));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.POWER, this, resource, 154, 13).with(GuiSlot.SlotOverlay.POWER));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.OUTPUT, this, resource, 154, 55).with(GuiSlot.SlotOverlay.MINUS));
        this.addGuiElement(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return ((TileEntityChemicalWasher)GuiChemicalWasher.this.tileEntity).getActive() ? 1.0 : 0.0;
            }
        }, GuiProgress.ProgressBar.LARGE_RIGHT, this, resource, 62, 38));
        this.addGuiElement(new GuiPlayerSlot(this, resource));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityChemicalWasher)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityChemicalWasher)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (xAxis >= -21 && xAxis <= -3 && yAxis >= 116 && yAxis <= 134) {
            boolean output;
            ArrayList<String> info = new ArrayList<String>();
            boolean energy = ((TileEntityChemicalWasher)this.tileEntity).getEnergy() < ((TileEntityChemicalWasher)this.tileEntity).energyPerTick || ((TileEntityChemicalWasher)this.tileEntity).getEnergy() == 0.0;
            boolean bl = output = ((TileEntityChemicalWasher)this.tileEntity).outputTank.getStored() == ((TileEntityChemicalWasher)this.tileEntity).outputTank.getMaxGas();
            if (energy) {
                info.add(LangUtils.localize("gui.no_energy"));
            }
            if (output) {
                info.add(LangUtils.localize("gui.gas_no_space"));
            }
            if (output || energy) {
                this.displayTooltips(info, xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        boolean energy;
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Other_Icon.png"));
        this.func_73729_b(this.field_147003_i + 8, this.field_147009_r + 66, 0, 0, 12, 13);
        boolean output = ((TileEntityChemicalWasher)this.tileEntity).outputTank.getStored() == ((TileEntityChemicalWasher)this.tileEntity).outputTank.getMaxGas();
        boolean bl = energy = ((TileEntityChemicalWasher)this.tileEntity).getEnergy() < ((TileEntityChemicalWasher)this.tileEntity).energyPerTick || ((TileEntityChemicalWasher)this.tileEntity).getEnergy() == 0.0;
        if (output) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Warning.png"));
            this.func_73729_b(this.field_147003_i + 133 + 9, this.field_147009_r + 13 + 1, 9, 1, 8, 29);
            this.func_73729_b(this.field_147003_i + 133 + 9, this.field_147009_r + 13 + 31, 9, 32, 8, 28);
        }
        if (output || energy) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.TAB, "Warning_Info.png"));
            this.func_73729_b(this.field_147003_i - 26, this.field_147009_r + 112, 0, 0, 26, 26);
            this.addGuiElement(new GuiWarningInfo(this, this.getGuiLocation(), false));
        }
    }
}

