/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.chemical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.api.gas.Gas;
import mekanism.api.gas.OreGas;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiWarningInfo;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiSideConfigurationTab;
import mekanism.client.gui.element.tab.GuiTransporterConfigTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.common.inventory.container.ContainerChemicalCrystallizer;
import mekanism.common.recipe.machines.CrystallizerRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import mekanism.common.tile.machine.TileEntityChemicalCrystallizer;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

@SideOnly(value=Side.CLIENT)
public class GuiChemicalCrystallizer
extends GuiMekanismTile<TileEntityChemicalCrystallizer> {
    private List<ItemStack> iterStacks = new ArrayList<ItemStack>();
    private ItemStack renderStack = ItemStack.field_190927_a;
    private int stackSwitch = 0;
    private int stackIndex = 0;
    private Gas prevGas;

    public GuiChemicalCrystallizer(InventoryPlayer inventory, TileEntityChemicalCrystallizer tile) {
        super(tile, new ContainerChemicalCrystallizer(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 160, 23));
        this.addGuiElement(new GuiSideConfigurationTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiTransporterConfigTab((IGuiWrapper)this, 34, this.tileEntity, resource));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            String multiplier = MekanismUtils.getEnergyDisplay(((TileEntityChemicalCrystallizer)this.tileEntity).energyPerTick);
            return Arrays.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityChemicalCrystallizer)this.tileEntity).getMaxEnergy() - ((TileEntityChemicalCrystallizer)this.tileEntity).getEnergy()));
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiGasGauge(() -> ((TileEntityChemicalCrystallizer)this.tileEntity).inputTank, GuiGauge.Type.STANDARD, this, resource, 5, 4).withColor(GuiGauge.TypeColor.RED));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.INPUT, this, resource, 5, 64).with(GuiSlot.SlotOverlay.PLUS));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.POWER, this, resource, 154, 4).with(GuiSlot.SlotOverlay.POWER));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.OUTPUT, this, resource, 130, 56));
        this.addGuiElement(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return ((TileEntityChemicalCrystallizer)GuiChemicalCrystallizer.this.tileEntity).getScaledProgress();
            }
        }, GuiProgress.ProgressBar.LARGE_RIGHT, this, resource, 51, 60));
        this.addGuiElement(new GuiInnerScreen(this, resource, 27, 13, 121, 42).with(true));
        this.addGuiElement(new GuiPlayerSlot(this, resource));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityChemicalCrystallizer)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityChemicalCrystallizer)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        if (((TileEntityChemicalCrystallizer)this.tileEntity).inputTank.getGas() != null) {
            this.field_146289_q.func_78276_b(((TileEntityChemicalCrystallizer)this.tileEntity).inputTank.getGas().getGas().getLocalizedName(), 29, 15, 52480);
            Gas gas = ((TileEntityChemicalCrystallizer)this.tileEntity).inputTank.getGas().getGas();
            if (gas instanceof OreGas) {
                OreGas oreGas = (OreGas)gas;
                this.field_146289_q.func_78276_b("(" + oreGas.getOreName() + ")", 29, 24, 52480);
            } else {
                CrystallizerRecipe recipe = ((TileEntityChemicalCrystallizer)this.tileEntity).getRecipe();
                if (recipe == null) {
                    this.field_146289_q.func_78276_b("(" + LangUtils.localize("gui.noRecipe") + ")", 29, 24, 52480);
                } else {
                    this.field_146289_q.func_78276_b("(" + ((ItemStackOutput)recipe.recipeOutput).output.func_82833_r() + ")", 29, 24, 52480);
                }
            }
        }
        this.renderItem(this.renderStack, 131, 14);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (xAxis >= -21 && xAxis <= -3 && yAxis >= 116 && yAxis <= 134) {
            boolean outslot;
            ArrayList<String> info = new ArrayList<String>();
            boolean energy = ((TileEntityChemicalCrystallizer)this.tileEntity).getEnergy() < ((TileEntityChemicalCrystallizer)this.tileEntity).energyPerTick || ((TileEntityChemicalCrystallizer)this.tileEntity).getEnergy() == 0.0;
            boolean bl = outslot = ((ItemStack)((TileEntityChemicalCrystallizer)this.tileEntity).inventory.get(1)).func_190916_E() == ((ItemStack)((TileEntityChemicalCrystallizer)this.tileEntity).inventory.get(1)).func_77976_d();
            if (energy) {
                info.add(LangUtils.localize("gui.no_energy"));
            }
            if (outslot) {
                info.add(LangUtils.localize("gui.item_no_space"));
            }
            if (outslot || energy) {
                this.displayTooltips(info, xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        boolean energy;
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        boolean outslot = ((ItemStack)((TileEntityChemicalCrystallizer)this.tileEntity).inventory.get(1)).func_190916_E() == ((ItemStack)((TileEntityChemicalCrystallizer)this.tileEntity).inventory.get(1)).func_77976_d();
        boolean bl = energy = ((TileEntityChemicalCrystallizer)this.tileEntity).getEnergy() < ((TileEntityChemicalCrystallizer)this.tileEntity).energyPerTick || ((TileEntityChemicalCrystallizer)this.tileEntity).getEnergy() == 0.0;
        if (outslot) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.SLOT, "Slot_Icon.png"));
            this.func_73729_b(this.field_147003_i + 130, this.field_147009_r + 56, 158, 0, 18, 18);
        }
        if (outslot || energy) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.TAB, "Warning_Info.png"));
            this.func_73729_b(this.field_147003_i - 26, this.field_147009_r + 112, 0, 0, 26, 26);
            this.addGuiElement(new GuiWarningInfo(this, this.getGuiLocation(), false));
        }
    }

    private Gas getInputGas() {
        return ((TileEntityChemicalCrystallizer)this.tileEntity).inputTank.getGas() != null ? ((TileEntityChemicalCrystallizer)this.tileEntity).inputTank.getGas().getGas() : null;
    }

    private void resetStacks() {
        this.iterStacks.clear();
        this.renderStack = ItemStack.field_190927_a;
        this.stackSwitch = 0;
        this.stackIndex = -1;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.prevGas != this.getInputGas()) {
            OreGas oreGas;
            Gas gas;
            this.prevGas = this.getInputGas();
            boolean reset = false;
            if (this.prevGas == null || !((gas = this.prevGas) instanceof OreGas) || !(oreGas = (OreGas)gas).isClean()) {
                reset = true;
                this.resetStacks();
            }
            if (!reset) {
                OreGas gas2 = (OreGas)this.prevGas;
                String oreDictName = "ore" + gas2.getName().substring(5);
                this.updateStackList(oreDictName);
            }
        }
        if (this.stackSwitch > 0) {
            --this.stackSwitch;
        }
        if (this.stackSwitch == 0 && this.iterStacks != null && this.iterStacks.size() > 0) {
            this.stackSwitch = 20;
            if (this.stackIndex == -1 || this.stackIndex == this.iterStacks.size() - 1) {
                this.stackIndex = 0;
            } else if (this.stackIndex < this.iterStacks.size() - 1) {
                ++this.stackIndex;
            }
            this.renderStack = this.iterStacks.get(this.stackIndex);
        } else if (this.iterStacks != null && this.iterStacks.size() == 0) {
            this.renderStack = ItemStack.field_190927_a;
        }
    }

    private void updateStackList(String oreName) {
        if (this.iterStacks == null) {
            this.iterStacks = new ArrayList<ItemStack>();
        } else {
            this.iterStacks.clear();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (String s : OreDictionary.getOreNames()) {
            if (oreName.equals(s) || oreName.equals("*")) {
                keys.add(s);
                continue;
            }
            boolean endsWith = oreName.endsWith("*");
            boolean startsWith = oreName.startsWith("*");
            if (endsWith && !startsWith) {
                if (!s.startsWith(oreName.substring(0, oreName.length() - 1))) continue;
                keys.add(s);
                continue;
            }
            if (startsWith && !endsWith) {
                if (!s.endsWith(oreName.substring(1))) continue;
                keys.add(s);
                continue;
            }
            if (!startsWith || !s.contains(oreName.substring(1, oreName.length() - 1))) continue;
            keys.add(s);
        }
        for (String key : keys) {
            for (ItemStack stack : OreDictionary.getOres((String)key, (boolean)false)) {
                ItemStack toAdd = stack.func_77946_l();
                if (this.iterStacks.contains(stack) || !(toAdd.func_77973_b() instanceof ItemBlock)) continue;
                this.iterStacks.add(stack.func_77946_l());
            }
        }
        this.stackSwitch = 0;
        this.stackIndex = -1;
    }
}

