/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.button;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.api.EnumColor;
import mekanism.api.RelativeSide;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismBlocks;
import mekanism.common.SideData;
import mekanism.common.block.states.BlockStateTransmitter;
import mekanism.common.tile.TileEntityGlowPanel;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import mekanism.common.tile.transmitter.TileEntitySidedPipe;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSideDataButton
extends GuiButton {
    private final Supplier<SideData> sideDataSupplier;
    private final Supplier<EnumColor> colorSupplier;
    private final ResourceLocation Button = MekanismUtils.getResource(MekanismUtils.ResourceType.BUTTON, "Button.png");
    private final int slotPosMapIndex;
    private final ItemStack otherBlockItem;
    protected RenderItem itemRender;

    public GuiSideDataButton(int id, int x, int y, int slotPosMapIndex, Supplier<SideData> sideDataSupplier, Supplier<EnumColor> colorSupplier, TileEntityBasicBlock tile, RelativeSide side) {
        super(id, x, y, 22, 22, "");
        this.slotPosMapIndex = slotPosMapIndex;
        this.sideDataSupplier = sideDataSupplier;
        this.colorSupplier = colorSupplier;
        World tileWorld = tile.func_145831_w();
        if (tileWorld != null) {
            EnumFacing globalSide = side.getDirection(tile.facing);
            BlockPos otherBlockPos = tile.func_174877_v().func_177972_a(globalSide);
            IBlockState blockOnSide = tileWorld.func_180495_p(otherBlockPos);
            if (blockOnSide.func_177230_c() != Blocks.field_150350_a) {
                if (blockOnSide.func_177230_c() != MekanismBlocks.BoundingBlock) {
                    this.otherBlockItem = blockOnSide.func_177230_c().func_185473_a(tileWorld, otherBlockPos, blockOnSide);
                    NBTTagCompound tag = new NBTTagCompound();
                    Enum[] enumArray = tileWorld.func_175625_s(otherBlockPos);
                    if (enumArray instanceof TileEntityBasicBlock) {
                        TileEntityBasicBlock BasicBlock2 = (TileEntityBasicBlock)enumArray;
                        BasicBlock2.func_189515_b(tag);
                    }
                    if ((enumArray = tileWorld.func_175625_s(otherBlockPos)) instanceof TileEntitySidedPipe) {
                        TileEntitySidedPipe sidedPipe = (TileEntitySidedPipe)enumArray;
                        enumArray = BlockStateTransmitter.TransmitterType.values();
                        int n = enumArray.length;
                        for (int i = 0; i < n; ++i) {
                            Enum enum_ = enumArray[i];
                            if (!((BlockStateTransmitter.TransmitterType)enum_).getTransmission().equals((Object)sidedPipe.getTransmitterType().getTransmission())) continue;
                            sidedPipe.func_189515_b(tag);
                            this.otherBlockItem.func_77964_b(sidedPipe.getTransmitterType().ordinal());
                        }
                    }
                    if ((enumArray = tileWorld.func_175625_s(otherBlockPos)) instanceof TileEntityGlowPanel) {
                        TileEntityGlowPanel glowPanel = (TileEntityGlowPanel)enumArray;
                        for (Enum enum_ : EnumColor.DYES) {
                            if (((EnumColor)enum_).getMetaValue() != glowPanel.colour.getMetaValue()) continue;
                            this.otherBlockItem.func_77964_b(glowPanel.colour.getMetaValue());
                        }
                    }
                    this.otherBlockItem.func_77982_d(tag);
                } else {
                    this.otherBlockItem = ItemStack.field_190927_a;
                }
            } else {
                this.otherBlockItem = ItemStack.field_190927_a;
            }
        } else {
            this.otherBlockItem = ItemStack.field_190927_a;
        }
    }

    public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
            int halfWidthLeft = this.field_146120_f / 2;
            int halfWidthRight = this.field_146120_f % 2 == 0 ? halfWidthLeft : halfWidthLeft + 1;
            int halfHeightTop = this.field_146121_g / 2;
            int halfHeightBottom = this.field_146121_g % 2 == 0 ? halfHeightTop : halfHeightTop + 1;
            mc.func_110434_K().func_110577_a(this.Button);
            SideData data = this.sideDataSupplier.get();
            if (data == TileComponentConfig.EMPTY) {
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, 0, halfWidthLeft, halfHeightTop);
                this.func_73729_b(this.field_146128_h, this.field_146129_i + halfHeightTop, 0, 20 - halfHeightBottom, halfWidthLeft, halfHeightBottom);
                this.func_73729_b(this.field_146128_h + halfWidthLeft, this.field_146129_i, 200 - halfWidthRight, 0, halfWidthRight, halfHeightTop);
                this.func_73729_b(this.field_146128_h + halfWidthLeft, this.field_146129_i + halfHeightTop, 200 - halfWidthRight, 20 - halfHeightBottom, halfWidthRight, halfHeightBottom);
            } else {
                boolean doColor;
                EnumColor color = this.getColor();
                boolean bl = doColor = color != null && color != EnumColor.GREY;
                if (doColor) {
                    MekanismRenderer.color(this.getColor());
                }
                int Focusorhover = this.field_146123_n ? 40 : 20;
                this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, Focusorhover, halfWidthLeft, halfHeightTop);
                this.func_73729_b(this.field_146128_h, this.field_146129_i + halfHeightTop, 0, Focusorhover + 20 - halfHeightBottom, halfWidthLeft, halfHeightBottom);
                this.func_73729_b(this.field_146128_h + halfWidthLeft, this.field_146129_i, 200 - halfWidthRight, Focusorhover, halfWidthRight, halfHeightTop);
                this.func_73729_b(this.field_146128_h + halfWidthLeft, this.field_146129_i + halfHeightTop, 200 - halfWidthRight, Focusorhover + 20 - halfHeightBottom, halfWidthRight, halfHeightBottom);
                if (doColor) {
                    MekanismRenderer.resetColor();
                }
            }
        }
    }

    public int getSlotPosMapIndex() {
        return this.slotPosMapIndex;
    }

    public SideData getSideData() {
        return this.sideDataSupplier.get();
    }

    public EnumColor getColor() {
        return this.colorSupplier.get();
    }

    public ItemStack getItem() {
        return this.otherBlockItem;
    }
}

