/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.button;

import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiDisableableButton
extends GuiButton {
    private final ResourceLocation Button = MekanismUtils.getResource(MekanismUtils.ResourceType.BUTTON, "Button.png");
    private final ResourceLocation Button_BLACK = MekanismUtils.getResource(MekanismUtils.ResourceType.BUTTON, "Button_Black.png");
    private final ResourceLocation Button_Digital = MekanismUtils.getResource(MekanismUtils.ResourceType.BUTTON, "Button_Digital.png");
    private final ResourceLocation ButtonIcon = MekanismUtils.getResource(MekanismUtils.ResourceType.BUTTON, "Button_Icon.png");
    private ImageOverlay overlay = null;
    private boolean Toggleborders = false;
    private boolean scale;
    private float textscale;
    private int enabledColor = -1;
    private int disabledColor = -6250336;
    private int hoveredOrFocusedColor = -1;
    private Supplier<Integer> mod;

    public GuiDisableableButton(int id, int x, int y, int size) {
        this(id, x, y, size, size, "");
    }

    public GuiDisableableButton(int id, int x, int y, int width, int height) {
        this(id, x, y, width, height, "");
    }

    public GuiDisableableButton(int id, int x, int y, int width, int height, Supplier<Integer> mod) {
        this(id, x, y, width, height, "");
        this.mod = mod;
    }

    public GuiDisableableButton(int id, int x, int y, int width, int height, String text) {
        super(id, x, y, width, height, text);
    }

    public GuiDisableableButton with(ImageOverlay overlay) {
        this.overlay = overlay;
        return this;
    }

    public GuiDisableableButton handoff(boolean Toggleborders) {
        this.Toggleborders = Toggleborders;
        return this;
    }

    public GuiDisableableButton textscale(boolean scale, float textscale) {
        this.textscale = textscale;
        this.scale = scale;
        return this;
    }

    public GuiDisableableButton enabledTextColor(int color) {
        this.enabledColor = color;
        return this;
    }

    public GuiDisableableButton disabledTextColor(int color) {
        this.disabledColor = color;
        return this;
    }

    public GuiDisableableButton hoveredtextColor(int color) {
        this.hoveredOrFocusedColor = color;
        return this;
    }

    protected int func_146114_a(boolean hoveredOrFocused) {
        if (!this.field_146124_l) {
            return 0;
        }
        if (hoveredOrFocused) {
            return 2;
        }
        return 1;
    }

    protected int GetMod() {
        if (this.mod != null) {
            return this.mod.get() * 18;
        }
        return 0;
    }

    protected int getTextColor(boolean hoveredOrFocused) {
        if (!this.field_146124_l) {
            return this.disabledColor;
        }
        if (hoveredOrFocused) {
            return this.hoveredOrFocusedColor;
        }
        return this.enabledColor;
    }

    public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (this.field_146125_m) {
            int halfHeightBottom;
            FontRenderer fontrenderer = mc.field_71466_p;
            MekanismRenderer.resetColor();
            this.field_146123_n = mouseX >= this.field_146128_h && mouseX < this.field_146128_h + this.field_146120_f && mouseY >= this.field_146129_i && mouseY < this.field_146129_i + this.field_146121_g;
            int i = this.func_146114_a(this.field_146123_n);
            int position = i * 20;
            int halfWidthLeft = this.field_146120_f / 2;
            int halfWidthRight = this.field_146120_f % 2 == 0 ? halfWidthLeft : halfWidthLeft + 1;
            int halfHeightTop = this.field_146121_g / 2;
            int n = halfHeightBottom = this.field_146121_g % 2 == 0 ? halfHeightTop : halfHeightTop + 1;
            ResourceLocation Texture2 = this.overlay == ImageOverlay.CHECKMARK_DIGITAL || this.Toggleborders ? this.Button_Digital : (this.overlay == ImageOverlay.DUMP ? this.Button_BLACK : this.Button);
            mc.func_110434_K().func_110577_a(Texture2);
            GlStateManager.func_179097_i();
            this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, position, halfWidthLeft, halfHeightTop);
            this.func_73729_b(this.field_146128_h, this.field_146129_i + halfHeightTop, 0, position + 20 - halfHeightBottom, halfWidthLeft, halfHeightBottom);
            this.func_73729_b(this.field_146128_h + halfWidthLeft, this.field_146129_i, 200 - halfWidthRight, position, halfWidthRight, halfHeightTop);
            this.func_73729_b(this.field_146128_h + halfWidthLeft, this.field_146129_i + halfHeightTop, 200 - halfWidthRight, position + 20 - halfHeightBottom, halfWidthRight, halfHeightBottom);
            if (this.overlay != null && this.field_146126_j.isEmpty()) {
                mc.func_110434_K().func_110577_a(this.ButtonIcon);
                int w = this.overlay.width;
                int h = this.overlay.height;
                int xLocationOverlay = this.field_146128_h + (this.field_146120_f - w) / 2;
                int yLocationOverlay = this.field_146129_i + (this.field_146121_g - h) / 2;
                this.func_73729_b(xLocationOverlay, yLocationOverlay, this.overlay.textureX + this.GetMod(), this.overlay.textureY, w, h);
            }
            if (!this.field_146126_j.isEmpty()) {
                if (!this.scale) {
                    this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + this.field_146121_g / 2 - 4, this.getTextColor(this.field_146123_n));
                } else {
                    int textWidth = fontrenderer.func_78256_a(this.field_146126_j);
                    float centerX = (float)this.field_146128_h - (float)textWidth / 2.0f * this.textscale;
                    fontrenderer.func_78276_b(this.field_146126_j, (int)centerX, this.field_146129_i, this.getTextColor(this.field_146123_n));
                }
            }
            GlStateManager.func_179126_j();
        }
    }

    public static enum ImageOverlay {
        AUTO_EJECT(18, 18, 0, 0),
        AUTO_PULL(18, 18, 18, 0),
        AUTO_TOGGLE(18, 18, 36, 0),
        BACK(18, 18, 54, 0),
        CHECKMARK(18, 18, 72, 0),
        CHECKMARK_DIGITAL(18, 18, 90, 0),
        CLEAR_SIDES(18, 18, 108, 0),
        CLOSE(18, 18, 126, 0),
        CRAFT_AVAILABLE(18, 18, 144, 0),
        CRAFT_SINGLE(18, 18, 162, 0),
        CRAFTING(18, 18, 180, 0),
        DEFAULT(18, 18, 198, 0),
        DOWN(18, 18, 216, 0),
        DROP(18, 18, 234, 0),
        ENCODE_FORMULA(18, 18, 0, 18),
        EXCLAMATION(18, 18, 18, 18),
        FILL_EMPTY(18, 18, 36, 18),
        FOLLOW(18, 18, 54, 18),
        FUZZY(18, 18, 72, 18),
        HOME(18, 18, 90, 18),
        INVENTORY(18, 18, 108, 18),
        LEFT(18, 18, 126, 18),
        MAIN(18, 18, 144, 18),
        MINUS(18, 18, 162, 18),
        PLUS(18, 18, 180, 18),
        PRIVATE(18, 18, 198, 18),
        PUBLIC(18, 18, 216, 18),
        RENAME(18, 18, 234, 18),
        REPAIR(18, 18, 0, 36),
        RESET(18, 18, 18, 36),
        RIGHT(18, 18, 36, 36),
        ROUND_ROBIN(18, 18, 54, 36),
        SILK_TOUCH(18, 18, 72, 36),
        SINGLE(18, 18, 90, 36),
        SKIN(18, 18, 108, 36),
        SMELTING(18, 18, 126, 36),
        STOCK_CONTROL(18, 18, 144, 36),
        DUMP(36, 18, 162, 36),
        TRUSTED(18, 18, 198, 36),
        UP(18, 18, 216, 36),
        INVERSE(18, 18, 234, 36),
        SMALL_BACK(18, 18, 0, 54),
        TOGGLE(18, 18, 0, 72),
        GAS_MOD(18, 18, 0, 90),
        FORCE_RUN(18, 18, 18, 54);

        public final int width;
        public final int height;
        public final int textureX;
        public final int textureY;

        private ImageOverlay(int w, int h, int x, int y) {
            this.width = w;
            this.height = h;
            this.textureX = x;
            this.textureY = y;
        }
    }
}

