/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.EnumColor;
import mekanism.api.RelativeSide;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.Utils.ClientUtil;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.GuiSideConfiguration;
import mekanism.client.gui.button.GuiColorButton;
import mekanism.client.gui.button.GuiDisableableButton;
import mekanism.client.gui.button.GuiSideDataButton;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketConfigurationUpdate;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiTransporterConfig
extends GuiMekanismTile<TileEntityContainerBlock> {
    private Int2ObjectMap<GuiSideConfiguration.GuiPos> slotPosMap = new Int2ObjectOpenHashMap();
    private ISideConfiguration configurable;
    private List<GuiSideDataButton> sideDataButtons = new ArrayList<GuiSideDataButton>();
    private GuiButton backButton;
    private GuiButton strictInputButton;
    private GuiButton colorButton;
    private int buttonID = 0;

    public GuiTransporterConfig(EntityPlayer player, ISideConfiguration tile) {
        super((TileEntityContainerBlock)((Object)tile), new ContainerNull(player, (TileEntityContainerBlock)((Object)tile)));
        this.field_146999_f = 156;
        this.field_147000_g = 119;
        this.configurable = tile;
        ResourceLocation resource = this.getGuiLocation();
        this.slotPosMap.put(0, (Object)new GuiSideConfiguration.GuiPos(41, 80, RelativeSide.BOTTOM));
        this.slotPosMap.put(1, (Object)new GuiSideConfiguration.GuiPos(41, 34, RelativeSide.TOP));
        this.slotPosMap.put(2, (Object)new GuiSideConfiguration.GuiPos(41, 57, RelativeSide.FRONT));
        this.slotPosMap.put(3, (Object)new GuiSideConfiguration.GuiPos(18, 80, RelativeSide.BACK));
        this.slotPosMap.put(4, (Object)new GuiSideConfiguration.GuiPos(18, 57, RelativeSide.LEFT));
        this.slotPosMap.put(5, (Object)new GuiSideConfiguration.GuiPos(64, 57, RelativeSide.RIGHT));
        this.addGuiElement(new GuiInnerScreen(this, resource, 41, 15, 74, 12));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.backButton = new GuiDisableableButton(this.buttonID++, this.field_147003_i + 6, this.field_147009_r + 6, 14).with(GuiDisableableButton.ImageOverlay.BACK);
        this.field_146292_n.add(this.backButton);
        this.strictInputButton = new GuiDisableableButton(this.buttonID++, this.field_147003_i + 136, this.field_147009_r + 6, 14).with(GuiDisableableButton.ImageOverlay.EXCLAMATION);
        this.field_146292_n.add(this.strictInputButton);
        this.colorButton = new GuiColorButton(this.buttonID++, this.field_147003_i + 122, this.field_147009_r + 49, () -> this.configurable.getEjector().getOutputColor());
        this.field_146292_n.add(this.colorButton);
        for (int i = 0; i < this.slotPosMap.size(); ++i) {
            GuiSideConfiguration.GuiPos guiPos = (GuiSideConfiguration.GuiPos)this.slotPosMap.get(i);
            EnumFacing facing = EnumFacing.func_82600_a((int)i);
            RelativeSide side = RelativeSide.bydex(i);
            GuiSideDataButton button = new GuiSideDataButton(this.buttonID++, this.field_147003_i + guiPos.xPos, this.field_147009_r + guiPos.yPos, i, () -> this.configurable.getConfig().getOutput(TransmissionType.ITEM, facing), () -> this.configurable.getEjector().getInputColor(facing), this.tileEntity, side);
            this.field_146292_n.add(button);
            this.sideDataButtons.add(button);
        }
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        TileEntity tile = (TileEntity)this.configurable;
        if (guibutton.field_146127_k == this.backButton.field_146127_k) {
            int guiId = Mekanism.proxy.getGuiId(tile.func_145838_q(), tile.func_145832_p());
            Mekanism.packetHandler.sendToServer(new PacketSimpleGui.SimpleGuiMessage(Coord4D.get(tile), 0, guiId));
        } else if (guibutton.field_146127_k == this.strictInputButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.STRICT_INPUT, Coord4D.get(tile), 0, 0, null));
        } else if (guibutton.field_146127_k == this.colorButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.EJECT_COLOR, Coord4D.get(tile), Keyboard.isKeyDown((int)42) ? 2 : 0, 0, null));
        } else {
            for (GuiSideDataButton button : this.sideDataButtons) {
                if (guibutton.field_146127_k != button.field_146127_k) continue;
                Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.INPUT_COLOR, Coord4D.get(tile), Keyboard.isKeyDown((int)42) ? 2 : 0, button.getSlotPosMapIndex(), null));
                break;
            }
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        String text = LangUtils.localize("gui.configuration.transporter");
        this.field_146289_q.func_78276_b(text, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(text) / 2, 5, 0x404040);
        text = LangUtils.localize("gui.strictInput") + " (" + LangUtils.transOnOff(this.configurable.getEjector().hasStrictInput()) + ")";
        this.renderScaledText(text, 43, 17, 52480, 70);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.input"), 51, 105, 0x787878);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.output"), 121, 68, 0x787878);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        for (GuiSideDataButton button : this.sideDataButtons) {
            if (!button.func_146115_a()) continue;
            SideData data = button.getSideData();
            if (data == TileComponentConfig.EMPTY) break;
            EnumColor color = button.getColor();
            ArrayList<String> info = new ArrayList<String>();
            for (int i = 0; i < this.slotPosMap.size(); ++i) {
                GuiSideConfiguration.GuiPos guiPos = (GuiSideConfiguration.GuiPos)this.slotPosMap.get(i);
                String FacingName = guiPos.FacingName.getTranslationKey();
                if (button.getSlotPosMapIndex() != i) continue;
                info.add(FacingName);
            }
            info.add(color != null ? color.getColoredName() : LangUtils.localize("gui.none"));
            if (button.getItem() != ItemStack.field_190927_a && button.getItem().func_77973_b() != Items.field_190931_a) {
                info.add(button.getItem().func_77973_b().func_77653_i(button.getItem()));
            }
            this.displayTooltips(info, xAxis, yAxis);
            break;
        }
        if (this.strictInputButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.configuration.strictInput"), xAxis, yAxis);
        } else if (this.colorButton.func_146115_a()) {
            if (this.configurable.getEjector().getOutputColor() != null) {
                this.displayTooltip(this.configurable.getEjector().getOutputColor().getColoredName(), xAxis, yAxis);
            } else {
                this.displayTooltip(LangUtils.localize("gui.none"), xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        for (int i = 0; i < this.slotPosMap.size(); ++i) {
            GuiSideConfiguration.GuiPos guiPos = (GuiSideConfiguration.GuiPos)this.slotPosMap.get(i);
            if (this.sideDataButtons.get(i).getItem() == ItemStack.field_190927_a) continue;
            ClientUtil.renderItem(this.sideDataButtons.get(i).getItem(), this.field_147003_i + guiPos.xPos + 3, this.field_147009_r + guiPos.yPos + 3);
        }
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
    }

    public void func_73876_c() {
        super.func_73876_c();
        TileEntity tile = (TileEntity)this.configurable;
        if (tile == null || this.field_146297_k.field_71441_e.func_175625_s(tile.func_174877_v()) == null) {
            this.field_146297_k.func_147108_a(null);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        if (button == 1) {
            TileEntity tile = (TileEntity)this.configurable;
            if (this.colorButton.func_146115_a()) {
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.EJECT_COLOR, Coord4D.get(tile), 1, 0, null));
            } else {
                for (GuiSideDataButton sideDataButton : this.sideDataButtons) {
                    if (!sideDataButton.func_146115_a()) continue;
                    SoundHandler.playSound(SoundEvents.field_187909_gi);
                    Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.INPUT_COLOR, Coord4D.get(tile), 1, sideDataButton.getSlotPosMapIndex(), null));
                    break;
                }
            }
        }
    }
}

