/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiRateBar;
import mekanism.client.gui.element.GuiWarningInfo;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.gauge.GuiNumberGauge;
import mekanism.client.gui.element.tab.GuiBoilerTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.config.MekanismConfig;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.inventory.container.ContainerThermoelectricBoiler;
import mekanism.common.tile.multiblock.TileEntityBoilerCasing;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiThermoelectricBoiler
extends GuiMekanismTile<TileEntityBoilerCasing> {
    public GuiThermoelectricBoiler(InventoryPlayer inventory, TileEntityBoilerCasing tile) {
        super(tile, new ContainerThermoelectricBoiler(inventory, tile));
        this.field_146999_f += 40;
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiBoilerTab((IGuiWrapper)this, (TileEntityBoilerCasing)this.tileEntity, GuiBoilerTab.BoilerTab.STAT, resource));
        this.addGuiElement(new GuiRateBar(this, new GuiRateBar.IRateInfoHandler(){

            @Override
            public String getTooltip() {
                return LangUtils.localize("gui.boilRate") + ": " + ((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).getLastBoilRate() + " mB/t";
            }

            @Override
            public double getLevel() {
                return ((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure == null ? 0.0 : (double)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).getLastBoilRate() / (double)((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).lastMaxBoil;
            }
        }, resource, 44, 13));
        this.addGuiElement(new GuiRateBar(this, new GuiRateBar.IRateInfoHandler(){

            @Override
            public String getTooltip() {
                return LangUtils.localize("gui.maxBoil") + ": " + ((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).getLastMaxBoil() + " mB/t";
            }

            @Override
            public double getLevel() {
                return ((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure == null ? 0.0 : (double)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).getLastMaxBoil() * SynchronizedBoilerData.getHeatEnthalpy() / ((double)((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).superheatingElements * MekanismConfig.current().general.superheatingHeatTransfer.val());
            }
        }, resource, 164, 13));
        this.addGuiElement(new GuiHeatInfo(() -> {
            UnitDisplayUtils.TemperatureUnit unit = UnitDisplayUtils.TemperatureUnit.values()[MekanismConfig.current().general.tempUnit.val().ordinal()];
            String environment = UnitDisplayUtils.getDisplayShort(((TileEntityBoilerCasing)this.tileEntity).getLastEnvironmentLoss() * unit.intervalSize, false, unit);
            return Collections.singletonList(LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiInnerScreen(this, resource, 60, 23, 96, 40));
        this.addGuiElement(new GuiPlayerSlot(this, resource, 26));
        this.addGuiElement(new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            @Override
            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.getFluidTexture(((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure != null ? ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).waterStored : null, MekanismRenderer.FluidType.STILL);
            }

            @Override
            public double getLevel() {
                if (((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure != null && ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).waterStored != null) {
                    return ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).waterStored.amount;
                }
                return 0.0;
            }

            @Override
            public double getMaxLevel() {
                if (((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure != null && ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).waterStored != null) {
                    return ((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).clientWaterCapacity;
                }
                return 0.0;
            }

            @Override
            public String getText(double level) {
                return ((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure != null ? (((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).waterStored != null ? LangUtils.localizeFluidStack(((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).waterStored) + ": " + ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).waterStored.amount + "mB" : LangUtils.localize("gui.empty")) : "";
            }
        }, GuiGauge.Type.STANDARD, this, resource, 26, 13));
        this.addGuiElement(new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            @Override
            public TextureAtlasSprite getIcon() {
                return MekanismRenderer.getFluidTexture(((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure != null ? ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).steamStored : null, MekanismRenderer.FluidType.STILL);
            }

            @Override
            public double getLevel() {
                if (((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure != null && ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).steamStored != null) {
                    return ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).steamStored.amount;
                }
                return 0.0;
            }

            @Override
            public double getMaxLevel() {
                if (((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure != null && ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).steamStored != null) {
                    return ((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).clientSteamCapacity;
                }
                return 0.0;
            }

            @Override
            public String getText(double level) {
                return ((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure != null ? (((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).steamStored != null ? LangUtils.localizeFluidStack(((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).steamStored) + ": " + ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).steamStored.amount + "mB" : LangUtils.localize("gui.empty")) : "";
            }
        }, GuiGauge.Type.STANDARD, this, resource, 172, 13));
        this.addGuiElement(new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            @Override
            public TextureAtlasSprite getIcon() {
                if (((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure != null) {
                    MekanismRenderer.color(((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).InputGas.getGas());
                    return ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).InputGas.getGas().getSprite();
                }
                return null;
            }

            @Override
            public double getLevel() {
                if (((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure != null && ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).InputGas != null) {
                    return ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).InputGas.amount;
                }
                return 0.0;
            }

            @Override
            public double getMaxLevel() {
                if (((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure != null && ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).InputGas != null) {
                    return ((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).clientWaterCapacity;
                }
                return 0.0;
            }

            @Override
            public String getText(double level) {
                return ((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure != null ? (((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).InputGas != null ? ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).InputGas.getGas().getLocalizedName() + ": " + ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).InputGas.amount + "mB" : LangUtils.localize("gui.empty")) : "";
            }
        }, GuiGauge.Type.STANDARD, this, resource, 6, 13));
        this.addGuiElement(new GuiNumberGauge(new GuiNumberGauge.INumberInfoHandler(){

            @Override
            public TextureAtlasSprite getIcon() {
                if (((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure != null) {
                    MekanismRenderer.color(((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).OutputGas.getGas());
                    return ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).OutputGas.getGas().getSprite();
                }
                return null;
            }

            @Override
            public double getLevel() {
                if (((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure != null && ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).OutputGas != null) {
                    return ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).OutputGas.amount;
                }
                return 0.0;
            }

            @Override
            public double getMaxLevel() {
                if (((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure != null && ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).OutputGas != null) {
                    return ((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).clientSteamCapacity;
                }
                return 0.0;
            }

            @Override
            public String getText(double level) {
                return ((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure != null ? (((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).OutputGas != null ? ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).OutputGas.getGas().getLocalizedName() + ": " + ((SynchronizedBoilerData)((TileEntityBoilerCasing)GuiThermoelectricBoiler.this.tileEntity).structure).OutputGas.amount + "mB" : LangUtils.localize("gui.empty")) : "";
            }
        }, GuiGauge.Type.STANDARD, this, resource, 192, 13));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 4, 0x404040);
        this.field_146289_q.func_78276_b(((TileEntityBoilerCasing)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityBoilerCasing)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        this.renderScaledText(LangUtils.localize("gui.temp") + ": " + MekanismUtils.getTemperatureDisplay(((TileEntityBoilerCasing)this.tileEntity).getTemperature(), UnitDisplayUtils.TemperatureUnit.AMBIENT), 63, 30, -12779878, 90);
        this.renderScaledText(LangUtils.localize("gui.boilRate") + ": " + ((TileEntityBoilerCasing)this.tileEntity).getLastBoilRate() + " mB/t", 63, 39, -12779878, 90);
        this.renderScaledText(LangUtils.localize("gui.maxBoil") + ": " + ((TileEntityBoilerCasing)this.tileEntity).getLastMaxBoil() + " mB/t", 63, 48, -12779878, 90);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (xAxis >= -21 && xAxis <= -3 && yAxis >= 90 && yAxis <= 108) {
            boolean Steam;
            ArrayList<String> info = new ArrayList<String>();
            boolean bl = Steam = ((TileEntityBoilerCasing)this.tileEntity).structure != null && ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).steamStored != null && ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).steamStored.amount == ((TileEntityBoilerCasing)this.tileEntity).clientSteamCapacity;
            if (Steam) {
                info.add(LangUtils.localize("gui.steam_no_space"));
            }
            if (Steam) {
                this.displayTooltips(info, xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        boolean Output;
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        boolean Steam = ((TileEntityBoilerCasing)this.tileEntity).structure != null && ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).steamStored != null && ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).steamStored.amount == ((TileEntityBoilerCasing)this.tileEntity).clientSteamCapacity;
        boolean bl = Output = ((TileEntityBoilerCasing)this.tileEntity).structure != null && ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).OutputGas != null && ((SynchronizedBoilerData)((TileEntityBoilerCasing)this.tileEntity).structure).OutputGas.amount == ((TileEntityBoilerCasing)this.tileEntity).clientSteamCapacity;
        if (Steam) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Warning.png"));
            this.func_73729_b(this.field_147003_i + 172 + 9, this.field_147009_r + 13 + 1, 9, 1, 8, 29);
            this.func_73729_b(this.field_147003_i + 172 + 9, this.field_147009_r + 13 + 31, 9, 32, 8, 28);
        }
        if (Output) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Warning.png"));
            this.func_73729_b(this.field_147003_i + 192 + 9, this.field_147009_r + 13 + 1, 9, 1, 8, 29);
            this.func_73729_b(this.field_147003_i + 192 + 9, this.field_147009_r + 13 + 31, 9, 32, 8, 28);
        }
        if (Steam || Output) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.TAB, "Warning_Info.png"));
            this.func_73729_b(this.field_147003_i - 26, this.field_147009_r + 86, 0, 0, 26, 26);
            this.addGuiElement(new GuiWarningInfo(this, this.getGuiLocation(), true));
        }
    }
}

