/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiRateBarHorizontal;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiWarningInfo;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.ContainerThermalEvaporationController;
import mekanism.common.tile.multiblock.TileEntityThermalEvaporationController;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiThermalEvaporationController
extends GuiMekanismTile<TileEntityThermalEvaporationController> {
    public GuiThermalEvaporationController(InventoryPlayer inventory, TileEntityThermalEvaporationController tile) {
        super(tile, new ContainerThermalEvaporationController(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiFluidGauge(() -> ((TileEntityThermalEvaporationController)this.tileEntity).inputTank, GuiGauge.Type.STANDARD, this, resource, 6, 13));
        this.addGuiElement(new GuiFluidGauge(() -> ((TileEntityThermalEvaporationController)this.tileEntity).outputTank, GuiGauge.Type.STANDARD, this, resource, 152, 13));
        this.addGuiElement(new GuiHeatInfo(() -> {
            UnitDisplayUtils.TemperatureUnit unit = UnitDisplayUtils.TemperatureUnit.values()[MekanismConfig.current().general.tempUnit.val().ordinal()];
            String environment = UnitDisplayUtils.getDisplayShort((double)((TileEntityThermalEvaporationController)this.tileEntity).totalLoss * unit.intervalSize, false, unit);
            return Collections.singletonList(LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiRateBarHorizontal(this, new GuiRateBarHorizontal.IRateInfoHandler(){

            @Override
            public String getTooltip() {
                return LangUtils.localize("gui.temp") + ": " + GuiThermalEvaporationController.this.getTemp();
            }

            @Override
            public double getLevel() {
                return Math.min(1.0, (double)((TileEntityThermalEvaporationController)GuiThermalEvaporationController.this.tileEntity).getTemperature() / MekanismConfig.current().general.evaporationMaxTemp.val());
            }
        }, resource, 46, 62));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 27, 19));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 27, 50));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 131, 19));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 131, 50));
        this.addGuiElement(new GuiInnerScreen(this, resource, 48, 19, 80, 40));
        this.addGuiElement(new GuiPlayerSlot(this, resource));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        boolean outputfluid;
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Other_Icon.png"));
        this.func_73729_b(this.field_147003_i + 32, this.field_147009_r + 39, 13, 0, 8, 9);
        this.func_73729_b(this.field_147003_i + 136, this.field_147009_r + 39, 13, 0, 8, 9);
        boolean bl = outputfluid = ((TileEntityThermalEvaporationController)this.tileEntity).outputTank.getFluidAmount() == ((TileEntityThermalEvaporationController)this.tileEntity).outputTank.getCapacity();
        if (outputfluid) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Warning.png"));
            this.func_73729_b(this.field_147003_i + 152 + 9, this.field_147009_r + 13 + 1, 9, 1, 8, 29);
            this.func_73729_b(this.field_147003_i + 152 + 9, this.field_147009_r + 13 + 31, 9, 32, 8, 28);
        }
        if (outputfluid) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.TAB, "Warning_Info.png"));
            this.func_73729_b(this.field_147003_i - 26, this.field_147009_r + 86, 0, 0, 26, 26);
            this.addGuiElement(new GuiWarningInfo(this, this.getGuiLocation(), true));
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 4, 0x404040);
        this.field_146289_q.func_78276_b(((TileEntityThermalEvaporationController)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityThermalEvaporationController)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(this.getStruct(), 50, 21, -12779878);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.height") + ": " + ((TileEntityThermalEvaporationController)this.tileEntity).height, 50, 30, -12779878);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.temp") + ": " + this.getTemp(), 50, 39, -12779878);
        this.renderScaledText(LangUtils.localize("gui.production") + ": " + (double)Math.round((double)((TileEntityThermalEvaporationController)this.tileEntity).lastGain * 100.0) / 100.0 + " mB/t", 50, 48, -12779878, 76);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (xAxis >= 7 && xAxis <= 23 && yAxis >= 14 && yAxis <= 72) {
            FluidStack fluid = ((TileEntityThermalEvaporationController)this.tileEntity).inputTank.getFluid();
            this.displayTooltip(fluid != null ? LangUtils.localizeFluidStack(fluid) + ": " + ((TileEntityThermalEvaporationController)this.tileEntity).inputTank.getFluidAmount() : LangUtils.localize("gui.empty"), xAxis, yAxis);
        } else if (xAxis >= 153 && xAxis <= 169 && yAxis >= 14 && yAxis <= 72) {
            FluidStack fluid = ((TileEntityThermalEvaporationController)this.tileEntity).outputTank.getFluid();
            this.displayTooltip(fluid != null ? LangUtils.localizeFluidStack(fluid) + ": " + ((TileEntityThermalEvaporationController)this.tileEntity).outputTank.getFluidAmount() : LangUtils.localize("gui.empty"), xAxis, yAxis);
        } else if (xAxis >= -21 && xAxis <= -3 && yAxis >= 90 && yAxis <= 108) {
            boolean outputfluid;
            ArrayList<String> info = new ArrayList<String>();
            boolean bl = outputfluid = ((TileEntityThermalEvaporationController)this.tileEntity).outputTank.getFluidAmount() == ((TileEntityThermalEvaporationController)this.tileEntity).outputTank.getCapacity();
            if (outputfluid) {
                info.add(LangUtils.localize("gui.fluid_no_space"));
            }
            if (outputfluid) {
                this.displayTooltips(info, xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    private String getStruct() {
        if (((TileEntityThermalEvaporationController)this.tileEntity).structured) {
            return LangUtils.localize("gui.formed");
        }
        if (((TileEntityThermalEvaporationController)this.tileEntity).controllerConflict) {
            return LangUtils.localize("gui.conflict");
        }
        return LangUtils.localize("gui.incomplete");
    }

    private String getTemp() {
        return MekanismUtils.getTemperatureDisplay(((TileEntityThermalEvaporationController)this.tileEntity).getTemperature(), UnitDisplayUtils.TemperatureUnit.AMBIENT);
    }
}

