/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.client.ClientTickHandler;
import mekanism.client.MekanismClient;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.button.GuiColorButton;
import mekanism.client.gui.button.GuiDisableableButton;
import mekanism.client.gui.element.GuiElementScreen;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiScrollList;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiWarningInfo;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.frequency.Frequency;
import mekanism.common.frequency.FrequencyManager;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.inventory.container.ContainerTeleporter;
import mekanism.common.item.ItemPortableTeleporter;
import mekanism.common.network.PacketPortableTeleporter;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.IOwnerItem;
import mekanism.common.tile.TileEntityTeleporter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiTeleporter
extends GuiMekanismTile<TileEntityTeleporter> {
    private final boolean isPortable;
    private EnumHand currentHand;
    private ItemStack itemStack = ItemStack.field_190927_a;
    private EntityPlayer entityPlayer;
    private GuiDisableableButton publicButton;
    private GuiDisableableButton privateButton;
    private GuiDisableableButton setButton;
    private GuiDisableableButton deleteButton;
    private GuiDisableableButton teleportButton;
    private GuiDisableableButton checkboxButton;
    private GuiColorButton colorButton;
    private GuiScrollList scrollList;
    private GuiTextField frequencyField;
    private boolean privateMode;
    private Frequency clientFreq;
    private byte clientStatus;
    private List<Frequency> clientPublicCache = new ArrayList<Frequency>();
    private List<Frequency> clientPrivateCache = new ArrayList<Frequency>();
    private boolean isInit = true;
    private int yStart;

    public GuiTeleporter(InventoryPlayer inventory, TileEntityTeleporter tile) {
        super(tile, new ContainerTeleporter(inventory, tile));
        this.isPortable = false;
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            @Override
            public String getTooltip() {
                return MekanismUtils.getEnergyDisplay(GuiTeleporter.this.getEnergy(), GuiTeleporter.this.getMaxEnergy());
            }

            @Override
            public double getLevel() {
                return GuiTeleporter.this.getEnergy() / GuiTeleporter.this.getMaxEnergy();
            }

            @Override
            public boolean powerbarWarning() {
                return ((TileEntityTeleporter)GuiTeleporter.this.tileEntity).getEnergy() == 0.0;
            }
        }, resource, 158, 26));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.POWER, this, resource, 152, 6).with(GuiSlot.SlotOverlay.POWER));
        this.scrollList = new GuiScrollList(this, resource, 28, 37, 120, 4);
        this.addGuiElement(this.scrollList);
        if (((TileEntityTeleporter)this.tileEntity).frequency != null) {
            this.privateMode = !((TileEntityTeleporter)this.tileEntity).frequency.publicFreq;
        }
        this.field_147000_g += 74;
        this.addGuiElement(new GuiPlayerSlot(this, resource, 7, 157));
        this.addGuiElement(new GuiElementScreen(this, this.getGuiLocation(), 27, 36, 122, 42).isFrame(true));
        this.addGuiElement(new GuiInnerScreen(this, this.getGuiLocation(), 48, 111, 101, 13));
        this.yStart = 14;
    }

    public GuiTeleporter(EntityPlayer player, EnumHand hand, ItemStack stack) {
        super(null, new ContainerNull());
        this.isPortable = true;
        this.currentHand = hand;
        this.itemStack = stack;
        this.entityPlayer = player;
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, new GuiPowerBar.IPowerInfoHandler(){

            @Override
            public String getTooltip() {
                return MekanismUtils.getEnergyDisplay(GuiTeleporter.this.getEnergy(), GuiTeleporter.this.getMaxEnergy());
            }

            @Override
            public double getLevel() {
                return GuiTeleporter.this.getEnergy() / GuiTeleporter.this.getMaxEnergy();
            }
        }, resource, 158, 26));
        this.scrollList = new GuiScrollList(this, resource, 28, 37, 120, 4);
        this.addGuiElement(this.scrollList);
        ItemPortableTeleporter item = (ItemPortableTeleporter)this.itemStack.func_77973_b();
        if (item.getFrequency(stack) != null) {
            this.privateMode = !item.getFrequency((ItemStack)stack).publicFreq;
            this.setFrequency(item.getFrequency((ItemStack)stack).name);
        } else {
            Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.DATA_REQUEST, this.currentHand, this.clientFreq));
        }
        this.field_147000_g = 172;
        this.addGuiElement(new GuiElementScreen(this, this.getGuiLocation(), 27, 36, 122, 42).isFrame(true));
        this.addGuiElement(new GuiInnerScreen(this, this.getGuiLocation(), 48, 111, 101, 13));
        this.yStart = 14;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.publicButton = new GuiDisableableButton(0, this.field_147003_i + 27, this.field_147009_r + this.yStart, 60, 20, LangUtils.localize("gui.public"));
        this.field_146292_n.add(this.publicButton);
        this.privateButton = new GuiDisableableButton(1, this.field_147003_i + 89, this.field_147009_r + this.yStart, 60, 20, LangUtils.localize("gui.private"));
        this.field_146292_n.add(this.privateButton);
        int buttonWidth = this.isPortable ? 60 : 50;
        this.setButton = new GuiDisableableButton(2, this.field_147003_i + 27, this.field_147009_r + this.yStart + 113, buttonWidth, 18, LangUtils.localize("gui.set"));
        this.field_146292_n.add(this.setButton);
        this.deleteButton = new GuiDisableableButton(3, this.field_147003_i + 29 + buttonWidth, this.field_147009_r + this.yStart + 113, buttonWidth, 18, LangUtils.localize("gui.delete"));
        this.field_146292_n.add(this.deleteButton);
        if (!this.itemStack.func_190926_b()) {
            this.teleportButton = new GuiDisableableButton(4, this.field_147003_i + 42, this.field_147009_r + 147, 92, 20, LangUtils.localize("gui.teleport"));
            this.field_146292_n.add(this.teleportButton);
        }
        if (!this.isPortable) {
            this.colorButton = new GuiColorButton(7, this.field_147003_i + 132, this.field_147009_r + this.yStart + 114, () -> ((TileEntityTeleporter)this.tileEntity).color);
            this.field_146292_n.add(this.colorButton);
        }
        this.frequencyField = new GuiTextField(5, this.field_146289_q, this.field_147003_i + 50, this.field_147009_r + this.yStart + 99, 98, 11);
        this.frequencyField.func_146203_f(16);
        this.frequencyField.func_146185_a(false);
        this.checkboxButton = new GuiDisableableButton(6, this.field_147003_i + 137, this.field_147009_r + this.yStart + 98, 11, 11).with(GuiDisableableButton.ImageOverlay.CHECKMARK);
        this.field_146292_n.add(this.checkboxButton);
        this.updateButtons();
        if (!this.itemStack.func_190926_b()) {
            if (!this.isInit) {
                Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.DATA_REQUEST, this.currentHand, this.clientFreq));
            } else {
                this.isInit = false;
            }
        }
    }

    public String getSecurity(Frequency freq) {
        return !freq.publicFreq ? (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.private") : (Object)((Object)EnumColor.BRIGHT_GREEN) + LangUtils.localize("gui.public");
    }

    public void updateButtons() {
        if (this.getOwner() == null) {
            return;
        }
        ArrayList<String> text = new ArrayList<String>();
        if (this.privateMode) {
            for (Frequency freq : this.getPrivateCache()) {
                text.add(freq.name);
            }
        } else {
            for (Frequency freq : this.getPublicCache()) {
                text.add(freq.name + " (" + freq.clientOwner + ")");
            }
        }
        this.scrollList.setText(text);
        if (this.privateMode) {
            this.publicButton.field_146124_l = true;
            this.privateButton.field_146124_l = false;
        } else {
            this.publicButton.field_146124_l = false;
            this.privateButton.field_146124_l = true;
        }
        if (this.scrollList.hasSelection()) {
            Frequency freq = this.privateMode ? this.getPrivateCache().get(this.scrollList.getSelection()) : this.getPublicCache().get(this.scrollList.getSelection());
            this.setButton.field_146124_l = this.getFrequency() == null || !this.getFrequency().equals(freq);
            this.deleteButton.field_146124_l = this.getOwner().equals(freq.ownerUUID);
        } else {
            this.setButton.field_146124_l = false;
            this.deleteButton.field_146124_l = false;
        }
        if (!this.itemStack.func_190926_b()) {
            this.teleportButton.field_146124_l = this.clientFreq != null && this.clientStatus == 1;
        }
        this.checkboxButton.field_146124_l = !this.frequencyField.func_146179_b().isEmpty();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateButtons();
        this.frequencyField.func_146178_a();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.updateButtons();
        this.frequencyField.func_146192_a(mouseX, mouseY, button);
        if (this.tileEntity != null && this.colorButton.func_146115_a() && button == 1) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(2, 1)));
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        }
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.frequencyField.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (i == 28 && this.frequencyField.func_146206_l()) {
            this.setFrequency(this.frequencyField.func_146179_b());
            this.frequencyField.func_146180_a("");
        }
        if (Character.isDigit(c) || Character.isLetter(c) || GuiTeleporter.isTextboxKey(c, i) || FrequencyManager.SPECIAL_CHARS.contains(Character.valueOf(c))) {
            this.frequencyField.func_146201_a(c, i);
        }
        this.updateButtons();
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.publicButton.field_146127_k) {
            this.privateMode = false;
        } else if (guibutton.field_146127_k == this.privateButton.field_146127_k) {
            this.privateMode = true;
        } else if (guibutton.field_146127_k == this.setButton.field_146127_k) {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency freq = this.privateMode ? this.getPrivateCache().get(selection) : this.getPublicCache().get(selection);
                this.setFrequency(freq.name);
            }
        } else if (guibutton.field_146127_k == this.deleteButton.field_146127_k) {
            int selection = this.scrollList.getSelection();
            if (selection != -1) {
                Frequency freq;
                Frequency frequency = freq = this.privateMode ? this.getPrivateCache().get(selection) : this.getPublicCache().get(selection);
                if (this.tileEntity != null) {
                    TileNetworkList data = TileNetworkList.withContents(1, freq.name, freq.publicFreq);
                    Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
                } else {
                    Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.DEL_FREQ, this.currentHand, freq));
                    Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.DATA_REQUEST, this.currentHand, null));
                }
                this.scrollList.clearSelection();
            }
        } else if (guibutton.field_146127_k == 4) {
            if (this.clientFreq != null && this.clientStatus == 1) {
                this.field_146297_k.func_71381_h();
                ClientTickHandler.portableTeleport(this.entityPlayer, this.currentHand, this.clientFreq);
            }
        } else if (guibutton.field_146127_k == this.checkboxButton.field_146127_k) {
            this.setFrequency(this.frequencyField.func_146179_b());
            this.frequencyField.func_146180_a("");
        } else if (guibutton.field_146127_k == this.colorButton.field_146127_k && this.tileEntity != null) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(2, Keyboard.isKeyDown((int)42) ? 2 : 0)));
        }
        this.updateButtons();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getName(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(this.getName()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.freq") + ":", 27, this.yStart + 67, 0x404040);
        this.field_146289_q.func_78276_b(" " + (this.getFrequency() != null ? this.getFrequency().name : (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.none")), 27 + this.field_146289_q.func_78256_a(LangUtils.localize("gui.freq") + ":"), this.yStart + 67, 0x797979);
        this.field_146289_q.func_78276_b((this.isPortable ? LangUtils.localize("gui.itemowner") : LangUtils.localize("gui.owner")) + ": " + (this.getFrequency() != null ? this.getOwnerUsername() : (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.none")), 27, this.yStart + 77, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.security") + ":", 27, this.yStart + 87, 0x404040);
        this.field_146289_q.func_78276_b(" " + (this.getFrequency() != null ? this.getSecurity(this.getFrequency()) : (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.none")), 27 + this.field_146289_q.func_78256_a(LangUtils.localize("gui.security") + ":"), this.yStart + 87, 0x797979);
        String str = LangUtils.localize("gui.set") + ":";
        this.renderScaledText(str, 27, this.yStart + 100, 0x404040, 20);
        if (this.itemStack.func_190926_b()) {
            this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 4, 0x404040);
        }
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (xAxis >= 6 && xAxis <= 24 && yAxis >= 6 && yAxis <= 24) {
            if (this.getFrequency() == null) {
                this.displayTooltip((Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.teleporter.noFreq"), xAxis, yAxis);
            } else {
                this.displayTooltip(this.getStatusDisplay(), xAxis, yAxis);
            }
        } else if (xAxis >= -21 && xAxis <= -3 && yAxis >= 116 && yAxis <= 134) {
            boolean energy;
            ArrayList<String> info = new ArrayList<String>();
            boolean bl = energy = this.getEnergy() == 0.0;
            if (energy) {
                info.add(LangUtils.localize("gui.no_energy"));
            }
            if (energy) {
                this.displayTooltips(info, xAxis, yAxis);
            }
        } else if (!this.isPortable && this.colorButton.func_146115_a() && this.tileEntity != null) {
            ArrayList<String> info = new ArrayList<String>();
            info.add(LangUtils.localize("gui.Teleportercolor"));
            info.add(LangUtils.localize("tooltip.configurator.viewColor") + ":" + ((TileEntityTeleporter)this.tileEntity).color.getColoredName());
            this.displayTooltips(info, xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        boolean energy;
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Teleporter_Icon.png"));
        int y = this.getFrequency() == null ? 72 : (this.getStatus() == 2 ? 0 : (this.getStatus() == 3 ? 18 : (this.getStatus() == 4 ? 36 : 54)));
        this.func_73729_b(this.field_147003_i + 6, this.field_147009_r + 6, 0, y, 18, 18);
        this.frequencyField.func_146194_f();
        MekanismRenderer.resetColor();
        boolean bl = energy = this.getEnergy() == 0.0;
        if (energy) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.TAB, "Warning_Info.png"));
            this.func_73729_b(this.field_147003_i - 26, this.field_147009_r + 112, 0, 0, 26, 26);
            this.addGuiElement(new GuiWarningInfo(this, this.getGuiLocation(), false));
        }
    }

    public String getStatusDisplay() {
        String string;
        switch (this.getStatus()) {
            case 1: {
                string = (Object)((Object)EnumColor.DARK_GREEN) + LangUtils.localize("gui.teleporter.ready");
                break;
            }
            case 2: {
                string = (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.teleporter.noFrame");
                break;
            }
            case 3: {
                string = (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.teleporter.noLink");
                break;
            }
            case 4: {
                string = (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.teleporter.needsEnergy");
                break;
            }
            default: {
                string = (Object)((Object)EnumColor.DARK_RED) + LangUtils.localize("gui.teleporter.noLink");
            }
        }
        return string;
    }

    private UUID getOwner() {
        if (this.tileEntity != null) {
            return ((TileEntityTeleporter)this.tileEntity).getSecurity().getOwnerUUID();
        }
        return ((IOwnerItem)this.itemStack.func_77973_b()).getOwnerUUID(this.itemStack);
    }

    private String getOwnerUsername() {
        if (this.tileEntity != null) {
            if (this.privateMode) {
                return (Object)((Object)EnumColor.BRIGHT_GREEN) + ((TileEntityTeleporter)this.tileEntity).getSecurity().getClientOwner();
            }
            return (Object)((Object)(Objects.equals(((TileEntityTeleporter)this.tileEntity).getSecurity().getClientOwner(), ((TileEntityTeleporter)this.tileEntity).frequency.clientOwner) ? EnumColor.BRIGHT_GREEN : EnumColor.DARK_RED)) + ((TileEntityTeleporter)this.tileEntity).frequency.clientOwner;
        }
        return (Object)((Object)EnumColor.BRIGHT_GREEN) + MekanismClient.clientUUIDMap.get(((IOwnerItem)this.itemStack.func_77973_b()).getOwnerUUID(this.itemStack));
    }

    private byte getStatus() {
        return this.tileEntity != null ? ((TileEntityTeleporter)this.tileEntity).status : this.clientStatus;
    }

    public void setStatus(byte status) {
        this.clientStatus = status;
    }

    private List<Frequency> getPublicCache() {
        return this.tileEntity != null ? ((TileEntityTeleporter)this.tileEntity).publicCache : this.clientPublicCache;
    }

    public void setPublicCache(List<Frequency> cache) {
        this.clientPublicCache = cache;
    }

    private List<Frequency> getPrivateCache() {
        return this.tileEntity != null ? ((TileEntityTeleporter)this.tileEntity).privateCache : this.clientPrivateCache;
    }

    public void setPrivateCache(List<Frequency> cache) {
        this.clientPrivateCache = cache;
    }

    private Frequency getFrequency() {
        return this.tileEntity != null ? ((TileEntityTeleporter)this.tileEntity).frequency : this.clientFreq;
    }

    public void setFrequency(Frequency newFrequency) {
        this.clientFreq = newFrequency;
    }

    public void setFrequency(String freq) {
        if (freq.isEmpty()) {
            return;
        }
        if (this.tileEntity != null) {
            TileNetworkList data = TileNetworkList.withContents(0, freq, !this.privateMode);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
        } else {
            Frequency newFreq = new Frequency(freq, null).setPublic(!this.privateMode);
            Mekanism.packetHandler.sendToServer(new PacketPortableTeleporter.PortableTeleporterMessage(PacketPortableTeleporter.PortableTeleporterPacketType.SET_FREQ, this.currentHand, newFreq));
        }
    }

    private String getName() {
        return this.tileEntity != null ? ((TileEntityTeleporter)this.tileEntity).func_70005_c_() : this.itemStack.func_82833_r();
    }

    private double getEnergy() {
        if (!this.itemStack.func_190926_b()) {
            return ((ItemPortableTeleporter)this.itemStack.func_77973_b()).getEnergy(this.itemStack);
        }
        return ((TileEntityTeleporter)this.tileEntity).getEnergy();
    }

    private double getMaxEnergy() {
        if (!this.itemStack.func_190926_b()) {
            return ((ItemPortableTeleporter)this.itemStack.func_77973_b()).getMaxEnergy(this.itemStack);
        }
        return ((TileEntityTeleporter)this.tileEntity).getMaxEnergy();
    }

    public boolean isStackEmpty() {
        return this.itemStack.func_190926_b();
    }
}

