/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mekanism.api.Coord4D;
import mekanism.api.RelativeSide;
import mekanism.api.transmitters.TransmissionType;
import mekanism.client.Utils.ClientUtil;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.button.GuiDisableableButton;
import mekanism.client.gui.button.GuiSideDataButton;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.tab.GuiConfigTypeTab;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.SideData;
import mekanism.common.base.ISideConfiguration;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketConfigurationUpdate;
import mekanism.common.network.PacketSimpleGui;
import mekanism.common.tile.component.SideConfig;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.LangUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiSideConfiguration
extends GuiMekanismTile<TileEntityContainerBlock> {
    private Int2ObjectMap<GuiPos> slotPosMap = new Int2ObjectOpenHashMap();
    private ISideConfiguration configurable;
    private TransmissionType currentType;
    private List<GuiConfigTypeTab> configTabs = new ArrayList<GuiConfigTypeTab>();
    private List<GuiSideDataButton> sideDataButtons = new ArrayList<GuiSideDataButton>();
    private GuiDisableableButton backButton;
    private GuiDisableableButton autoEjectButton;
    private GuiDisableableButton clearButton;
    private int buttonID = 0;

    public GuiSideConfiguration(EntityPlayer player, ISideConfiguration tile) {
        super((TileEntityContainerBlock)((Object)tile), new ContainerNull(player, (TileEntityContainerBlock)((Object)tile)));
        this.field_146999_f = 156;
        this.field_147000_g = 135;
        this.configurable = tile;
        ResourceLocation resource = this.getGuiLocation();
        for (TransmissionType type : this.configurable.getConfig().getTransmissions()) {
            GuiConfigTypeTab tab = new GuiConfigTypeTab(this, type, resource);
            this.addGuiElement(tab);
            this.configTabs.add(tab);
        }
        this.currentType = this.getTopTransmission();
        this.updateTabs();
        this.slotPosMap.put(0, (Object)new GuiPos(68, 92, RelativeSide.BOTTOM));
        this.slotPosMap.put(1, (Object)new GuiPos(68, 46, RelativeSide.TOP));
        this.slotPosMap.put(2, (Object)new GuiPos(68, 69, RelativeSide.FRONT));
        this.slotPosMap.put(3, (Object)new GuiPos(45, 92, RelativeSide.BACK));
        this.slotPosMap.put(4, (Object)new GuiPos(45, 69, RelativeSide.LEFT));
        this.slotPosMap.put(5, (Object)new GuiPos(91, 69, RelativeSide.RIGHT));
        this.addGuiElement(new GuiInnerScreen(this, resource, 41, 25, 74, 12));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.backButton = new GuiDisableableButton(this.buttonID++, this.field_147003_i + 6, this.field_147009_r + 6, 14).with(GuiDisableableButton.ImageOverlay.BACK);
        this.field_146292_n.add(this.backButton);
        this.autoEjectButton = new GuiDisableableButton(this.buttonID++, this.field_147003_i + 136, this.field_147009_r + 6, 14).with(GuiDisableableButton.ImageOverlay.AUTO_EJECT);
        this.field_146292_n.add(this.autoEjectButton);
        for (int i = 0; i < this.slotPosMap.size(); ++i) {
            GuiPos guiPos = (GuiPos)this.slotPosMap.get(i);
            EnumFacing facing = EnumFacing.func_82600_a((int)i);
            RelativeSide side = RelativeSide.bydex(i);
            GuiSideDataButton button = new GuiSideDataButton(this.buttonID++, this.field_147003_i + guiPos.xPos, this.field_147009_r + guiPos.yPos, i, () -> this.configurable.getConfig().getOutput(this.currentType, facing), () -> this.configurable.getConfig().getOutput((TransmissionType)this.currentType, (EnumFacing)facing).color, this.tileEntity, side);
            this.field_146292_n.add(button);
            this.sideDataButtons.add(button);
        }
        this.clearButton = new GuiDisableableButton(this.buttonID++, this.field_147003_i + 136, this.field_147009_r + 95, 14).with(GuiDisableableButton.ImageOverlay.CLEAR_SIDES);
        this.field_146292_n.add(this.clearButton);
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        TileEntity tile = (TileEntity)this.configurable;
        if (guibutton.field_146127_k == this.backButton.field_146127_k) {
            int guiId = Mekanism.proxy.getGuiId(tile.func_145838_q(), tile.func_145832_p());
            Mekanism.packetHandler.sendToServer(new PacketSimpleGui.SimpleGuiMessage(Coord4D.get(tile), 0, guiId));
        } else if (guibutton.field_146127_k == this.autoEjectButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.EJECT, Coord4D.get(tile), 0, 0, this.currentType));
        } else if (guibutton.field_146127_k == this.clearButton.field_146127_k) {
            for (int i = 0; i < this.slotPosMap.size(); ++i) {
                Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.SIDE_DATA, Coord4D.get(tile), 2, i, this.currentType));
            }
        } else {
            for (GuiSideDataButton button : this.sideDataButtons) {
                if (guibutton.field_146127_k != button.field_146127_k) continue;
                Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.SIDE_DATA, Coord4D.get(tile), Keyboard.isKeyDown((int)42) ? 2 : 0, button.getSlotPosMapIndex(), this.currentType));
                break;
            }
        }
    }

    public TransmissionType getTopTransmission() {
        return this.configurable.getConfig().getTransmissions().get(0);
    }

    public void setCurrentType(TransmissionType type) {
        this.currentType = type;
    }

    public void updateTabs() {
        int rendered = 0;
        for (GuiConfigTypeTab tab : this.configTabs) {
            tab.setVisible(this.currentType != tab.getTransmissionType());
            if (tab.isVisible()) {
                tab.setLeft(rendered >= 0 && rendered <= 3);
                tab.setY(2 + rendered % 4 * 28);
            }
            ++rendered;
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        String title = this.currentType.localize() + " " + LangUtils.localize("gui.config");
        this.field_146289_q.func_78276_b(title, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(title) / 2, 5, 0x404040);
        if (this.configurable.getConfig().canEject(this.currentType)) {
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.eject") + ": " + LangUtils.transOnOff(this.configurable.getConfig().isEjecting(this.currentType)), 43, 27, -12779878);
        } else {
            this.field_146289_q.func_78276_b(LangUtils.localize("gui.noEject"), 43, 27, -12779878);
        }
        String slots = LangUtils.localize("gui.slots");
        this.field_146289_q.func_78276_b(slots, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(slots) / 2, 120, 0x787878);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        for (GuiSideDataButton button : this.sideDataButtons) {
            if (!button.func_146115_a()) continue;
            SideData data = button.getSideData();
            if (data == TileComponentConfig.EMPTY) break;
            ArrayList<String> info = new ArrayList<String>();
            for (int i = 0; i < this.slotPosMap.size(); ++i) {
                GuiPos guiPos = (GuiPos)this.slotPosMap.get(i);
                String FacingName = guiPos.FacingName.getTranslationKey();
                if (button.getSlotPosMapIndex() != i) continue;
                info.add(FacingName);
            }
            info.add((Object)((Object)data.color) + data.localize());
            if (button.getItem() != ItemStack.field_190927_a && button.getItem().func_77973_b() != Items.field_190931_a) {
                info.add(button.getItem().func_77973_b().func_77653_i(button.getItem()));
            }
            this.displayTooltips(info, xAxis, yAxis);
            break;
        }
        if (this.autoEjectButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.autoEject"), xAxis, yAxis);
        }
        if (this.clearButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.clear"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        for (int i = 0; i < this.slotPosMap.size(); ++i) {
            GuiPos guiPos = (GuiPos)this.slotPosMap.get(i);
            if (this.sideDataButtons.get(i).getItem() == ItemStack.field_190927_a) continue;
            ClientUtil.renderItem(this.sideDataButtons.get(i).getItem(), this.field_147003_i + guiPos.xPos + 3, this.field_147009_r + guiPos.yPos + 3);
        }
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
    }

    public void func_73876_c() {
        super.func_73876_c();
        TileEntity tile = (TileEntity)this.configurable;
        if (tile == null || this.field_146297_k.field_71441_e.func_175625_s(tile.func_174877_v()) == null) {
            this.field_146297_k.func_147108_a(null);
        }
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        this.autoEjectButton.field_146124_l = this.configurable.getConfig().canEject(this.currentType);
        for (GuiSideDataButton sideDataButton : this.sideDataButtons) {
            SideConfig sideConfig = this.configurable.getConfig().getConfig(this.currentType);
            int n = 0;
            EnumFacing[] enumFacingArray = EnumFacing.values();
            int n2 = enumFacingArray.length;
            if (n >= n2) continue;
            EnumFacing facing = enumFacingArray[n];
            sideDataButton.field_146124_l = sideConfig.get(facing) != -1;
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        if (button == 1) {
            for (GuiSideDataButton sideDataButton : this.sideDataButtons) {
                if (!sideDataButton.func_146115_a()) continue;
                SoundHandler.playSound(SoundEvents.field_187909_gi);
                Mekanism.packetHandler.sendToServer(new PacketConfigurationUpdate.ConfigurationUpdateMessage(PacketConfigurationUpdate.ConfigurationPacket.SIDE_DATA, Coord4D.get((TileEntity)this.configurable), 1, sideDataButton.getSlotPosMapIndex(), this.currentType));
                break;
            }
        }
    }

    public static class GuiPos {
        public final int xPos;
        public final int yPos;
        public final RelativeSide FacingName;

        public GuiPos(int x, int y, RelativeSide name) {
            this.xPos = x;
            this.yPos = y;
            this.FacingName = name;
        }
    }
}

