/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import mekanism.api.Coord4D;
import mekanism.client.Utils.ClientUtil;
import mekanism.client.gui.button.GuiDisableableButton;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import org.lwjgl.util.ReadableRectangle;
import org.lwjgl.util.Rectangle;

@SideOnly(value=Side.CLIENT)
public class GuiSeismicReader
extends GuiScreen {
    private final ItemStack itemStack;
    private Coord4D pos;
    private int xSize = 147;
    private int ySize = 182;
    private World worldObj;
    private List<Pair<Integer, Block>> blockList = new ArrayList<Pair<Integer, Block>>();
    private Rectangle tooltip;
    private GuiDisableableButton upButton;
    private GuiDisableableButton downButton;
    private int currentLayer;

    public GuiSeismicReader(World world, Coord4D coord, ItemStack stack) {
        this.pos = new Coord4D(coord.x, Math.min(255, coord.y), coord.z, world.field_73011_w.getDimension());
        this.worldObj = world;
        this.itemStack = stack;
        this.calculate();
        this.currentLayer = Math.max(0, this.blockList.size() - 1);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int guiLeft = (this.field_146294_l - this.xSize) / 2;
        int guiTop = (this.field_146295_m - this.ySize) / 2;
        this.upButton = new GuiDisableableButton(0, guiLeft + 57, guiTop + 74, 14, 14).with(GuiDisableableButton.ImageOverlay.UP);
        this.field_146292_n.add(this.upButton);
        this.downButton = new GuiDisableableButton(1, guiLeft + 57, guiTop + 92, 14, 14).with(GuiDisableableButton.ImageOverlay.DOWN);
        this.field_146292_n.add(this.downButton);
        this.tooltip = new Rectangle(guiLeft + 92, guiTop + 82, 16, 16);
        this.updateEnabledButtons();
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        this.upButton.field_146124_l = this.currentLayer + 1 <= this.blockList.size() - 1;
        this.downButton.field_146124_l = this.currentLayer - 1 >= 1;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        int guiLeft = (this.field_146294_l - this.xSize) / 2;
        int guiTop = (this.field_146295_m - this.ySize) / 2;
        this.field_146297_k.field_71446_o.func_110577_a(this.getGuiLocation());
        this.func_73729_b(guiLeft, guiTop, 0, 0, this.xSize, this.ySize);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(guiLeft + 111), (float)(guiTop + 87), (float)0.0f);
        if (this.currentLayer >= 100) {
            GlStateManager.func_179109_b((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
        }
        this.field_146289_q.func_78276_b(String.format("%s", this.currentLayer), 0, 0, 3931032);
        GlStateManager.func_179121_F();
        for (int i = 0; i < 9; ++i) {
            int centralX = guiLeft + 94;
            int centralY = guiTop + 102;
            int layer = this.currentLayer + (i - 5);
            if (0 > layer || layer >= this.blockList.size()) continue;
            Pair<Integer, Block> integerBlockPair = this.blockList.get(layer);
            ItemStack stack = new ItemStack((Block)integerBlockPair.getRight(), 1, ((Integer)integerBlockPair.getLeft()).intValue());
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(centralX - 2), (float)(centralY - i * 16 + 44), (float)0.0f);
            if (i < 4) {
                GlStateManager.func_179109_b((float)0.2f, (float)2.5f, (float)0.0f);
            }
            if (i != 4) {
                GlStateManager.func_179109_b((float)1.5f, (float)0.0f, (float)0.0f);
                GlStateManager.func_179152_a((float)0.8f, (float)0.8f, (float)0.8f);
            }
            ClientUtil.renderItem(stack, 0, 0);
            GlStateManager.func_179121_F();
        }
        int frequency = 0;
        if (this.currentLayer - 1 >= 0) {
            Pair<Integer, Block> integerBlockPair = this.blockList.get(this.currentLayer - 1);
            ItemStack nameStack = new ItemStack((Block)integerBlockPair.getRight(), 1, ((Integer)integerBlockPair.getLeft()).intValue());
            String renderString = nameStack.func_82833_r();
            String capitalised = renderString.substring(0, 1).toUpperCase() + renderString.substring(1);
            int lengthX = this.field_146289_q.func_78256_a(capitalised);
            float renderScale = lengthX > 53 ? 53.0f / (float)lengthX : 1.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(guiLeft + 10), (float)(guiTop + 16), (float)0.0f);
            GlStateManager.func_179152_a((float)renderScale, (float)renderScale, (float)renderScale);
            this.field_146289_q.func_78276_b(capitalised, 0, 0, 3931032);
            GlStateManager.func_179121_F();
            MekanismRenderer.resetColor();
            if (this.tooltip.intersects((ReadableRectangle)new Rectangle(mouseX, mouseY, 1, 1))) {
                this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_ELEMENT, "GuiTooltips.png"));
                int fontLengthX = this.field_146289_q.func_78256_a(capitalised) + 5;
                int renderX = mouseX + 10;
                int renderY = mouseY - 5;
                GlStateManager.func_179094_E();
                this.func_73729_b(renderX, renderY, 0, 0, fontLengthX, 16);
                this.func_73729_b(renderX + fontLengthX, renderY, 0, 16, 2, 16);
                this.field_146289_q.func_78276_b(capitalised, renderX + 4, renderY + 4, 3931032);
                GlStateManager.func_179121_F();
                MekanismRenderer.resetColor();
            }
            for (Pair<Integer, Block> pair : this.blockList) {
                Block block = (Block)integerBlockPair.getRight();
                if (pair.getRight() != block || !Objects.equals(pair.getLeft(), integerBlockPair.getLeft())) continue;
                ++frequency;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(guiLeft + 10), (float)(guiTop + 26), (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.abundancy") + ": " + frequency, 0, 0, 3931032);
        GlStateManager.func_179121_F();
        MekanismRenderer.resetColor();
        super.func_73863_a(mouseX, mouseY, partialTick);
    }

    public void func_146281_b() {
        super.func_146281_b();
        this.blockList.clear();
    }

    public void calculate() {
        BlockPos p = new BlockPos(this.pos.x, 0, this.pos.z);
        while (p.func_177956_o() < this.pos.y) {
            IBlockState state = this.worldObj.func_180495_p(p);
            Block block = state.func_177230_c();
            int metadata = block.func_176201_c(state);
            this.blockList.add((Pair<Integer, Block>)Pair.of((Object)metadata, (Object)block));
            p = p.func_177984_a();
        }
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.upButton.field_146127_k) {
            ++this.currentLayer;
        } else if (guibutton.field_146127_k == this.downButton.field_146127_k) {
            --this.currentLayer;
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiSeismicReader.png");
    }
}

