/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.button.GuiDisableableButton;
import mekanism.client.gui.element.GuiElementScreen;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiScrollList;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerSecurityDesk;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.security.ISecurityTile;
import mekanism.common.tile.TileEntitySecurityDesk;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiSecurityDesk
extends GuiMekanismTile<TileEntitySecurityDesk> {
    private static final List<Character> SPECIAL_CHARS = Arrays.asList(Character.valueOf('-'), Character.valueOf('|'), Character.valueOf('_'));
    private static final int MAX_LENGTH = 24;
    private GuiDisableableButton removeButton;
    private GuiDisableableButton publicButton;
    private GuiDisableableButton privateButton;
    private GuiDisableableButton trustedButton;
    private GuiDisableableButton checkboxButton;
    private GuiDisableableButton overrideButton;
    private GuiScrollList scrollList;
    private GuiTextField trustedField;

    public GuiSecurityDesk(InventoryPlayer inventory, TileEntitySecurityDesk tile) {
        super(tile, new ContainerSecurityDesk(inventory, tile));
        this.addGuiElement(new GuiElementScreen(this, this.getGuiLocation(), 13, 13, 122, 42).isFrame(true));
        this.scrollList = new GuiScrollList(this, this.getGuiLocation(), 14, 14, 120, 4);
        this.addGuiElement(this.scrollList);
        this.field_147000_g += 64;
        this.addGuiElement(new GuiPlayerSlot(this, this.getGuiLocation(), 7, 147));
        this.addGuiElement(new GuiInnerScreen(this, this.getGuiLocation(), 34, 67, 101, 13));
        this.addGuiElement(new GuiElementScreen(this, this.getGuiLocation(), 141, 13, 26, 37));
        this.addGuiElement(new GuiElementScreen(this, this.getGuiLocation(), 141, 54, 26, 34));
        this.addGuiElement(new GuiElementScreen(this, this.getGuiLocation(), 141, 92, 26, 37));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.removeButton = new GuiDisableableButton(0, this.field_147003_i + 13, this.field_147009_r + 81, 122, 20, LangUtils.localize("gui.remove"));
        this.field_146292_n.add(this.removeButton);
        this.trustedField = new GuiTextField(1, this.field_146289_q, this.field_147003_i + 35, this.field_147009_r + 69, 101, 13);
        this.trustedField.func_146203_f(24);
        this.trustedField.func_146185_a(false);
        this.publicButton = new GuiDisableableButton(2, this.field_147003_i + 13, this.field_147009_r + 113, 40, 16).with(GuiDisableableButton.ImageOverlay.PUBLIC);
        this.field_146292_n.add(this.publicButton);
        this.privateButton = new GuiDisableableButton(3, this.field_147003_i + 54, this.field_147009_r + 113, 40, 16).with(GuiDisableableButton.ImageOverlay.PRIVATE);
        this.field_146292_n.add(this.privateButton);
        this.trustedButton = new GuiDisableableButton(4, this.field_147003_i + 95, this.field_147009_r + 113, 40, 16).with(GuiDisableableButton.ImageOverlay.TRUSTED);
        this.field_146292_n.add(this.trustedButton);
        this.checkboxButton = new GuiDisableableButton(5, this.field_147003_i + 123, this.field_147009_r + 68, 11, 11).with(GuiDisableableButton.ImageOverlay.CHECKMARK);
        this.field_146292_n.add(this.checkboxButton);
        this.overrideButton = new GuiDisableableButton(6, this.field_147003_i + 146, this.field_147009_r + 59, 16, 16).with(GuiDisableableButton.ImageOverlay.EXCLAMATION);
        this.field_146292_n.add(this.overrideButton);
        this.updateButtons();
    }

    public void addTrusted(String trusted) {
        if (trusted.isEmpty()) {
            return;
        }
        TileNetworkList data = TileNetworkList.withContents(0, trusted);
        Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
    }

    public void updateButtons() {
        if (((TileEntitySecurityDesk)this.tileEntity).ownerUUID != null) {
            ArrayList<String> text = new ArrayList<String>();
            if (((TileEntitySecurityDesk)this.tileEntity).frequency != null) {
                for (String s : ((TileEntitySecurityDesk)this.tileEntity).frequency.trusted) {
                    text.add(s);
                }
            }
            this.scrollList.setText(text);
            this.removeButton.field_146124_l = this.scrollList.hasSelection();
        }
        if (((TileEntitySecurityDesk)this.tileEntity).frequency != null && ((TileEntitySecurityDesk)this.tileEntity).ownerUUID != null && ((TileEntitySecurityDesk)this.tileEntity).ownerUUID.equals(this.field_146297_k.field_71439_g.func_110124_au())) {
            this.publicButton.field_146124_l = ((TileEntitySecurityDesk)this.tileEntity).frequency.securityMode != ISecurityTile.SecurityMode.PUBLIC;
            this.privateButton.field_146124_l = ((TileEntitySecurityDesk)this.tileEntity).frequency.securityMode != ISecurityTile.SecurityMode.PRIVATE;
            this.trustedButton.field_146124_l = ((TileEntitySecurityDesk)this.tileEntity).frequency.securityMode != ISecurityTile.SecurityMode.TRUSTED;
            this.checkboxButton.field_146124_l = !this.trustedField.func_146179_b().isEmpty();
            this.overrideButton.field_146124_l = true;
        } else {
            this.publicButton.field_146124_l = false;
            this.privateButton.field_146124_l = false;
            this.trustedButton.field_146124_l = false;
            this.checkboxButton.field_146124_l = false;
            this.overrideButton.field_146124_l = false;
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateButtons();
        this.trustedField.func_146178_a();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.updateButtons();
        this.trustedField.func_146192_a(mouseX, mouseY, button);
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.trustedField.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (i == 28 && this.trustedField.func_146206_l()) {
            this.addTrusted(this.trustedField.func_146179_b());
            this.trustedField.func_146180_a("");
        }
        if (SPECIAL_CHARS.contains(Character.valueOf(c)) || Character.isDigit(c) || Character.isLetter(c) || GuiSecurityDesk.isTextboxKey(c, i)) {
            this.trustedField.func_146201_a(c, i);
        }
        this.updateButtons();
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.removeButton.field_146127_k) {
            int selection = this.scrollList.getSelection();
            if (((TileEntitySecurityDesk)this.tileEntity).frequency != null && selection != -1) {
                TileNetworkList data = TileNetworkList.withContents(1, ((TileEntitySecurityDesk)this.tileEntity).frequency.trusted.get(selection));
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
                this.scrollList.clearSelection();
            }
        } else if (guibutton.field_146127_k == this.publicButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(3, 0)));
        } else if (guibutton.field_146127_k == this.privateButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(3, 1)));
        } else if (guibutton.field_146127_k == this.trustedButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(3, 2)));
        } else if (guibutton.field_146127_k == this.checkboxButton.field_146127_k) {
            this.addTrusted(this.trustedField.func_146179_b());
            this.trustedField.func_146180_a("");
        } else if (guibutton.field_146127_k == this.overrideButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(2)));
        }
        this.updateButtons();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        String ownerText = ((TileEntitySecurityDesk)this.tileEntity).clientOwner != null ? LangUtils.localize("gui.owner") + ": " + ((TileEntitySecurityDesk)this.tileEntity).clientOwner : (Object)((Object)EnumColor.RED) + LangUtils.localize("gui.noOwner");
        this.field_146289_q.func_78276_b(((TileEntitySecurityDesk)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntitySecurityDesk)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(ownerText, this.field_146999_f - 7 - this.field_146289_q.func_78256_a(ownerText), this.field_147000_g - 96 + 2, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        String trusted = LangUtils.localize("gui.trustedPlayers");
        this.field_146289_q.func_78276_b(trusted, 74 - this.field_146289_q.func_78256_a(trusted) / 2, 57, 0x787878);
        String security = (Object)((Object)EnumColor.RED) + LangUtils.localize("gui.securityOffline");
        if (((TileEntitySecurityDesk)this.tileEntity).frequency != null) {
            security = LangUtils.localize("gui.security") + ": " + ((TileEntitySecurityDesk)this.tileEntity).frequency.securityMode.getDisplay();
        }
        this.field_146289_q.func_78276_b(security, 13, 103, 0x404040);
        this.renderScaledText(LangUtils.localize("gui.add") + ":", 13, 70, 0x404040, 20);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (((TileEntitySecurityDesk)this.tileEntity).frequency != null && this.overrideButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.securityOverride") + ": " + LangUtils.transOnOff(((TileEntitySecurityDesk)this.tileEntity).frequency.override), xAxis, yAxis);
        } else if (this.publicButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.publicMode"), xAxis, yAxis);
        } else if (this.privateButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.privateMode"), xAxis, yAxis);
        } else if (this.trustedButton.func_146115_a()) {
            this.displayTooltip(LangUtils.localize("gui.trustedMode"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.BUTTON, "Button_Icon.png"));
        this.func_73729_b(this.field_147003_i + 151, this.field_147009_r + 37, 222, 23, 6, 7);
        this.func_73729_b(this.field_147003_i + 151, this.field_147009_r + 117, 204, 24, 6, 6);
        this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BAR, "Base.png"));
        this.func_73729_b(this.field_147003_i + 146, this.field_147009_r + 18, 3, 3, 16, 16);
        this.func_73729_b(this.field_147003_i + 146, this.field_147009_r + 97, 3, 3, 16, 16);
        this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "State.png"));
        this.func_73729_b(this.field_147003_i + 144, this.field_147009_r + 77, 6, 6, 8, 8);
        if (((TileEntitySecurityDesk)this.tileEntity).frequency != null && ((TileEntitySecurityDesk)this.tileEntity).ownerUUID != null && ((TileEntitySecurityDesk)this.tileEntity).ownerUUID.equals(this.field_146297_k.field_71439_g.func_110124_au())) {
            this.func_73729_b(this.field_147003_i + 145, this.field_147009_r + 78, ((TileEntitySecurityDesk)this.tileEntity).frequency.override ? 0 : 6, 0, 6, 6);
        } else {
            this.func_73729_b(this.field_147003_i + 145, this.field_147009_r + 78, 0, 6, 6, 6);
        }
        this.trustedField.func_146194_f();
        MekanismRenderer.resetColor();
    }
}

