/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.button.GuiDisableableButton;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRateBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiWarningInfo;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.Mekanism;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.ContainerResistiveHeater;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityResistiveHeater;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiResistiveHeater
extends GuiMekanismTile<TileEntityResistiveHeater> {
    private GuiTextField energyUsageField;
    private GuiDisableableButton checkboxButton;

    public GuiResistiveHeater(InventoryPlayer inventory, TileEntityResistiveHeater tile) {
        super(tile, new ContainerResistiveHeater(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 164, 15));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.POWER, this, resource, 14, 34).with(GuiSlot.SlotOverlay.POWER));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            String multiplier = MekanismUtils.getEnergyDisplay(((TileEntityResistiveHeater)this.tileEntity).energyUsage);
            return Arrays.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityResistiveHeater)this.tileEntity).getMaxEnergy() - ((TileEntityResistiveHeater)this.tileEntity).getEnergy()));
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiHeatInfo(() -> {
            UnitDisplayUtils.TemperatureUnit unit = UnitDisplayUtils.TemperatureUnit.values()[MekanismConfig.current().general.tempUnit.val().ordinal()];
            String environment = UnitDisplayUtils.getDisplayShort(((TileEntityResistiveHeater)this.tileEntity).lastEnvironmentLoss * unit.intervalSize, false, unit);
            return Collections.singletonList(LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiRateBar(this, new GuiRateBar.IRateInfoHandler(){

            @Override
            public String getTooltip() {
                return LangUtils.localize("gui.temp") + ": " + GuiResistiveHeater.this.getTemp();
            }

            @Override
            public double getLevel() {
                return Math.min(1.0, ((TileEntityResistiveHeater)GuiResistiveHeater.this.tileEntity).temperature / MekanismConfig.current().general.evaporationMaxTemp.val());
            }
        }, resource, 153, 13));
        this.addGuiElement(new GuiPlayerSlot(this, resource));
        this.addGuiElement(new GuiInnerScreen(this, this.getGuiLocation(), 48, 23, 80, 40));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        String prevEnergyUsage = this.energyUsageField != null ? this.energyUsageField.func_146179_b() : "";
        this.energyUsageField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 61, this.field_147009_r + 52, 54, 11);
        this.energyUsageField.func_146203_f(7);
        this.energyUsageField.func_146185_a(false);
        this.energyUsageField.func_146180_a(prevEnergyUsage);
        this.energyUsageField.func_146193_g(-12779878);
        this.checkboxButton = new GuiDisableableButton(1, this.field_147003_i + 115, this.field_147009_r + 50, 11, 11).with(GuiDisableableButton.ImageOverlay.CHECKMARK_DIGITAL);
        this.field_146292_n.add(this.checkboxButton);
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.checkboxButton.field_146127_k) {
            this.setEnergyUsage();
        }
    }

    private void updateEnabledButtons() {
        this.checkboxButton.field_146124_l = !this.energyUsageField.func_146179_b().isEmpty();
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityResistiveHeater)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityResistiveHeater)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 94 + 2, 0x404040);
        this.renderScaledText(LangUtils.localize("gui.temp") + ": " + this.getTemp(), 50, 25, -12779878, 76);
        this.renderScaledText(LangUtils.localize("gui.usage") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityResistiveHeater)this.tileEntity).energyUsage) + "/t", 50, 41, -12779878, 76);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (xAxis >= -21 && xAxis <= -3 && yAxis >= 90 && yAxis <= 108) {
            boolean energy;
            ArrayList<String> info = new ArrayList<String>();
            boolean bl = energy = ((TileEntityResistiveHeater)this.tileEntity).getEnergy() == 0.0;
            if (energy) {
                info.add(LangUtils.localize("gui.no_energy"));
            }
            if (energy) {
                this.displayTooltips(info, xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        boolean energy;
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.energyUsageField.func_146194_f();
        MekanismRenderer.resetColor();
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.SWITCH, "switch_icon.png"));
        this.func_73729_b(this.field_147003_i + 53, this.field_147009_r + 53, 43, 0, 4, 7);
        boolean bl = energy = ((TileEntityResistiveHeater)this.tileEntity).getEnergy() == 0.0;
        if (energy) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.TAB, "Warning_Info.png"));
            this.func_73729_b(this.field_147003_i - 26, this.field_147009_r + 86, 0, 0, 26, 26);
            this.addGuiElement(new GuiWarningInfo(this, this.getGuiLocation(), true));
        }
    }

    private void setEnergyUsage() {
        if (!this.energyUsageField.func_146179_b().isEmpty()) {
            int toUse = Integer.parseInt(this.energyUsageField.func_146179_b());
            TileNetworkList data = TileNetworkList.withContents(toUse);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
            this.energyUsageField.func_146180_a("");
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.energyUsageField.func_146178_a();
        this.updateEnabledButtons();
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        super.func_73864_a(mouseX, mouseY, button);
        this.energyUsageField.func_146192_a(mouseX, mouseY, button);
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.energyUsageField.func_146206_l() || i == 1) {
            super.func_73869_a(c, i);
        }
        if (this.energyUsageField.func_146206_l() && i == 28) {
            this.setEnergyUsage();
            return;
        }
        if (Character.isDigit(c) || GuiResistiveHeater.isTextboxKey(c, i)) {
            this.energyUsageField.func_146201_a(c, i);
        }
    }

    private String getTemp() {
        return MekanismUtils.getTemperatureDisplay(((TileEntityResistiveHeater)this.tileEntity).getTemp(), UnitDisplayUtils.TemperatureUnit.AMBIENT);
    }
}

