/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiWarningInfo;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiSideConfigurationTab;
import mekanism.client.gui.element.tab.GuiTransporterConfigTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.common.base.IUpgradeTile;
import mekanism.common.inventory.container.ContainerPRC;
import mekanism.common.tile.machine.TileEntityPRC;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiPRC
extends GuiMekanismTile<TileEntityPRC> {
    public GuiPRC(InventoryPlayer inventory, TileEntityPRC tile) {
        super(tile, new ContainerPRC(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiSideConfigurationTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiTransporterConfigTab((IGuiWrapper)this, 34, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            double extra = ((TileEntityPRC)this.tileEntity).getRecipe() != null ? ((TileEntityPRC)this.tileEntity).getRecipe().extraEnergy : 0.0;
            String multiplier = MekanismUtils.getEnergyDisplay(MekanismUtils.getEnergyPerTick((IUpgradeTile)((Object)this.tileEntity), ((TileEntityPRC)this.tileEntity).BASE_ENERGY_PER_TICK + extra));
            return Arrays.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityPRC)this.tileEntity).getMaxEnergy() - ((TileEntityPRC)this.tileEntity).getEnergy()));
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiFluidGauge(() -> ((TileEntityPRC)this.tileEntity).inputFluidTank, GuiGauge.Type.STANDARD, this, resource, 5, 10).withColor(GuiGauge.TypeColor.YELLOW));
        this.addGuiElement(new GuiGasGauge(() -> ((TileEntityPRC)this.tileEntity).inputGasTank, GuiGauge.Type.STANDARD, this, resource, 28, 10).withColor(GuiGauge.TypeColor.RED));
        this.addGuiElement(new GuiGasGauge(() -> ((TileEntityPRC)this.tileEntity).outputGasTank, GuiGauge.Type.SMALL, this, resource, 140, 40).withColor(GuiGauge.TypeColor.BLUE));
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 164, 15));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.INPUT, this, resource, 53, 34));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.POWER, this, resource, 140, 18).with(GuiSlot.SlotOverlay.POWER));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.OUTPUT, this, resource, 115, 34));
        this.addGuiElement(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return ((TileEntityPRC)GuiPRC.this.tileEntity).getScaledProgress();
            }
        }, GuiProgress.ProgressBar.MEDIUM, this, resource, 75, 37));
        this.addGuiElement(new GuiPlayerSlot(this, resource));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityPRC)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityPRC)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (xAxis >= -21 && xAxis <= -3 && yAxis >= 116 && yAxis <= 134) {
            boolean outslot;
            ArrayList<String> info = new ArrayList<String>();
            boolean energy = ((TileEntityPRC)this.tileEntity).getEnergy() < ((TileEntityPRC)this.tileEntity).energyPerTick || ((TileEntityPRC)this.tileEntity).getEnergy() == 0.0;
            boolean inputgas = ((TileEntityPRC)this.tileEntity).inputGasTank.getStored() == 0 && ((ItemStack)((TileEntityPRC)this.tileEntity).inventory.get(0)).func_190916_E() != 0;
            boolean inputfluid = ((TileEntityPRC)this.tileEntity).inputFluidTank.getFluidAmount() == 0 && ((ItemStack)((TileEntityPRC)this.tileEntity).inventory.get(0)).func_190916_E() != 0;
            boolean outputgas = ((TileEntityPRC)this.tileEntity).outputGasTank.getStored() == ((TileEntityPRC)this.tileEntity).outputGasTank.getMaxGas();
            boolean bl = outslot = ((ItemStack)((TileEntityPRC)this.tileEntity).inventory.get(2)).func_190916_E() == ((ItemStack)((TileEntityPRC)this.tileEntity).inventory.get(2)).func_77976_d();
            if (energy) {
                info.add(LangUtils.localize("gui.no_energy"));
            }
            if (inputgas) {
                info.add(LangUtils.localize("gui.no_gas"));
            }
            if (inputfluid) {
                info.add(LangUtils.localize("gui.no_fluid"));
            }
            if (outslot) {
                info.add(LangUtils.localize("gui.item_no_space"));
            }
            if (outputgas) {
                info.add(LangUtils.localize("gui.gas_no_space"));
            }
            if (inputgas || inputfluid || energy || outslot || outputgas) {
                this.displayTooltips(info, xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        boolean outslot;
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        boolean energy = ((TileEntityPRC)this.tileEntity).getEnergy() < ((TileEntityPRC)this.tileEntity).energyPerTick || ((TileEntityPRC)this.tileEntity).getEnergy() == 0.0;
        boolean inputgas = ((TileEntityPRC)this.tileEntity).inputGasTank.getStored() == 0 && ((ItemStack)((TileEntityPRC)this.tileEntity).inventory.get(0)).func_190916_E() != 0;
        boolean inputfluid = ((TileEntityPRC)this.tileEntity).inputFluidTank.getFluidAmount() == 0 && ((ItemStack)((TileEntityPRC)this.tileEntity).inventory.get(0)).func_190916_E() != 0;
        boolean outputgas = ((TileEntityPRC)this.tileEntity).outputGasTank.getStored() == ((TileEntityPRC)this.tileEntity).outputGasTank.getMaxGas();
        boolean bl = outslot = ((ItemStack)((TileEntityPRC)this.tileEntity).inventory.get(2)).func_190916_E() == ((ItemStack)((TileEntityPRC)this.tileEntity).inventory.get(2)).func_77976_d();
        if (inputgas) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Warning.png"));
            this.func_73729_b(this.field_147003_i + 28 + 9, this.field_147009_r + 10 + 1, 9, 1, 8, 29);
            this.func_73729_b(this.field_147003_i + 28 + 9, this.field_147009_r + 10 + 31, 9, 32, 8, 28);
        }
        if (inputfluid) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Warning.png"));
            this.func_73729_b(this.field_147003_i + 5 + 9, this.field_147009_r + 10 + 1, 9, 1, 8, 29);
            this.func_73729_b(this.field_147003_i + 5 + 9, this.field_147009_r + 10 + 31, 9, 32, 8, 28);
        }
        if (outputgas) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Warning.png"));
            this.func_73729_b(this.field_147003_i + 140 + 10, this.field_147009_r + 40 + 1, 0, 0, 7, 28);
        }
        if (outslot) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.SLOT, "Slot_Icon.png"));
            this.func_73729_b(this.field_147003_i + 115, this.field_147009_r + 34, 158, 0, 18, 18);
        }
        if (outslot || inputfluid || outputgas || inputgas || energy) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.TAB, "Warning_Info.png"));
            this.func_73729_b(this.field_147003_i - 26, this.field_147009_r + 112, 0, 0, 26, 26);
            this.addGuiElement(new GuiWarningInfo(this, this.getGuiLocation(), false));
        }
    }
}

