/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.api.TileNetworkList;
import mekanism.client.gui.GuiFilterHolder;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.button.GuiColorButton;
import mekanism.client.gui.button.GuiDisableableButton;
import mekanism.client.gui.element.GuiElementScreen;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.client.sound.SoundHandler;
import mekanism.common.HashList;
import mekanism.common.Mekanism;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.IOreDictFilter;
import mekanism.common.content.transporter.TransporterFilter;
import mekanism.common.inventory.container.ContainerNull;
import mekanism.common.network.PacketLogisticalSorterGui;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityLogisticalSorter;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiLogisticalSorter
extends GuiFilterHolder<TileEntityLogisticalSorter, TransporterFilter> {
    private GuiDisableableButton singleItemButton;
    private GuiDisableableButton roundRobinButton;
    private GuiDisableableButton autoEjectButton;
    private GuiColorButton colorButton;

    public GuiLogisticalSorter(EntityPlayer player, TileEntityLogisticalSorter tile) {
        super(tile, new ContainerNull(player, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiInnerScreen(this, resource, 9, 17, 46, 140));
        this.addGuiElement(new GuiElementScreen(this, resource, 55, 17, 98, 118));
        this.addGuiElement(new GuiElementScreen(this, resource, 55, 135, 98, 22));
        this.addGuiElement(new GuiElementScreen(this, resource, 153, 17, 14, 140));
    }

    private boolean overUpArrow(int xAxis, int yAxis, int arrowX, int yStart) {
        return xAxis >= arrowX && xAxis <= arrowX + 10 && yAxis >= yStart + 1 && yAxis <= yStart + 7;
    }

    private boolean overDownArrow(int xAxis, int yAxis, int arrowX, int yStart) {
        return xAxis >= arrowX && xAxis <= arrowX + 10 && yAxis >= yStart + 21 && yAxis <= yStart + 27;
    }

    @Override
    protected HashList<TransporterFilter> getFilters() {
        return ((TileEntityLogisticalSorter)this.tileEntity).filters;
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseBtn) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseBtn);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (mouseBtn == 0) {
            if (xAxis >= 154 && xAxis <= 166 && yAxis >= this.getScroll() + 18 && yAxis <= this.getScroll() + 18 + 15) {
                if (this.needsScrollBars()) {
                    this.dragOffset = yAxis - (this.getScroll() + 18);
                    this.isDragging = true;
                } else {
                    this.scroll = 0.0f;
                }
            }
            for (int i = 0; i < 4; ++i) {
                int index = this.getFilterIndex() + i;
                IFilter filter = ((TileEntityLogisticalSorter)this.tileEntity).filters.get(index);
                if (filter == null) continue;
                int yStart = i * 29 + 18;
                if (xAxis < 56 || xAxis > 152 || yAxis < yStart || yAxis > yStart + 29) continue;
                int arrowX = 140;
                if (index > 0 && this.overUpArrow(xAxis, yAxis, arrowX, yStart)) {
                    this.sendDataFromClick(TileNetworkList.withContents(3, index));
                    return;
                }
                if (index < ((TileEntityLogisticalSorter)this.tileEntity).filters.size() - 1 && this.overDownArrow(xAxis, yAxis, arrowX, yStart)) {
                    this.sendDataFromClick(TileNetworkList.withContents(4, index));
                    return;
                }
                if (filter instanceof IItemStackFilter) {
                    this.sendPacket(PacketLogisticalSorterGui.SorterGuiPacket.SERVER_INDEX, 1, index, SoundEvents.field_187909_gi);
                    continue;
                }
                if (filter instanceof IOreDictFilter) {
                    this.sendPacket(PacketLogisticalSorterGui.SorterGuiPacket.SERVER_INDEX, 2, index, SoundEvents.field_187909_gi);
                    continue;
                }
                if (filter instanceof IMaterialFilter) {
                    this.sendPacket(PacketLogisticalSorterGui.SorterGuiPacket.SERVER_INDEX, 3, index, SoundEvents.field_187909_gi);
                    continue;
                }
                if (!(filter instanceof IModIDFilter)) continue;
                this.sendPacket(PacketLogisticalSorterGui.SorterGuiPacket.SERVER_INDEX, 5, index, SoundEvents.field_187909_gi);
            }
        }
        if (this.colorButton.func_146115_a() && mouseBtn == 1) {
            this.sendDataFromClick(TileNetworkList.withContents(0, 1));
        }
    }

    private void sendPacket(PacketLogisticalSorterGui.SorterGuiPacket type, int guiID, int extra, @Nullable SoundEvent sound) {
        Mekanism.packetHandler.sendToServer(new PacketLogisticalSorterGui.LogisticalSorterGuiMessage(type, Coord4D.get(this.tileEntity), guiID, extra, 0));
        if (sound != null) {
            SoundHandler.playSound(sound);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiDisableableButton(0, this.field_147003_i + 56, this.field_147009_r + 136, 96, 20, LangUtils.localize("gui.newFilter")));
        this.singleItemButton = new GuiDisableableButton(1, this.field_147003_i + 12, this.field_147009_r + 58, 14, 14).with(GuiDisableableButton.ImageOverlay.SINGLE);
        this.field_146292_n.add(this.singleItemButton);
        this.roundRobinButton = new GuiDisableableButton(2, this.field_147003_i + 12, this.field_147009_r + 84, 14, 14).with(GuiDisableableButton.ImageOverlay.ROUND_ROBIN);
        this.field_146292_n.add(this.roundRobinButton);
        this.autoEjectButton = new GuiDisableableButton(3, this.field_147003_i + 12, this.field_147009_r + 110, 14, 14).with(GuiDisableableButton.ImageOverlay.AUTO_EJECT);
        this.field_146292_n.add(this.autoEjectButton);
        this.colorButton = new GuiColorButton(4, this.field_147003_i + 13, this.field_147009_r + 137, () -> ((TileEntityLogisticalSorter)this.tileEntity).color);
        this.field_146292_n.add(this.colorButton);
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 0) {
            this.sendPacket(PacketLogisticalSorterGui.SorterGuiPacket.SERVER, 4, 0, null);
        } else if (guibutton.field_146127_k == this.singleItemButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(5)));
        } else if (guibutton.field_146127_k == this.roundRobinButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(2)));
        } else if (guibutton.field_146127_k == this.autoEjectButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(1)));
        } else if (guibutton.field_146127_k == this.colorButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(0, Keyboard.isKeyDown((int)42) ? 2 : 0)));
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        this.field_146289_q.func_78276_b(((TileEntityLogisticalSorter)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityLogisticalSorter)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.filters") + ":", 11, 19, 52480);
        this.field_146289_q.func_78276_b("T: " + ((TileEntityLogisticalSorter)this.tileEntity).filters.size(), 11, 28, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("mekanism.gui.logisticalSorter.singleItem") + ":", 12, 48, 52480);
        this.field_146289_q.func_78276_b(LangUtils.transOnOff(((TileEntityLogisticalSorter)this.tileEntity).singleItem), 27, 60, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("mekanism.gui.logisticalSorter.roundRobin") + ":", 12, 74, 52480);
        this.field_146289_q.func_78276_b(LangUtils.transOnOff(((TileEntityLogisticalSorter)this.tileEntity).roundRobin), 27, 86, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("mekanism.gui.logisticalSorter.autoEject") + ":", 12, 100, 52480);
        this.field_146289_q.func_78276_b(LangUtils.transOnOff(((TileEntityLogisticalSorter)this.tileEntity).autoEject), 27, 112, 52480);
        this.field_146289_q.func_78276_b(LangUtils.localize("mekanism.gui.logisticalSorter.default") + ":", 12, 126, 52480);
        for (int i = 0; i < 4; ++i) {
            if (((TileEntityLogisticalSorter)this.tileEntity).filters.get(this.getFilterIndex() + i) == null) continue;
            TransporterFilter filter = ((TileEntityLogisticalSorter)this.tileEntity).filters.get(this.getFilterIndex() + i);
            int yStart = i * 29 + 18;
            if (filter instanceof IItemStackFilter) {
                IItemStackFilter itemFilter = (IItemStackFilter)((Object)filter);
                this.renderItem(itemFilter.getItemStack(), 59, yStart + 3);
                this.field_146289_q.func_78276_b(LangUtils.localize("gui.itemFilter"), 78, yStart + 2, 0x404040);
                this.field_146289_q.func_78276_b(filter.color != null ? filter.color.getColoredName() : LangUtils.localize("gui.none"), 78, yStart + 11, 0x404040);
            } else if (filter instanceof IOreDictFilter) {
                IOreDictFilter oreFilter = (IOreDictFilter)((Object)filter);
                if (!this.oreDictStacks.containsKey(oreFilter)) {
                    this.updateStackList(oreFilter);
                }
                this.renderItem(((GuiFilterHolder.StackData)this.oreDictStacks.get((Object)filter)).renderStack, 59, yStart + 3);
                this.field_146289_q.func_78276_b(LangUtils.localize("gui.oredictFilter"), 78, yStart + 2, 0x404040);
                this.field_146289_q.func_78276_b(filter.color != null ? filter.color.getColoredName() : LangUtils.localize("gui.none"), 78, yStart + 11, 0x404040);
            } else if (filter instanceof IMaterialFilter) {
                IMaterialFilter itemFilter = (IMaterialFilter)((Object)filter);
                this.renderItem(itemFilter.getMaterialItem(), 59, yStart + 3);
                this.field_146289_q.func_78276_b(LangUtils.localize("gui.materialFilter"), 78, yStart + 2, 0x404040);
                this.field_146289_q.func_78276_b(filter.color != null ? filter.color.getColoredName() : LangUtils.localize("gui.none"), 78, yStart + 11, 0x404040);
            } else if (filter instanceof IModIDFilter) {
                IModIDFilter modFilter = (IModIDFilter)((Object)filter);
                if (!this.modIDStacks.containsKey(modFilter)) {
                    this.updateStackList(modFilter);
                }
                this.renderItem(((GuiFilterHolder.StackData)this.modIDStacks.get((Object)filter)).renderStack, 59, yStart + 3);
                this.field_146289_q.func_78276_b(LangUtils.localize("gui.modIDFilter"), 78, yStart + 2, 0x404040);
                this.field_146289_q.func_78276_b(filter.color != null ? filter.color.getColoredName() : LangUtils.localize("gui.none"), 78, yStart + 11, 0x404040);
            }
            int arrowX = 140;
            if (this.getFilterIndex() + i > 0 && this.overUpArrow(xAxis, yAxis, arrowX, yStart)) {
                this.displayTooltip(LangUtils.localize("gui.moveUp"), xAxis, yAxis);
            }
            if (this.getFilterIndex() + i >= ((TileEntityLogisticalSorter)this.tileEntity).filters.size() - 1 || !this.overDownArrow(xAxis, yAxis, arrowX, yStart)) continue;
            this.displayTooltip(LangUtils.localize("gui.moveDown"), xAxis, yAxis);
        }
        if (this.colorButton.func_146115_a()) {
            if (((TileEntityLogisticalSorter)this.tileEntity).color != null) {
                this.displayTooltip(((TileEntityLogisticalSorter)this.tileEntity).color.getColoredName(), xAxis, yAxis);
            } else {
                this.displayTooltip(LangUtils.localize("gui.none"), xAxis, yAxis);
            }
        } else if (this.autoEjectButton.func_146115_a()) {
            this.displayTooltips(MekanismUtils.splitTooltip(LangUtils.localize("mekanism.gui.logisticalSorter.autoEject.tooltip"), ItemStack.field_190927_a), xAxis, yAxis);
        } else if (this.roundRobinButton.func_146115_a()) {
            this.displayTooltips(MekanismUtils.splitTooltip(LangUtils.localize("mekanism.gui.logisticalSorter.roundRobin.tooltip"), ItemStack.field_190927_a), xAxis, yAxis);
        } else if (this.singleItemButton.func_146115_a()) {
            this.displayTooltips(MekanismUtils.splitTooltip(LangUtils.localize("mekanism.gui.logisticalSorter.singleItem.tooltip"), ItemStack.field_190927_a), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }
}

