/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import mekanism.api.TileNetworkList;
import mekanism.api.gas.GasStack;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.button.GuiDisableableButton;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiPlayerArmmorSlot;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiUtils;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiSideConfigurationTab;
import mekanism.client.gui.element.tab.GuiTransporterConfigTab;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerGasTank;
import mekanism.common.item.ItemGaugeDropper;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.util.LangUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiGasTank
extends GuiMekanismTile<TileEntityGasTank> {
    public GuiDisableableButton mode;

    public GuiGasTank(InventoryPlayer inventory, TileEntityGasTank tile) {
        super(tile, new ContainerGasTank(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiSideConfigurationTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiTransporterConfigTab((IGuiWrapper)this, 34, this.tileEntity, resource));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.INPUT, this, resource, 15, 16).with(GuiSlot.SlotOverlay.PLUS));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.OUTPUT, this, resource, 15, 46).with(GuiSlot.SlotOverlay.MINUS));
        this.addGuiElement(new GuiInnerScreen(this, resource, 42, 37, 118, 27));
        this.addGuiElement(new GuiPlayerSlot(this, resource));
        this.addGuiElement(new GuiPlayerArmmorSlot(this, resource, -26, 62, true));
        this.addGuiElement(new GuiBar(this, this.getGuiLocation(), 42, 16, 118, 12));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        String stored = "" + (((TileEntityGasTank)this.tileEntity).gasTank.getStored() == Integer.MAX_VALUE ? LangUtils.localize("gui.infinite") : Integer.valueOf(((TileEntityGasTank)this.tileEntity).gasTank.getStored()));
        String capacityInfo = stored + " / " + (((TileEntityGasTank)this.tileEntity).tier.getStorage() == Integer.MAX_VALUE ? LangUtils.localize("gui.infinite") : Integer.valueOf(((TileEntityGasTank)this.tileEntity).tier.getStorage()));
        this.field_146289_q.func_78276_b(((TileEntityGasTank)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityGasTank)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        this.renderScaledText(LangUtils.localize("gui.gas") + ": " + (((TileEntityGasTank)this.tileEntity).gasTank.getGas() != null ? ((TileEntityGasTank)this.tileEntity).gasTank.getGas().getGas().getLocalizedName() : LangUtils.localize("gui.none")), 45, 40, 0x33FF99, 112);
        this.field_146289_q.func_78276_b(capacityInfo, 45, 49, 0x33FF99);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        String name = LangUtils.localize(((TileEntityGasTank)this.tileEntity).dumping.getLangKey());
        this.field_146289_q.func_78276_b(name, 156 - this.field_146289_q.func_78256_a(name), 73, 0x404040);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (xAxis >= 42 && xAxis <= 160 && yAxis >= 16 && yAxis <= 28) {
            this.displayTooltip(((TileEntityGasTank)this.tileEntity).gasTank.getGas() != null ? ((TileEntityGasTank)this.tileEntity).gasTank.getGas().getGas().getLocalizedName() + ": " + (((TileEntityGasTank)this.tileEntity).gasTank.getStored() == Integer.MAX_VALUE ? LangUtils.localize("gui.infinite") : Integer.valueOf(((TileEntityGasTank)this.tileEntity).gasTank.getStored())) : LangUtils.localize("gui.none"), xAxis, yAxis);
        }
        super.func_146979_b(mouseX, mouseY);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.mode = new GuiDisableableButton(0, this.field_147003_i + 159, this.field_147009_r + 72, 10, 10, () -> ((TileEntityGasTank)this.tileEntity).dumping.ordinal()).with(GuiDisableableButton.ImageOverlay.GAS_MOD);
        this.field_146292_n.add(this.mode);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        GasStack gas = ((TileEntityGasTank)this.tileEntity).gasTank.getGas();
        if (gas != null) {
            MekanismRenderer.color(gas);
            int scale = (int)((double)((TileEntityGasTank)this.tileEntity).gasTank.getStored() / (double)((TileEntityGasTank)this.tileEntity).tier.getStorage() * 116.0);
            GuiUtils.drawGasBarSprite(this.field_147003_i + 42, this.field_147009_r + 16, 118, 12, scale, gas, false);
            MekanismRenderer.resetColor();
        }
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.mode.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(0)));
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        if (button == 0 || Keyboard.isKeyDown((int)42)) {
            ItemStack stack;
            int xAxis = x - this.field_147003_i;
            int yAxis = y - this.field_147009_r;
            if (xAxis >= 42 && xAxis <= 160 && yAxis >= 16 && yAxis <= 28 && !(stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o()).func_190926_b() && stack.func_77973_b() instanceof ItemGaugeDropper) {
                TileNetworkList data = TileNetworkList.withContents(1);
                Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
                SoundHandler.playSound(SoundEvents.field_187909_gi);
            }
        }
    }
}

