/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.Collections;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiHeatInfo;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiRateBar;
import mekanism.client.gui.element.GuiRateBarHorizontal;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.common.config.MekanismConfig;
import mekanism.common.inventory.container.ContainerFuelwoodHeater;
import mekanism.common.tile.TileEntityFuelwoodHeater;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiFuelwoodHeater
extends GuiMekanismTile<TileEntityFuelwoodHeater> {
    public GuiFuelwoodHeater(InventoryPlayer inventory, TileEntityFuelwoodHeater tile) {
        super(tile, new ContainerFuelwoodHeater(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 14, 28));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiHeatInfo(() -> {
            UnitDisplayUtils.TemperatureUnit unit = UnitDisplayUtils.TemperatureUnit.values()[MekanismConfig.current().general.tempUnit.val().ordinal()];
            String environment = UnitDisplayUtils.getDisplayShort(((TileEntityFuelwoodHeater)this.tileEntity).lastEnvironmentLoss * unit.intervalSize, false, unit);
            return Collections.singletonList(LangUtils.localize("gui.dissipated") + ": " + environment + "/t");
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiInnerScreen(this, resource, 48, 23, 80, 28));
        this.addGuiElement(new GuiRateBar(this, new GuiRateBar.IRateInfoHandler(){

            @Override
            public String getTooltip() {
                return LangUtils.localize("gui.temp") + ": " + GuiFuelwoodHeater.this.getTemp();
            }

            @Override
            public double getLevel() {
                return Math.min(1.0, ((TileEntityFuelwoodHeater)GuiFuelwoodHeater.this.tileEntity).temperature / MekanismConfig.current().general.evaporationMaxTemp.val());
            }
        }, resource, 161, 11));
        this.addGuiElement(new GuiRateBarHorizontal(this, new GuiRateBarHorizontal.IRateInfoHandler(){

            @Override
            public String getTooltip() {
                return LangUtils.localize("gui.fuel") + ": " + ((TileEntityFuelwoodHeater)GuiFuelwoodHeater.this.tileEntity).burnTime + " / " + ((TileEntityFuelwoodHeater)GuiFuelwoodHeater.this.tileEntity).maxBurnTime;
            }

            @Override
            public double getLevel() {
                return (double)((TileEntityFuelwoodHeater)GuiFuelwoodHeater.this.tileEntity).burnTime / (double)((TileEntityFuelwoodHeater)GuiFuelwoodHeater.this.tileEntity).maxBurnTime;
            }
        }, resource, 46, 60));
        this.addGuiElement(new GuiPlayerSlot(this, resource));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityFuelwoodHeater)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityFuelwoodHeater)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 94 + 2, 0x404040);
        this.renderScaledText(LangUtils.localize("gui.temp") + ": " + this.getTemp(), 50, 25, -12779878, 76);
        this.renderScaledText(LangUtils.localize("gui.fuel") + ": " + ((TileEntityFuelwoodHeater)this.tileEntity).burnTime, 50, 41, -12779878, 76);
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.PROGRESS, "Progress_Icon.png"));
        this.func_73729_b(this.field_147003_i + 137, this.field_147009_r + 29, 1, 14, 14, 14);
        if (((TileEntityFuelwoodHeater)this.tileEntity).burnTime > 0) {
            int displayInt = ((TileEntityFuelwoodHeater)this.tileEntity).burnTime * 13 / ((TileEntityFuelwoodHeater)this.tileEntity).maxBurnTime;
            this.func_73729_b(this.field_147003_i + 137, this.field_147009_r + 29 + 12 - displayInt, 18, 26 - displayInt, 14, displayInt + 1);
        }
    }

    private String getTemp() {
        return MekanismUtils.getTemperatureDisplay(((TileEntityFuelwoodHeater)this.tileEntity).getTemp(), UnitDisplayUtils.TemperatureUnit.AMBIENT);
    }
}

