/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.button.GuiDisableableButton;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiProgress;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiWarningInfo;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiSideConfigurationTab;
import mekanism.client.gui.element.tab.GuiTransporterConfigTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerFormulaicAssemblicator;
import mekanism.common.item.ItemCraftingFormula;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.machine.TileEntityFormulaicAssemblicator;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiFormulaicAssemblicator
extends GuiMekanismTile<TileEntityFormulaicAssemblicator> {
    private GuiButton encodeFormulaButton;
    private GuiButton stockControlButton;
    private GuiButton fillEmptyButton;
    private GuiButton craftSingleButton;
    private GuiButton craftAvailableButton;
    private GuiButton autoModeButton;

    public GuiFormulaicAssemblicator(InventoryPlayer inventory, TileEntityFormulaicAssemblicator tile) {
        super(tile, new ContainerFormulaicAssemblicator(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSideConfigurationTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiTransporterConfigTab((IGuiWrapper)this, 34, this.tileEntity, resource));
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 159, 15));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            String multiplier = MekanismUtils.getEnergyDisplay(((TileEntityFormulaicAssemblicator)this.tileEntity).energyPerTick);
            return Arrays.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityFormulaicAssemblicator)this.tileEntity).getMaxEnergy() - ((TileEntityFormulaicAssemblicator)this.tileEntity).getEnergy()));
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.POWER, this, resource, 151, 75).with(GuiSlot.SlotOverlay.POWER));
        this.field_147000_g += 64;
        this.addGuiElement(new GuiPlayerSlot(this, resource, 7, 147));
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addGuiElement(new GuiSlot(GuiSlot.SlotType.INPUT, this, resource, 7 + x * 18, 97 + y * 18));
            }
        }
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, this.getGuiLocation(), 25 + x * 18, 16 + y * 18));
            }
        }
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.OUTPUT_LARGE_WIDE, this, this.getGuiLocation(), 115, 16));
        this.addGuiElement(new GuiProgress(new GuiProgress.IProgressInfoHandler(){

            @Override
            public double getProgress() {
                return (double)((TileEntityFormulaicAssemblicator)GuiFormulaicAssemblicator.this.tileEntity).operatingTicks / (double)((TileEntityFormulaicAssemblicator)GuiFormulaicAssemblicator.this.tileEntity).ticksRequired;
            }
        }, GuiProgress.ProgressBar.TALL_RIGHT, this, this.getGuiLocation(), 85, 42));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.EXTRA, this, this.getGuiLocation(), 5, 25).with(GuiSlot.SlotOverlay.FORMULA));
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.encodeFormulaButton = new GuiDisableableButton(0, this.field_147003_i + 7, this.field_147009_r + 45, 14, 14).with(GuiDisableableButton.ImageOverlay.ENCODE_FORMULA);
        this.field_146292_n.add(this.encodeFormulaButton);
        this.stockControlButton = new GuiDisableableButton(1, this.field_147003_i + 26, this.field_147009_r + 75, 16, 16).with(GuiDisableableButton.ImageOverlay.STOCK_CONTROL);
        this.field_146292_n.add(this.stockControlButton);
        this.fillEmptyButton = new GuiDisableableButton(2, this.field_147003_i + 44, this.field_147009_r + 75, 16, 16).with(GuiDisableableButton.ImageOverlay.FILL_EMPTY);
        this.field_146292_n.add(this.fillEmptyButton);
        this.craftSingleButton = new GuiDisableableButton(3, this.field_147003_i + 71, this.field_147009_r + 75, 16, 16).with(GuiDisableableButton.ImageOverlay.CRAFT_SINGLE);
        this.field_146292_n.add(this.craftSingleButton);
        this.craftAvailableButton = new GuiDisableableButton(4, this.field_147003_i + 89, this.field_147009_r + 75, 16, 16).with(GuiDisableableButton.ImageOverlay.CRAFT_AVAILABLE);
        this.field_146292_n.add(this.craftAvailableButton);
        this.autoModeButton = new GuiDisableableButton(5, this.field_147003_i + 107, this.field_147009_r + 75, 16, 16).with(GuiDisableableButton.ImageOverlay.AUTO_TOGGLE);
        this.field_146292_n.add(this.autoModeButton);
        this.updateEnabledButtons();
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == this.encodeFormulaButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(1)));
        } else if (guibutton.field_146127_k == this.stockControlButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(5)));
        } else if (guibutton.field_146127_k == this.fillEmptyButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(4)));
        } else if (guibutton.field_146127_k == this.craftSingleButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(2)));
        } else if (guibutton.field_146127_k == this.craftAvailableButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(3)));
        } else if (guibutton.field_146127_k == this.autoModeButton.field_146127_k) {
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, TileNetworkList.withContents(0)));
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateEnabledButtons();
    }

    private void updateEnabledButtons() {
        this.encodeFormulaButton.field_146124_l = !((TileEntityFormulaicAssemblicator)this.tileEntity).autoMode && ((TileEntityFormulaicAssemblicator)this.tileEntity).isRecipe && this.canEncode();
        this.stockControlButton.field_146124_l = ((TileEntityFormulaicAssemblicator)this.tileEntity).formula != null;
        this.fillEmptyButton.field_146124_l = !((TileEntityFormulaicAssemblicator)this.tileEntity).autoMode;
        this.craftSingleButton.field_146124_l = !((TileEntityFormulaicAssemblicator)this.tileEntity).autoMode && ((TileEntityFormulaicAssemblicator)this.tileEntity).isRecipe;
        this.craftAvailableButton.field_146124_l = !((TileEntityFormulaicAssemblicator)this.tileEntity).autoMode && ((TileEntityFormulaicAssemblicator)this.tileEntity).isRecipe;
        this.autoModeButton.field_146124_l = ((TileEntityFormulaicAssemblicator)this.tileEntity).formula != null;
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityFormulaicAssemblicator)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityFormulaicAssemblicator)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (this.fillEmptyButton.func_146115_a() && this.fillEmptyButton.field_146124_l) {
            this.displayTooltip(LangUtils.localize("gui.fillEmpty"), xAxis, yAxis);
        } else if (this.encodeFormulaButton.func_146115_a() && this.encodeFormulaButton.field_146124_l) {
            this.displayTooltip(LangUtils.localize("gui.encodeFormula"), xAxis, yAxis);
        } else if (this.craftSingleButton.func_146115_a() && this.craftSingleButton.field_146124_l) {
            this.displayTooltip(LangUtils.localize("gui.craftSingle"), xAxis, yAxis);
        } else if (this.craftAvailableButton.func_146115_a() && this.craftAvailableButton.field_146124_l) {
            this.displayTooltip(LangUtils.localize("gui.craftAvailable"), xAxis, yAxis);
        } else if (this.autoModeButton.func_146115_a() && this.autoModeButton.field_146124_l) {
            this.displayTooltip(LangUtils.localize("gui.autoModeToggle") + ": " + LangUtils.transOnOff(((TileEntityFormulaicAssemblicator)this.tileEntity).autoMode), xAxis, yAxis);
        } else if (this.stockControlButton.func_146115_a() && this.stockControlButton.field_146124_l) {
            this.displayTooltip(LangUtils.localize("gui.stockControl") + ": " + LangUtils.transOnOff(((TileEntityFormulaicAssemblicator)this.tileEntity).stockControl), xAxis, yAxis);
        } else if (xAxis >= -21 && xAxis <= -3 && yAxis >= 116 && yAxis <= 134) {
            boolean energy;
            ArrayList<String> info = new ArrayList<String>();
            boolean bl = energy = ((TileEntityFormulaicAssemblicator)this.tileEntity).getEnergy() < ((TileEntityFormulaicAssemblicator)this.tileEntity).energyPerTick || ((TileEntityFormulaicAssemblicator)this.tileEntity).getEnergy() == 0.0;
            if (energy) {
                info.add(LangUtils.localize("gui.no_energy"));
            }
            if (energy) {
                this.displayTooltips(info, xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        boolean energy;
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.field_146297_k.field_71446_o.func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.SLOT, "Slot_Icon.png"));
        this.func_73729_b(this.field_147003_i + 90, this.field_147009_r + 25, ((TileEntityFormulaicAssemblicator)this.tileEntity).isRecipe ? 2 : 20, 39, 14, 12);
        if (((TileEntityFormulaicAssemblicator)this.tileEntity).formula != null) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = (ItemStack)((TileEntityFormulaicAssemblicator)this.tileEntity).formula.input.get(i);
                if (stack.func_190926_b()) continue;
                Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i + 20);
                int guiX = this.field_147003_i + slot.field_75223_e;
                int guiY = this.field_147009_r + slot.field_75221_f;
                if (slot.func_75211_c().func_190926_b() || !((TileEntityFormulaicAssemblicator)this.tileEntity).formula.isIngredientInPos(((TileEntityFormulaicAssemblicator)this.tileEntity).func_145831_w(), slot.func_75211_c(), i)) {
                    this.drawColorIcon(guiX, guiY, EnumColor.DARK_RED, 0.8f);
                }
                this.renderItem(stack, guiX, guiY);
            }
        }
        boolean bl = energy = ((TileEntityFormulaicAssemblicator)this.tileEntity).getEnergy() < ((TileEntityFormulaicAssemblicator)this.tileEntity).energyPerTick || ((TileEntityFormulaicAssemblicator)this.tileEntity).getEnergy() == 0.0;
        if (energy) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.TAB, "Warning_Info.png"));
            this.func_73729_b(this.field_147003_i - 26, this.field_147009_r + 112, 0, 0, 26, 26);
            this.addGuiElement(new GuiWarningInfo(this, this.getGuiLocation(), false));
        }
    }

    private boolean canEncode() {
        if (((TileEntityFormulaicAssemblicator)this.tileEntity).formula != null) {
            return false;
        }
        ItemStack formulaStack = (ItemStack)((TileEntityFormulaicAssemblicator)this.tileEntity).inventory.get(2);
        return !formulaStack.func_190926_b() && formulaStack.func_77973_b() instanceof ItemCraftingFormula && ((ItemCraftingFormula)formulaStack.func_77973_b()).getInventory(formulaStack) == null;
    }
}

