/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import mekanism.api.energy.IStrictEnergyStorage;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiEnergyInfo;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiPlayerSlot;
import mekanism.client.gui.element.GuiPowerBar;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.GuiWarningInfo;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiUpgradeTab;
import mekanism.common.inventory.container.ContainerFluidicPlenisher;
import mekanism.common.tile.machine.TileEntityFluidicPlenisher;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiFluidicPlenisher
extends GuiMekanismTile<TileEntityFluidicPlenisher> {
    public GuiFluidicPlenisher(InventoryPlayer inventory, TileEntityFluidicPlenisher tile) {
        super(tile, new ContainerFluidicPlenisher(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 27, 19));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.NORMAL, this, resource, 27, 50));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.POWER, this, resource, 142, 34).with(GuiSlot.SlotOverlay.POWER));
        this.addGuiElement(new GuiPowerBar((IGuiWrapper)this, (IStrictEnergyStorage)((Object)this.tileEntity), resource, 164, 15));
        this.addGuiElement(new GuiFluidGauge(() -> ((TileEntityFluidicPlenisher)this.tileEntity).fluidTank, GuiGauge.Type.STANDARD, this, resource, 6, 13));
        this.addGuiElement(new GuiEnergyInfo(() -> {
            String multiplier = MekanismUtils.getEnergyDisplay(((TileEntityFluidicPlenisher)this.tileEntity).energyPerTick);
            return Arrays.asList(LangUtils.localize("gui.using") + ": " + multiplier + "/t", LangUtils.localize("gui.needed") + ": " + MekanismUtils.getEnergyDisplay(((TileEntityFluidicPlenisher)this.tileEntity).getMaxEnergy() - ((TileEntityFluidicPlenisher)this.tileEntity).getEnergy()));
        }, (IGuiWrapper)this, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiUpgradeTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiInnerScreen(this, resource, 48, 23, 80, 41));
        this.addGuiElement(new GuiPlayerSlot(this, resource));
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        boolean fluid;
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Other_Icon.png"));
        this.func_73729_b(this.field_147003_i + 32, this.field_147009_r + 39, 13, 0, 8, 9);
        boolean energy = ((TileEntityFluidicPlenisher)this.tileEntity).getEnergy() < ((TileEntityFluidicPlenisher)this.tileEntity).energyPerTick || ((TileEntityFluidicPlenisher)this.tileEntity).getEnergy() == 0.0;
        boolean bl = fluid = ((TileEntityFluidicPlenisher)this.tileEntity).fluidTank.getFluidAmount() == 0;
        if (fluid) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Warning.png"));
            this.func_73729_b(this.field_147003_i + 6 + 9, this.field_147009_r + 13 + 1, 9, 1, 8, 29);
            this.func_73729_b(this.field_147003_i + 6 + 9, this.field_147009_r + 13 + 31, 9, 32, 8, 28);
        }
        if (energy || fluid) {
            this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.TAB, "Warning_Info.png"));
            this.func_73729_b(this.field_147003_i - 26, this.field_147009_r + 112, 0, 0, 26, 26);
            this.addGuiElement(new GuiWarningInfo(this, this.getGuiLocation(), false));
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(((TileEntityFluidicPlenisher)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityFluidicPlenisher)this.tileEntity).func_70005_c_()) / 2, 4, 0x404040);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 94 + 2, 0x404040);
        this.field_146289_q.func_78276_b(MekanismUtils.getEnergyDisplay(((TileEntityFluidicPlenisher)this.tileEntity).getEnergy(), ((TileEntityFluidicPlenisher)this.tileEntity).getMaxEnergy()), 51, 26, -12779878);
        this.field_146289_q.func_78276_b(LangUtils.localize("gui.finished") + ": " + LangUtils.transYesNo(((TileEntityFluidicPlenisher)this.tileEntity).finishedCalc), 51, 35, -12779878);
        FluidStack fluid = ((TileEntityFluidicPlenisher)this.tileEntity).fluidTank.getFluid();
        this.field_146289_q.func_78276_b(fluid != null ? LangUtils.localizeFluidStack(fluid) + ": " + fluid.amount : LangUtils.localize("gui.noFluid"), 51, 44, -12779878);
        int xAxis = mouseX - this.field_147003_i;
        int yAxis = mouseY - this.field_147009_r;
        if (xAxis >= -21 && xAxis <= -3 && yAxis >= 116 && yAxis <= 134) {
            boolean fluidamount;
            ArrayList<String> info = new ArrayList<String>();
            boolean energy = ((TileEntityFluidicPlenisher)this.tileEntity).getEnergy() < ((TileEntityFluidicPlenisher)this.tileEntity).energyPerTick || ((TileEntityFluidicPlenisher)this.tileEntity).getEnergy() == 0.0;
            boolean bl = fluidamount = ((TileEntityFluidicPlenisher)this.tileEntity).fluidTank.getFluidAmount() == 0;
            if (energy) {
                info.add(LangUtils.localize("gui.no_energy"));
            }
            if (fluidamount) {
                info.add(LangUtils.localize("gui.no_fluid"));
            }
            if (energy || fluidamount) {
                this.displayTooltips(info, xAxis, yAxis);
            }
        }
        super.func_146979_b(mouseX, mouseY);
    }
}

