/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import mekanism.api.EnumColor;
import mekanism.api.TileNetworkList;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.render.MekanismRenderer;
import mekanism.client.sound.SoundHandler;
import mekanism.common.HashList;
import mekanism.common.Mekanism;
import mekanism.common.OreDictCache;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.filter.IMaterialFilter;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.content.filter.IOreDictFilter;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.prefab.TileEntityContainerBlock;
import mekanism.common.util.MekanismUtils;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;

@SideOnly(value=Side.CLIENT)
public abstract class GuiFilterHolder<TILE extends TileEntityContainerBlock, FILTER extends IFilter>
extends GuiMekanismTile<TILE> {
    protected final int filterX = 56;
    protected final int filterY = 18;
    protected final int filterW = 96;
    protected final int filterH = 29;
    protected Map<IOreDictFilter, StackData> oreDictStacks = new Object2ObjectOpenHashMap();
    protected Map<IModIDFilter, StackData> modIDStacks = new Object2ObjectOpenHashMap();
    protected boolean isDragging = false;
    protected float scroll;
    protected int stackSwitch;
    protected int dragOffset;
    protected final int BUTTON_NEW = 0;

    public GuiFilterHolder(TILE tile, Container container) {
        super(tile, container);
    }

    protected abstract HashList<FILTER> getFilters();

    public int getScroll() {
        return Math.max(Math.min((int)(this.scroll * 123.0f), 123), 0);
    }

    public int getFilterIndex() {
        if (this.needsScrollBars()) {
            int scrollSize = this.getFilters().size() - 4;
            return (int)(((double)scrollSize + 0.5) * (double)this.scroll);
        }
        return 0;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.stackSwitch > 0) {
            --this.stackSwitch;
        }
        if (this.stackSwitch == 0) {
            for (Map.Entry<IOreDictFilter, StackData> entry : this.oreDictStacks.entrySet()) {
                this.setNextRenderStack(entry.getValue());
            }
            for (Map.Entry<IFilter, StackData> entry : this.modIDStacks.entrySet()) {
                this.setNextRenderStack(entry.getValue());
            }
            this.stackSwitch = 20;
        } else {
            StackData data;
            for (Map.Entry<IOreDictFilter, StackData> entry : this.oreDictStacks.entrySet()) {
                data = entry.getValue();
                if (data.iterStacks == null || data.iterStacks.size() != 0) continue;
                data.renderStack = ItemStack.field_190927_a;
            }
            for (Map.Entry<IFilter, StackData> entry : this.modIDStacks.entrySet()) {
                data = entry.getValue();
                if (data.iterStacks == null || data.iterStacks.size() != 0) continue;
                data.renderStack = ItemStack.field_190927_a;
            }
        }
        ObjectOpenHashSet oreDictFilters = new ObjectOpenHashSet();
        ObjectOpenHashSet objectOpenHashSet = new ObjectOpenHashSet();
        HashList<FILTER> filters = this.getFilters();
        for (int i = 0; i < 4; ++i) {
            IFilter filter = (IFilter)filters.get(this.getFilterIndex() + i);
            if (filter instanceof IOreDictFilter) {
                oreDictFilters.add((IOreDictFilter)filter);
                continue;
            }
            if (!(filter instanceof IModIDFilter)) continue;
            objectOpenHashSet.add((IModIDFilter)filter);
        }
        for (IFilter filter : filters) {
            if (filter instanceof IOreDictFilter && !oreDictFilters.contains(filter)) {
                this.oreDictStacks.remove(filter);
                continue;
            }
            if (!(filter instanceof IModIDFilter) || objectOpenHashSet.contains(filter)) continue;
            this.modIDStacks.remove(filter);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        this.field_146297_k.func_110434_K().func_110577_a(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "Scroll_Icon.png"));
        this.func_73729_b(this.field_147003_i + 154, this.field_147009_r + 18 + this.getScroll(), 232 + (this.needsScrollBars() ? 0 : 12), 0, 12, 15);
        HashList<FILTER> filters = this.getFilters();
        for (int i = 0; i < 4; ++i) {
            IFilter filter = (IFilter)filters.get(this.getFilterIndex() + i);
            if (filter == null) continue;
            if (filter instanceof IItemStackFilter) {
                MekanismRenderer.color(EnumColor.INDIGO, 1.0f, 2.5f);
            } else if (filter instanceof IOreDictFilter) {
                MekanismRenderer.color(EnumColor.BRIGHT_GREEN, 1.0f, 2.5f);
            } else if (filter instanceof IMaterialFilter) {
                MekanismRenderer.color(EnumColor.PURPLE, 1.0f, 4.0f);
            } else if (filter instanceof IModIDFilter) {
                MekanismRenderer.color(EnumColor.PINK, 1.0f, 2.5f);
            }
            int yStart = i * 29 + 18;
            boolean mouseOver = xAxis >= 56 && xAxis <= 152 && yAxis >= yStart && yAxis <= yStart + 29;
            this.func_73729_b(this.field_147003_i + 56, this.field_147009_r + yStart, mouseOver ? 0 : 96, 0, 96, 29);
            MekanismRenderer.resetColor();
            int arrowX = 140;
            if (this.getFilterIndex() + i > 0) {
                mouseOver = xAxis >= arrowX && xAxis <= arrowX + 10 && yAxis >= yStart + 1 && yAxis <= yStart + 7;
                this.func_73729_b(this.field_147003_i + arrowX, this.field_147009_r + yStart + 1, mouseOver ? 220 : 209, 1, 11, 7);
            }
            if (this.getFilterIndex() + i >= filters.size() - 1) continue;
            mouseOver = xAxis >= arrowX && xAxis <= arrowX + 10 && yAxis >= yStart + 21 && yAxis <= yStart + 27;
            this.func_73729_b(this.field_147003_i + arrowX, this.field_147009_r + yStart + 21, mouseOver ? 220 : 209, 8, 11, 7);
        }
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int i = Mouse.getEventDWheel();
        if (i != 0 && this.needsScrollBars()) {
            int j = this.getFilters().size() - 4;
            i = i > 0 ? 1 : -1;
            this.scroll = (float)((double)this.scroll - (double)i / (double)j);
            if (this.scroll < 0.0f) {
                this.scroll = 0.0f;
            } else if (this.scroll > 1.0f) {
                this.scroll = 1.0f;
            }
        }
    }

    @Override
    protected void func_146273_a(int mouseX, int mouseY, int button, long ticks) {
        super.func_146273_a(mouseX, mouseY, button, ticks);
        if (this.isDragging) {
            int yAxis = mouseY - this.field_147009_r;
            this.scroll = Math.min(Math.max((float)(yAxis - 18 - this.dragOffset) / 123.0f, 0.0f), 1.0f);
        }
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int type) {
        super.func_146286_b(mouseX, mouseY, type);
        if (type == 0 && this.isDragging) {
            this.dragOffset = 0;
            this.isDragging = false;
        }
    }

    protected void updateStackList(IOreDictFilter filter) {
        if (!this.oreDictStacks.containsKey(filter)) {
            this.oreDictStacks.put(filter, new StackData());
        }
        this.oreDictStacks.get((Object)filter).iterStacks = OreDictCache.getOreDictStacks(filter.getOreDictName(), false);
        this.stackSwitch = 0;
        this.func_73876_c();
        this.oreDictStacks.get((Object)filter).stackIndex = -1;
    }

    protected void updateStackList(IModIDFilter filter) {
        if (!this.modIDStacks.containsKey(filter)) {
            this.modIDStacks.put(filter, new StackData());
        }
        this.modIDStacks.get((Object)filter).iterStacks = OreDictCache.getModIDStacks(filter.getModID(), false);
        this.stackSwitch = 0;
        this.func_73876_c();
        this.modIDStacks.get((Object)filter).stackIndex = -1;
    }

    protected void sendDataFromClick(TileNetworkList data) {
        Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
        SoundHandler.playSound(SoundEvents.field_187909_gi);
    }

    private void setNextRenderStack(StackData data) {
        if (data.iterStacks != null && data.iterStacks.size() > 0) {
            if (data.stackIndex == -1 || data.stackIndex == data.iterStacks.size() - 1) {
                data.stackIndex = 0;
            } else if (data.stackIndex < data.iterStacks.size() - 1) {
                ++data.stackIndex;
            }
            data.renderStack = data.iterStacks.get(data.stackIndex);
        }
    }

    protected boolean needsScrollBars() {
        return this.getFilters().size() > 4;
    }

    public static class StackData {
        public List<ItemStack> iterStacks;
        public int stackIndex;
        public ItemStack renderStack = ItemStack.field_190927_a;
    }
}

